/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.plugin.filter.PlugInFilter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;

public class FindIt_
implements PlugInFilter {
    ImagePlus imp;
    int width;
    int height;
    int fuzz;
    int minOffset;
    int maxOffset;
    int samplingFactor;
    int samplingBorder;
    int[] pixels;
    boolean debug;
    int offset;
    int top;
    int left;
    int right;
    int bottom;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return 31;
    }

    boolean matches(int x1, int y1, int x2, int y2) {
        int bpp = 3;
        int value1 = this.pixels[x1 + this.width * y1];
        int value2 = this.pixels[x2 + this.width * y2];
        for (int i = 0; i < bpp * 8; i += 8) {
            if (Math.abs((value1 >> i & 0xFF) - (value2 >> i & 0xFF)) <= this.fuzz) continue;
            return false;
        }
        return true;
    }

    double find_offset(int min, int max, int factor) {
        int[] histogram = new int[max + 1 - min];
        int count = 0;
        int maxIndex = 0;
        for (int i = min; i <= max; ++i) {
            for (int x = factor / 2; x < this.width - i; x += factor) {
                for (int y = factor / 2; y < this.height; y += factor) {
                    if (!this.matches(x, y, x + i, y) || this.matches(x, y, x + this.samplingBorder, y)) continue;
                    int n = i - min;
                    histogram[n] = histogram[n] + 1;
                }
            }
            count += histogram[i - min];
            if (histogram[maxIndex] >= histogram[i - min]) continue;
            maxIndex = i - min;
        }
        this.offset = min + maxIndex;
        return (double)histogram[maxIndex] / (double)count;
    }

    boolean find_top_left_corner(int minWidth, int minHeight) {
        int errors = 5;
        for (int x = 0; x < this.width - this.offset; ++x) {
            for (int y = 0; y < this.height - minHeight; ++y) {
                int h;
                int error = 0;
                for (h = 0; h < minHeight && this.matches(x, y + h, x + this.offset, y + h) && (this.matches(x + minWidth, y + h, x + minWidth + this.offset, y + h) || ++error < errors); ++h) {
                    error = 0;
                }
                if (h >= minHeight) {
                    this.top = y;
                    this.left = x;
                    return true;
                }
                y += h;
            }
        }
        return false;
    }

    boolean find_rectangle(int minWidth, int minHeight) {
        int x;
        if (!this.find_top_left_corner(minWidth, minHeight)) {
            return false;
        }
        int border = 2;
        int errors = 3;
        if (this.debug) {
            IJ.log((String)("found (" + this.left + "," + this.top + ")"));
        }
        this.right = this.left + minWidth;
        int error = 0;
        while (this.right < this.left + this.offset - 2 * border && (this.matches(this.right, this.top + border, this.right + this.bottom, this.top + border) && this.matches(this.right, this.top + 2 * border, this.right + this.bottom, this.top + 2 * border) || ++error < errors)) {
            ++this.right;
            error = 0;
        }
        if (this.debug) {
            IJ.log((String)("found right: " + this.right));
        }
        if (this.right == this.left + minWidth) {
            return false;
        }
        this.bottom = this.top + minHeight + border;
        error = 0;
        while (this.bottom < this.height && error < (this.right - this.left) / 2) {
            error = 0;
            for (x = this.left; x < this.right; ++x) {
                if (this.matches(x, this.bottom, x + this.offset, this.bottom)) continue;
                ++error;
            }
            ++this.bottom;
        }
        if (this.debug) {
            IJ.log((String)("found bottom: " + this.bottom));
        }
        --this.top;
        error = 0;
        while (this.top > 0 && error < (this.right - this.left) / 2) {
            error = 0;
            for (x = this.left; x < this.right; ++x) {
                if (this.matches(x, this.top, x + this.offset, this.top)) continue;
                ++error;
            }
            --this.top;
        }
        ++this.top;
        if (this.debug) {
            IJ.log((String)("found new top: " + this.top));
        }
        return true;
    }

    void add_slices(ImageStack stack) {
        int[] p2 = new int[this.pixels.length];
        int[] p3 = new int[this.pixels.length];
        for (int i = 0; i < this.pixels.length; ++i) {
            p2[i] = this.pixels[i];
            p3[i] = 0;
        }
        for (int y = this.top; y < this.bottom; ++y) {
            for (int x = this.left; x < this.right; ++x) {
                int i = x + this.width * y;
                p2[i] = this.pixels[i + this.offset];
                p2[i + this.offset] = this.pixels[i];
                p3[i] = 0;
                for (int j = 0; j < 24; j += 8) {
                    int n = i;
                    p3[n] = p3[n] | Math.abs((p2[i] >> j & 0xFF) - (this.pixels[i] >> j & 0xFF)) << j;
                }
            }
            p3[this.left + this.width * y] = -1;
            p3[this.right - 1 + this.width * y] = -1;
        }
        stack.addSlice("", (ImageProcessor)new ColorProcessor(this.width, this.height, this.pixels));
        stack.addSlice("", (ImageProcessor)new ColorProcessor(this.width, this.height, p2));
        stack.addSlice("", (ImageProcessor)new ColorProcessor(this.width, this.height, p3));
    }

    public void run(ImageProcessor ip) {
        ip = ip.convertToRGB();
        this.width = ip.getWidth();
        this.height = ip.getHeight();
        this.pixels = (int[])ip.getPixels();
        this.debug = false;
        GenericDialog gd = new GenericDialog("Parameters");
        gd.addNumericField("Fuzz", 25.0, 0);
        gd.addNumericField("MinOffset", (double)(this.width / 7), 0);
        gd.addNumericField("MaxOffset", (double)(this.width / 2), 0);
        gd.addNumericField("SamplingFactor", (double)(this.width / 40), 0);
        gd.addNumericField("SamplingBorder", 20.0, 0);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.fuzz = (int)gd.getNextNumber();
        this.minOffset = (int)gd.getNextNumber();
        this.maxOffset = (int)gd.getNextNumber();
        this.samplingFactor = (int)gd.getNextNumber();
        this.samplingBorder = (int)gd.getNextNumber();
        double confidence = this.find_offset(this.minOffset, this.maxOffset, this.samplingFactor);
        if (this.debug) {
            IJ.log((String)("Offset is " + this.offset + " (" + confidence * 100.0 + "%)"));
        }
        if (this.find_rectangle(this.offset / 2, this.offset / 2)) {
            ImageStack stack = new ImageStack(this.width, this.height);
            this.add_slices(stack);
            new ImagePlus("result", stack).show();
        }
    }
}

