/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.balloonSegmentation;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GUI;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.Overlay;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.gui.ShapeRoi;
import ij.gui.StackWindow;
import ij.gui.TextRoi;
import ij.gui.Toolbar;
import ij.io.OpenDialog;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.geom.GeneralPath;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import sc.fiji.balloonSegmentation.structure.Balloon;
import sc.fiji.balloonSegmentation.structure.BalloonPopulation;
import sc.fiji.balloonSegmentation.structure.BalloonSequence;
import sc.fiji.balloonSegmentation.utils.Watershed;

public class BalloonSegmentation_
extends JFrame
implements ActionListener,
AdjustmentListener,
ItemListener,
WindowListener,
KeyListener,
MouseListener,
MouseWheelListener,
PlugIn {
    static String title = "2D BALLOON SEGMENTATION";
    static int init_channel = 2;
    static int init_max_pixel = 40;
    static int init_HL = 500;
    static int init_min_I = 80;
    static int init_max_I = 240;
    Balloon bal1;
    static BalloonPopulation pop;
    static BalloonSequence popSequence;
    static Watershed WAT;
    static int selected_cell;
    static int currentSlice;
    static int[] currentStage;
    static boolean is_movepoint;
    static int id_movepoint;
    static ImagePlus i1;
    static ImageProcessor ipWallSegment;
    static ImageProcessor ipNuclSegment;
    static int channel;
    static ImageCanvas ic;
    static StackWindowRoi sw;
    static GeneralPath shape;
    static Font font;
    FontMetrics fontMetrics = this.getFontMetrics(font);
    static RoiManager MROI;
    static Overlay OL;
    public static PrintWriter print_writer;
    public static String files_dir;
    static String[] file_list;
    private JSlider PixelLevel;
    private BoxLayout mainLayout;
    private BoxLayout pixelLayout;
    private GridBagLayout ActionLayout;
    private GridBagConstraints constraint;
    private GridLayout boundsLayout;
    private GridLayout centerLayout;
    private GridLayout inflateLayout;
    private GridLayout resultsLayout;
    private GridLayout buttonsLayout;
    private JButton bnBound;
    private JButton bnInflate;
    private JButton bnRefine;
    private JButton bnOptimize;
    private JButton bnClose;
    private JButton bnSample;
    private JButton bnFromROI;
    private JToggleButton bnEdit;
    private JButton bnClear;
    private JButton bnShow;
    private JButton bnModify;
    private JButton bnOpen;
    private JButton bnCapture;
    private JTextField txtPixLevel;
    private JTextField txtRem;
    private JTextField txtHL;
    private JTextField txtCellID;
    private JTextField txtIniLevel;
    private JTextField txtEndLevel;
    private Checkbox ChkProcessAll1;
    private Checkbox ChkProcessAll2;
    private Checkbox chkLog;
    private JComboBox showOptionsList;
    private JComboBox editOptionsList;
    int min_pix_level = 0;
    int max_pix_level = 100;

    public void run(String arg) {
        i1 = IJ.getImage();
        if (i1 == null) {
            IJ.noImage();
            return;
        }
        ic = i1.getCanvas();
        sw = new StackWindowRoi(i1, ic);
        i1.setWindow((ImageWindow)sw);
    }

    public BalloonSegmentation_() {
        super("2D BALLOON SEGMENTATION");
        System.out.println("");
        System.out.println("");
        System.out.println("*******************************************************************");
        System.out.println("");
        System.out.println("Balloon Plugin for segmentation of plant cellular architectures");
        System.out.println("");
        System.out.println("Lionel Dupuy, JHI@Dundee");
        System.out.println("");
        System.out.println("*******************************************************************");
        System.out.println("");
        System.out.println("");
        this.loadProperties();
        this.doDialog();
        this.InitiateSegmentation();
    }

    public void InitiateSegmentation() {
        i1.setOverlay(null);
        i1.killRoi();
        Toolbar Tb = Toolbar.getInstance();
        Tb.setTool(12);
        if (i1.getType() != 0) {
            IJ.error((String)"Sorry, this plugin currently works with 8bit grey scale images!");
            this.dispose();
            return;
        }
        ImageStack stack1 = i1.getStack();
        popSequence = new BalloonSequence(i1);
        currentStage = new int[i1.getStackSize()];
        IJ.showStatus((String)"Loading");
        IJ.showProgress((double)0.0);
        for (int i = 0; i < i1.getStackSize(); ++i) {
            IJ.showProgress((double)((double)i / (double)i1.getStackSize()));
            IJ.showStatus((String)("Slice/Image-file: " + i + "/" + i1.getStackSize()));
            this.InitiateImageData(3, i + 1);
            if (ipWallSegment == null) continue;
            ipWallSegment.setProgressBar(null);
            popSequence.setSequence(i, ipWallSegment, 3);
        }
        IJ.showStatus((String)"");
        IJ.showProgress((double)1.0);
        currentSlice = i1.getCurrentSlice();
        ipWallSegment = i1.getStack().getProcessor(i1.getCurrentSlice());
        pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
    }

    public void InitiateImageData(int channel, int slice) {
        ImageStack stack1 = i1.getStack();
        currentSlice = slice;
        ipWallSegment = stack1.getProcessor(currentSlice);
        BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = -1;
        i1.updateAndDraw();
        int w = ipWallSegment.getWidth();
        int h = ipWallSegment.getHeight();
    }

    private void loadProperties() {
        Properties tempProp = new Properties();
        try {
            InputStream propsFile = this.getClass().getResourceAsStream("/BalloonSegmentation.properties");
            tempProp.load(propsFile);
            propsFile.close();
            init_channel = Integer.parseInt(tempProp.getProperty("init_channel"));
            init_max_pixel = Integer.parseInt(tempProp.getProperty("init_max_pixel"));
            init_HL = Integer.parseInt(tempProp.getProperty("init_HL"));
            init_min_I = Integer.parseInt(tempProp.getProperty("init_min_I"));
            init_max_I = Integer.parseInt(tempProp.getProperty("init_max_I"));
        }
        catch (IOException ioe) {
            IJ.error((String)"I/O Exception: cannot read .properties file");
        }
    }

    public void FindImgBoundaries(int PixLevel) {
        WAT = new Watershed(ipWallSegment);
        WAT.Flow_bound(PixLevel);
        int[][][] IMB = new int[BalloonSegmentation_.WAT.sx][BalloonSegmentation_.WAT.sy][3];
        IMB = BalloonSegmentation_.WAT.IMB;
        pop.set_boundaries(IMB);
    }

    static void InitiateDraw() {
        shape = new GeneralPath();
        i1.setOverlay(null);
        OL = new Overlay();
    }

    static void ClearMarks() {
        if (pop != null) {
            pop.clear();
        }
        BalloonSegmentation_.ClearDraw();
        i1.setOverlay(null);
        OL = new Overlay();
    }

    static void ClearDraw() {
        shape = new GeneralPath();
        i1.setOverlay(null);
        OL = new Overlay();
    }

    static void drawBounds() {
        if (currentStage[currentSlice - 1] > 0) {
            ImageStack stack1 = i1.getStack();
            ImageProcessor ip1 = stack1.getProcessor(currentSlice);
            pop.EnvelopBoundaries();
            if (BalloonSegmentation_.pop.YYi.length > 0) {
                PolygonRoi Proi = new PolygonRoi(BalloonSegmentation_.pop.XXi, BalloonSegmentation_.pop.YYi, BalloonSegmentation_.pop.YYi.length, 2);
                Proi.setStrokeColor(Color.red);
                Proi.setStrokeWidth(3.0f);
                OL.add((Roi)Proi);
            }
            selected_cell = -1;
        }
    }

    static void drawCellID() {
        if (currentStage[currentSlice - 1] > 1) {
            for (int i = 0; i < BalloonSegmentation_.pop.N; ++i) {
                float xc = BalloonSegmentation_.pop.BallList.get((int)i).x0;
                float yc = BalloonSegmentation_.pop.BallList.get((int)i).y0;
                float arm = 5.0f;
                TextRoi TROI = new TextRoi((int)xc, (int)yc, "" + i, new Font("SansSerif", 1, 12));
                TROI.setNonScalable(false);
                OL.add((Roi)TROI);
            }
        }
    }

    static void drawCrosses() {
        if (currentStage[currentSlice - 1] > 1) {
            for (int i = 0; i < BalloonSegmentation_.pop.N; ++i) {
                float xc = BalloonSegmentation_.pop.BallList.get((int)i).x0;
                float yc = BalloonSegmentation_.pop.BallList.get((int)i).y0;
                float arm = 5.0f;
                GeneralPath Nshape = new GeneralPath();
                Nshape.moveTo(xc - arm, yc);
                Nshape.lineTo(xc + arm, yc);
                Nshape.moveTo(xc, yc - arm);
                Nshape.lineTo(xc, yc + arm);
                ShapeRoi XROI = new ShapeRoi((Shape)Nshape);
                OL.add((Roi)XROI);
            }
        }
    }

    static void drawTopo() {
        if (currentStage[currentSlice - 1] > 2) {
            int N = BalloonSegmentation_.pop.N;
            ArrayList<Balloon> balloons = BalloonSegmentation_.pop.BallList;
            for (int i = 0; i < N; ++i) {
                Point P1 = balloons.get(i).getPoint();
                float x1 = (float)P1.getX();
                float y1 = (float)P1.getY();
                for (int j = 0; j < i; ++j) {
                    if (!BalloonSegmentation_.pop.topo[i][j]) continue;
                    GeneralPath Tshape = new GeneralPath();
                    Point P2 = balloons.get(j).getPoint();
                    float x2 = (float)P2.getX();
                    float y2 = (float)P2.getY();
                    Tshape.moveTo(x1, y1);
                    Tshape.lineTo(x2, y2);
                    ShapeRoi XROI = new ShapeRoi((Shape)Tshape);
                    XROI.setStrokeWidth(1.0f);
                    XROI.setStrokeColor(Color.green);
                    OL.add((Roi)XROI);
                }
            }
        }
    }

    static void drawContacts() {
        if (currentStage[currentSlice - 1] > 3) {
            int N = BalloonSegmentation_.pop.N;
            ArrayList<Balloon> balloons = BalloonSegmentation_.pop.BallList;
            for (int i = 0; i < N; ++i) {
                Point P1 = balloons.get(i).getPoint();
                float x1 = (float)P1.getX();
                float y1 = (float)P1.getY();
                block1: for (int j = 0; j < i; ++j) {
                    for (int k = 0; k < BalloonSegmentation_.pop.BallList.get((int)i).n0; ++k) {
                        if (BalloonSegmentation_.pop.contacts[i][k] != j) continue;
                        GeneralPath Cshape = new GeneralPath();
                        Point P2 = balloons.get(j).getPoint();
                        float x2 = (float)P2.getX();
                        float y2 = (float)P2.getY();
                        Cshape.moveTo(x1, y1);
                        Cshape.lineTo(x2, y2);
                        ShapeRoi XROI = new ShapeRoi((Shape)Cshape);
                        OL.add((Roi)XROI);
                        continue block1;
                    }
                }
            }
        }
    }

    static void drawPop() {
        if (currentStage[currentSlice - 1] > 3) {
            int N = BalloonSegmentation_.pop.N;
            for (int i = 0; i < N; ++i) {
                Balloon bal = BalloonSegmentation_.pop.BallList.get(i);
                int n = bal.XX.length;
                boolean isToDraw = true;
                Balloon B0 = BalloonSegmentation_.pop.BallList.get(i);
                B0.mass_geometry();
                if (BalloonSegmentation_.pop.contacts != null) {
                    for (int k = 0; k < B0.n0; ++k) {
                        if (BalloonSegmentation_.pop.contacts[i][k] != -1) continue;
                        isToDraw = true;
                        break;
                    }
                }
                shape.setWindingRule(0);
                if (!isToDraw) continue;
                PolygonRoi Proi = B0.Proi;
                Proi.setStrokeColor(Color.red);
                Proi.setStrokeWidth(3.0f);
                OL.add((Roi)Proi);
            }
        }
    }

    static void makeROI() {
        int N = BalloonSegmentation_.pop.N;
        for (int i = 0; i < N; ++i) {
            Balloon bal = BalloonSegmentation_.pop.BallList.get(i);
            int n = bal.XX.length;
            boolean isToDraw = true;
            Balloon B0 = BalloonSegmentation_.pop.BallList.get(i);
            B0.mass_geometry();
            if (BalloonSegmentation_.pop.contacts != null) {
                for (int k = 0; k < B0.n0; ++k) {
                    if (BalloonSegmentation_.pop.contacts[i][k] != -1) continue;
                    isToDraw = true;
                    break;
                }
            }
            shape.setWindingRule(0);
            if (!isToDraw) continue;
            PolygonRoi Proi = B0.Proi;
            MROI.add(i1, (Roi)Proi, i);
        }
    }

    static void showOverlay() {
        i1.setOverlay(OL);
    }

    public static void makeOverlayCurrent(int stage) {
        if (stage > 0) {
            BalloonSegmentation_.InitiateDraw();
            BalloonSegmentation_.drawBounds();
        }
        if (stage > 1) {
            BalloonSegmentation_.drawCrosses();
            BalloonSegmentation_.drawCellID();
        }
        if (stage > 2 & stage < 4) {
            BalloonSegmentation_.drawTopo();
        }
        if (stage > 3) {
            BalloonSegmentation_.drawPop();
        }
    }

    public static void drawCurrent() {
        currentSlice = i1.getCurrentSlice();
        pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
        ipWallSegment = i1.getStack().getProcessor(currentSlice);
        BalloonSegmentation_.ClearDraw();
        BalloonSegmentation_.makeOverlayCurrent(currentStage[i1.getCurrentSlice() - 1]);
        BalloonSegmentation_.showOverlay();
    }

    public void InitiateBalloons(ArrayList X0, ArrayList Y0) {
        currentSlice = i1.getCurrentSlice();
        ipWallSegment = i1.getStack().getProcessor(i1.getCurrentSlice());
        popSequence.setSequence(currentSlice - 1, ipWallSegment, X0, Y0, channel);
        pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
    }

    public void InitiateBalloons(int x0, int y0) {
        currentSlice = i1.getCurrentSlice();
        ipWallSegment = i1.getStack().getProcessor(i1.getCurrentSlice());
        pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
        pop.AddNewBalloon(x0, y0);
        pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
    }

    public void RemoveBalloons(int x0, int y0) {
        currentSlice = i1.getCurrentSlice();
        ipWallSegment = i1.getStack().getProcessor(i1.getCurrentSlice());
        pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
        double min_distance = 100000.0;
        int candidate = -1;
        for (int i = 0; i < BalloonSegmentation_.pop.BallList.size(); ++i) {
            Point P = BalloonSegmentation_.pop.BallList.get(i).getPoint();
            double d = ((double)x0 - P.getX()) * ((double)x0 - P.getX()) + ((double)y0 - P.getY()) * ((double)y0 - P.getY());
            if (!(d < min_distance)) continue;
            candidate = i;
            min_distance = d;
        }
        if (min_distance < 64.0) {
            pop.remove(candidate);
        }
        pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
    }

    public void MoveBalloons(int x0, int y0) {
        if (!is_movepoint) {
            double min_distance = 100000.0;
            int candidate = -1;
            for (int i = 0; i < BalloonSegmentation_.pop.BallList.size(); ++i) {
                Point P = BalloonSegmentation_.pop.BallList.get(i).getPoint();
                double d = ((double)x0 - P.getX()) * ((double)x0 - P.getX()) + ((double)y0 - P.getY()) * ((double)y0 - P.getY());
                if (!(d < min_distance)) continue;
                candidate = i;
                min_distance = d;
            }
            if (min_distance > 64.0) {
                id_movepoint = -1;
            } else {
                is_movepoint = true;
                id_movepoint = candidate;
            }
        } else if (is_movepoint & id_movepoint > -1) {
            Balloon B = BalloonSegmentation_.pop.BallList.get(id_movepoint);
            B.translateTo(x0, y0);
            is_movepoint = false;
            id_movepoint = -1;
        }
    }

    public boolean write2File(String directory, String file_name, String info) {
        try {
            FileOutputStream fos = new FileOutputStream(directory + file_name);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            print_writer = new PrintWriter(bos);
            print_writer.print(info);
            print_writer.close();
            return true;
        }
        catch (IOException e) {
            IJ.error((String)"File could not be written properly in write2File");
            return false;
        }
    }

    public void makeReport() {
        if (currentStage[currentSlice - 1] > 1) {
            ResultsTable rt = new ResultsTable();
            for (int j = 0; j < BalloonSegmentation_.popSequence.N; ++j) {
                pop = BalloonSegmentation_.popSequence.PopList[j];
                int N = BalloonSegmentation_.pop.N;
                for (int i = 0; i < N; ++i) {
                    rt.incrementCounter();
                    Balloon bal = BalloonSegmentation_.pop.BallList.get(i);
                    bal.mass_geometry();
                    rt.addValue("X", (double)bal.x0);
                    rt.addValue("Y", (double)bal.y0);
                    rt.addValue("Z", (double)j);
                    rt.addValue("ID", (double)bal.id);
                    rt.addValue("AREA", bal.area);
                    rt.addValue("Ixx", bal.Ixx);
                    rt.addValue("Iyy", bal.Iyy);
                    rt.addValue("Ixy", bal.Ixy);
                    rt.addValue("Lx", bal.lx);
                    rt.addValue("Ly", bal.ly);
                }
            }
            rt.show("Report");
            currentSlice = i1.getCurrentSlice();
            ipWallSegment = i1.getStack().getProcessor(i1.getCurrentSlice());
            pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
        }
    }

    public void clearAll() {
        BalloonSegmentation_.ClearMarks();
        pop = null;
        popSequence = null;
        i1.killRoi();
        ic.removeMouseListener((MouseListener)this);
        ic.removeKeyListener((KeyListener)this);
        StackWindow sw1 = new StackWindow(i1, ic);
        i1.setWindow((ImageWindow)sw1);
        this.dispose();
    }

    private void doDialog() {
        this.ActionLayout = new GridBagLayout();
        this.constraint = new GridBagConstraints();
        this.boundsLayout = new GridLayout(1, 2, 10, 10);
        this.centerLayout = new GridLayout(4, 2, 10, 10);
        this.inflateLayout = new GridLayout(1, 2, 10, 10);
        this.resultsLayout = new GridLayout(3, 2, 10, 10);
        this.buttonsLayout = new GridLayout(1, 2, 10, 10);
        this.PixelLevel = new JSlider(1, this.min_pix_level, this.max_pix_level, init_max_pixel);
        this.PixelLevel.setMajorTickSpacing(10);
        this.PixelLevel.setMinorTickSpacing(2);
        this.PixelLevel.setPaintTicks(true);
        this.PixelLevel.setPaintLabels(true);
        this.PixelLevel.addMouseWheelListener(this);
        this.bnBound = new JButton(" Bounds ");
        this.bnBound.setBackground(new Color(255, 200, 200));
        this.bnSample = new JButton("Sample (H*L)");
        this.bnSample.setBackground(Color.LIGHT_GRAY);
        this.bnFromROI = new JButton("From ROI manager");
        this.bnFromROI.setBackground(Color.LIGHT_GRAY);
        this.bnEdit = new JToggleButton(" Manual ");
        this.bnEdit.setBackground(Color.LIGHT_GRAY);
        this.bnOpen = new JButton("    Import    ");
        this.bnOpen.setBackground(Color.LIGHT_GRAY);
        this.bnInflate = new JButton(" Inflate ");
        this.bnInflate.setBackground(new Color(255, 200, 200));
        this.bnClose = new JButton("    Close   ");
        this.bnModify = new JButton("Modify (Cell #)");
        this.bnModify.setBackground(Color.LIGHT_GRAY);
        this.bnCapture = new JButton("    Capture    ");
        this.bnCapture.setBackground(Color.LIGHT_GRAY);
        this.bnClear = new JButton(" Clear ");
        this.txtRem = new JTextField("0", 1);
        this.txtHL = new JTextField("" + init_HL, 1);
        this.txtCellID = new JTextField("0", 1);
        this.ChkProcessAll1 = new Checkbox("Process All", false);
        this.ChkProcessAll2 = new Checkbox("Process All", false);
        String[] showOptions = new String[]{"Bounds", "Centres", "Interactions", "Neighbours", "Cells", "Report"};
        this.showOptionsList = new JComboBox<String>(showOptions);
        this.showOptionsList.setSelectedIndex(0);
        this.showOptionsList.addActionListener(this);
        String[] editOptions = new String[]{"Add", "Move", "Del"};
        this.editOptionsList = new JComboBox<String>(editOptions);
        this.editOptionsList.setSelectedIndex(0);
        JPanel pnMain = new JPanel();
        this.mainLayout = new BoxLayout(pnMain, 0);
        JPanel pnAction = new JPanel();
        JPanel pnBounds = new JPanel();
        Border bd = BorderFactory.createBevelBorder(0);
        pnBounds.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bd, "Find Boundaries"), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        JPanel pnCenter = new JPanel();
        pnCenter.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bd, "Find Centers"), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        JPanel pnInflate = new JPanel();
        pnInflate.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bd, "Cell Detection"), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        JPanel pnResults = new JPanel();
        pnResults.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bd, "Show Results"), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        JPanel pnButtons = new JPanel();
        JPanel pnPixel = new JPanel();
        this.pixelLayout = new BoxLayout(pnPixel, 0);
        pnPixel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(bd, "Pixel I."), BorderFactory.createEmptyBorder(7, 7, 7, 7)));
        pnPixel.add(this.PixelLevel);
        pnPixel.setLayout(this.pixelLayout);
        pnMain.setLayout(this.mainLayout);
        pnAction.setLayout(this.ActionLayout);
        pnBounds.add(this.ChkProcessAll1);
        pnBounds.add(this.bnBound);
        pnBounds.setLayout(this.boundsLayout);
        pnCenter.add(this.editOptionsList);
        pnCenter.add(this.bnEdit);
        pnCenter.add(this.txtHL);
        pnCenter.add(this.bnSample);
        pnCenter.add(this.bnFromROI);
        pnCenter.add(new Label(""));
        pnCenter.add(this.bnOpen);
        pnCenter.setLayout(this.centerLayout);
        pnInflate.add(this.ChkProcessAll2);
        pnInflate.add(this.bnInflate);
        pnInflate.setLayout(this.inflateLayout);
        pnResults.add(new Label(""));
        pnResults.add(this.showOptionsList);
        pnResults.add(this.txtCellID);
        pnResults.add(this.bnModify);
        pnResults.add(new Label(""));
        pnResults.add(this.bnCapture);
        pnResults.setLayout(this.resultsLayout);
        pnButtons.add(this.bnClear);
        pnButtons.add(this.bnClose);
        pnButtons.setLayout(this.buttonsLayout);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                BalloonSegmentation_.this.clearAll();
            }
        });
        this.bnBound.addActionListener(this);
        this.bnSample.addActionListener(this);
        this.bnFromROI.addActionListener(this);
        this.bnClear.addActionListener(this);
        this.bnEdit.addActionListener(this);
        this.bnClose.addActionListener(this);
        this.bnInflate.addActionListener(this);
        this.bnModify.addActionListener(this);
        this.bnOpen.addActionListener(this);
        this.bnCapture.addActionListener(this);
        i1 = WindowManager.getCurrentImage();
        ic = i1.getCanvas();
        ic.addKeyListener((KeyListener)this);
        ic.addMouseListener((MouseListener)this);
        this.addComponent(pnAction, 1, 0, 1, 1, 5, pnBounds);
        this.addComponent(pnAction, 2, 0, 1, 1, 5, pnCenter);
        this.addComponent(pnAction, 3, 0, 1, 1, 5, pnInflate);
        this.addComponent(pnAction, 4, 0, 1, 1, 5, pnResults);
        this.addComponent(pnAction, 5, 0, 1, 1, 5, pnButtons);
        pnMain.add(pnAction);
        pnMain.add(Box.createRigidArea(new Dimension(10, 0)));
        pnMain.add(pnPixel);
        this.add(pnMain);
        this.pack();
        this.setResizable(true);
        GUI.center((Window)this);
        this.setVisible(true);
        Point IJ_location = IJ.getInstance().getLocation();
        int Dialog_width = this.getWidth();
        int XX = (int)(IJ_location.getX() + (double)IJ.getInstance().getWidth() - (double)Dialog_width);
        int YY = (int)(IJ_location.getY() + (double)IJ.getInstance().getHeight());
        Point Dialog_pos = new Point(XX, YY);
        this.setLocation(Dialog_pos);
    }

    private final void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.constraint.gridx = col;
        this.constraint.gridy = row;
        this.constraint.gridwidth = width;
        this.constraint.gridheight = height;
        this.constraint.anchor = 18;
        this.constraint.insets = new Insets(space, space, space, space);
        this.constraint.weightx = IJ.isMacintosh() ? 90.0 : 100.0;
        this.constraint.fill = 2;
        this.ActionLayout.setConstraints(comp, this.constraint);
        pn.add(comp);
    }

    @Override
    public synchronized void adjustmentValueChanged(AdjustmentEvent e) {
        this.notify();
    }

    @Override
    public synchronized void actionPerformed(ActionEvent e) {
        int id;
        Toolbar Tb = Toolbar.getInstance();
        if (e.getSource() == this.bnBound) {
            if (this.ChkProcessAll1.getState()) {
                for (int i = 0; i < i1.getStackSize(); ++i) {
                    currentSlice = i + 1;
                    pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
                    ipWallSegment = i1.getStack().getProcessor(currentSlice);
                    IJ.showStatus((String)("Find bounds slice: " + (i + 1)));
                    int pix_level = this.PixelLevel.getValue();
                    this.FindImgBoundaries(pix_level);
                    BalloonSegmentation_.InitiateDraw();
                    BalloonSegmentation_.drawBounds();
                    BalloonSegmentation_.drawCellID();
                    BalloonSegmentation_.drawCrosses();
                    BalloonSegmentation_.showOverlay();
                    BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 1;
                    Tb.setTool(0);
                    this.bnEdit.setSelected(false);
                }
                IJ.showStatus((String)"");
            } else {
                currentSlice = i1.getCurrentSlice();
                ipWallSegment = i1.getStack().getProcessor(currentSlice);
                pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
                IJ.showStatus((String)"Find object bounds ");
                int pix_level = this.PixelLevel.getValue();
                this.FindImgBoundaries(pix_level);
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.drawCrosses();
                BalloonSegmentation_.showOverlay();
                BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 1;
                Tb.setTool(0);
                this.bnEdit.setSelected(false);
                IJ.showStatus((String)"");
            }
            currentSlice = i1.getCurrentSlice();
            ipWallSegment = i1.getStack().getProcessor(currentSlice);
            pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
            BalloonSegmentation_.InitiateDraw();
            BalloonSegmentation_.drawBounds();
            BalloonSegmentation_.drawCellID();
            BalloonSegmentation_.drawCrosses();
            BalloonSegmentation_.showOverlay();
            BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 1;
        }
        if (e.getSource() == this.bnSample) {
            if (currentStage[currentSlice - 1] >= 1) {
                i1.killRoi();
                float HL = Float.valueOf(this.txtHL.getText()).floatValue();
                pop.sample(HL);
                BalloonSegmentation_.ClearDraw();
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.drawCrosses();
                BalloonSegmentation_.showOverlay();
                BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 2;
                Tb.setTool(12);
                this.bnEdit.setSelected(true);
            } else {
                IJ.error((String)"You must use find the boundaries first");
            }
        }
        if (e.getSource() == this.bnEdit) {
            if (currentStage[currentSlice - 1] >= 1) {
                BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 3;
                i1.killRoi();
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawCrosses();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.showOverlay();
                is_movepoint = false;
                id_movepoint = -1;
                Tb.setTool(12);
            } else {
                IJ.error((String)"You must find the boundaries");
            }
        }
        if (e.getSource() == this.bnFromROI && currentStage[currentSlice - 1] >= 1) {
            Roi[] rois = this.getRois();
            double[] Xpositions = new double[rois.length];
            double[] Ypositions = new double[rois.length];
            boolean isCurrentStageCorrect = true;
            for (int i = 0; i < rois.length; ++i) {
                i1.setRoi(rois[i]);
                ImageStatistics stats = i1.getStatistics(32);
                Xpositions[i] = stats.xCentroid;
                Ypositions[i] = stats.yCentroid;
                int slice = currentSlice - 1;
                if (currentStage[slice] >= 1) {
                    pop = BalloonSegmentation_.popSequence.PopList[slice];
                    pop.AddNewBalloon((int)Xpositions[i], (int)Ypositions[i]);
                    BalloonSegmentation_.currentStage[slice] = 2;
                    continue;
                }
                isCurrentStageCorrect = false;
            }
            currentSlice = i1.getCurrentSlice();
            ipWallSegment = i1.getStack().getProcessor(currentSlice);
            pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
            BalloonSegmentation_.ClearDraw();
            BalloonSegmentation_.InitiateDraw();
            BalloonSegmentation_.drawBounds();
            BalloonSegmentation_.drawCellID();
            BalloonSegmentation_.drawCrosses();
            BalloonSegmentation_.showOverlay();
            BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 2;
            this.bnEdit.setSelected(true);
        }
        if (e.getSource() == this.bnOpen) {
            String pts_ext;
            String ext;
            OpenDialog od = new OpenDialog("Open structure", IJ.getDirectory((String)"image"), "");
            files_dir = od.getDirectory();
            if (files_dir == null) {
                return;
            }
            file_list = new File(od.getDirectory()).list();
            int dotPlace = od.getFileName().lastIndexOf(46);
            if (dotPlace > 1 & (ext = od.getFileName().substring(dotPlace + 1)).compareTo(pts_ext = "txt") == 0) {
                ArrayList<double[]> SeedList = popSequence.importSeeds(od.getDirectory(), od.getFileName(), currentSlice);
                boolean isCurrentStageCorrect = true;
                for (int i = 0; i < SeedList.size(); ++i) {
                    double[] row = SeedList.get(i);
                    int slice = currentSlice - 1;
                    if (row[2] >= 0.0) {
                        slice = (int)row[2];
                    }
                    if (currentStage[slice] >= 1) {
                        pop = BalloonSegmentation_.popSequence.PopList[slice];
                        pop.AddNewBalloon((int)row[0], (int)row[1]);
                        BalloonSegmentation_.currentStage[slice] = 2;
                        continue;
                    }
                    isCurrentStageCorrect = false;
                }
                if (!isCurrentStageCorrect) {
                    IJ.error((String)"Some seeds were not used because object boundaries not found on some slices");
                }
            }
            currentSlice = i1.getCurrentSlice();
            ipWallSegment = i1.getStack().getProcessor(currentSlice);
            pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
            i1.killRoi();
            BalloonSegmentation_.InitiateDraw();
            BalloonSegmentation_.drawBounds();
            BalloonSegmentation_.drawCellID();
            BalloonSegmentation_.drawCrosses();
            BalloonSegmentation_.showOverlay();
            this.bnEdit.setSelected(false);
        }
        if (e.getSource() == this.bnInflate) {
            if (this.ChkProcessAll2.getState()) {
                for (int i = 0; i < i1.getStackSize(); ++i) {
                    currentSlice = i + 1;
                    pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
                    ipWallSegment = i1.getStack().getProcessor(currentSlice);
                    IJ.showStatus((String)("Find bounds slice: " + (i + 1)));
                    if (currentStage[currentSlice - 1] >= 2) {
                        if (currentStage[currentSlice - 1] < 3) {
                            pop.InitiateGrowingRegion();
                            pop.MakeTopo();
                            BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 3;
                        }
                    } else {
                        IJ.error((String)"You must select seeds");
                    }
                    if (currentStage[currentSlice - 1] < 3) continue;
                    if (currentStage[currentSlice - 1] < 4) {
                        pop.InitiateGrowingRegion();
                        pop.MakeTopo();
                    }
                    i1.killRoi();
                    int ninc = 100;
                    int ini = this.PixelLevel.getValue();
                    for (int t = 1; t < ninc + 1; ++t) {
                        pop.Tick_inflate(ini, t);
                        if (t % 10 != 0) continue;
                        BalloonSegmentation_.showOverlay();
                        IJ.showStatus((String)("Inflate: " + (int)((double)t / (double)ninc * 100.0) + "%"));
                    }
                    IJ.showProgress((double)1.0);
                    IJ.showStatus((String)"");
                    pop.refineStructure();
                    pop.mass_Geometry();
                    BalloonSegmentation_.InitiateDraw();
                    BalloonSegmentation_.drawBounds();
                    BalloonSegmentation_.drawCellID();
                    BalloonSegmentation_.drawCrosses();
                    BalloonSegmentation_.drawPop();
                    BalloonSegmentation_.showOverlay();
                    BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 4;
                    Tb.setTool(12);
                    this.bnEdit.setSelected(false);
                }
                currentSlice = i1.getCurrentSlice();
                ipWallSegment = i1.getStack().getProcessor(currentSlice);
                pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.drawCrosses();
                BalloonSegmentation_.drawPop();
                BalloonSegmentation_.showOverlay();
                IJ.showStatus((String)"");
            } else {
                if (currentStage[currentSlice - 1] >= 2) {
                    if (currentStage[currentSlice - 1] < 3) {
                        pop.InitiateGrowingRegion();
                        pop.MakeTopo();
                        BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 3;
                    }
                } else {
                    IJ.error((String)"You must select seeds");
                }
                if (currentStage[currentSlice - 1] >= 3) {
                    if (currentStage[currentSlice - 1] < 4) {
                        pop.InitiateGrowingRegion();
                        pop.MakeTopo();
                    }
                    i1.killRoi();
                    int ninc = 100;
                    int ini = this.PixelLevel.getValue();
                    for (int t = 1; t < ninc + 1; ++t) {
                        pop.Tick_inflate(ini, t);
                        if (t % 10 != 0) continue;
                        BalloonSegmentation_.showOverlay();
                        IJ.showStatus((String)("Inflate: " + (int)((double)t / (double)ninc * 100.0) + "%"));
                    }
                    IJ.showProgress((double)1.0);
                    IJ.showStatus((String)"");
                    pop.refineStructure();
                    pop.mass_Geometry();
                    BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 4;
                    BalloonSegmentation_.InitiateDraw();
                    BalloonSegmentation_.drawBounds();
                    BalloonSegmentation_.drawCellID();
                    BalloonSegmentation_.drawCrosses();
                    BalloonSegmentation_.drawPop();
                    BalloonSegmentation_.showOverlay();
                    Tb.setTool(12);
                    this.bnEdit.setSelected(false);
                }
            }
        }
        if (e.getSource() == this.showOptionsList) {
            i1.killRoi();
            String showType = (String)this.showOptionsList.getSelectedItem();
            if (showType == "Bounds") {
                selected_cell = -1;
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.showOverlay();
                Tb.setTool(0);
            } else if (showType == "Centres") {
                selected_cell = -2;
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawCrosses();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.showOverlay();
                Tb.setTool(12);
            } else if (showType == "Interactions") {
                selected_cell = -2;
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawTopo();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.showOverlay();
                Tb.setTool(12);
            } else if (showType == "Neighbours") {
                selected_cell = -2;
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawContacts();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.showOverlay();
                Tb.setTool(12);
            } else if (showType == "Cells") {
                selected_cell = -2;
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.drawPop();
                BalloonSegmentation_.showOverlay();
                Tb.setTool(12);
            } else if (showType == "Report") {
                this.makeReport();
                Tb.setTool(12);
            }
            this.bnEdit.setSelected(false);
        }
        if (e.getSource() == this.bnModify && (id = Integer.parseInt(this.txtCellID.getText())) < BalloonSegmentation_.pop.BallList.size()) {
            this.bal1 = BalloonSegmentation_.pop.BallList.get(id);
            int[][] bounds = this.bal1.Cexpand(false);
            int[] XXi = bounds[0];
            int[] YYi = bounds[1];
            PolygonRoi Proi = new PolygonRoi(XXi, YYi, XXi.length, 2);
            selected_cell = id;
            i1.setRoi((Roi)Proi);
            Tb.setTool(0);
            this.bnEdit.setSelected(false);
        }
        if (e.getSource() == this.bnCapture) {
            ImagePlus ip_capture = new ImagePlus();
            ImageStack stack = i1.createEmptyStack();
            int currentSlice_buff = currentSlice;
            MROI.close();
            MROI = new RoiManager();
            for (int i = 0; i < i1.getStackSize(); ++i) {
                currentSlice = i + 1;
                pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
                ipWallSegment = i1.getStack().getProcessor(currentSlice);
                BalloonSegmentation_.ClearDraw();
                ImageProcessor ip = i1.getStack().getProcessor(currentSlice);
                ImagePlus flat_im = new ImagePlus("", ip);
                BalloonSegmentation_.makeOverlayCurrent(currentStage[currentSlice - 1]);
                flat_im.setOverlay(OL);
                ImageProcessor cp = flat_im.flatten().getProcessor();
                stack.addSlice("" + i, cp);
                if (currentStage[currentSlice - 1] <= 3) continue;
                i1.setSlice(currentSlice);
                BalloonSegmentation_.makeROI();
            }
            MROI.show();
            ip_capture.setStack("Capture", stack);
            ip_capture.show();
            currentSlice = currentSlice_buff;
            pop = BalloonSegmentation_.popSequence.PopList[currentSlice - 1];
            ipWallSegment = i1.getStack().getProcessor(currentSlice);
            BalloonSegmentation_.drawCurrent();
            this.bnEdit.setSelected(false);
        }
        if (e.getSource() == this.bnClose) {
            this.clearAll();
        }
        if (e.getSource() == this.bnClear) {
            BalloonSegmentation_.ClearMarks();
            pop = null;
            BalloonSegmentation_.popSequence.PopList[BalloonSegmentation_.currentSlice - 1] = null;
            BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = -1;
            i1.killRoi();
            Tb.setTool(12);
            this.bnEdit.setSelected(false);
            IJ.showProgress((double)1.0);
            IJ.showStatus((String)"");
        }
        this.notify();
    }

    @Override
    public synchronized void itemStateChanged(ItemEvent e) {
        this.notify();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    public Roi[] getRois() {
        RoiManager rmanager = RoiManager.getInstance();
        if (rmanager == null || rmanager.getCount() == 0) {
            IJ.log((String)"add ROIs to the RoiManager first (select a region then press [t]).");
            return null;
        }
        return rmanager.getRoisAsArray();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent event) {
        int pixlevel = this.PixelLevel.getValue() - event.getWheelRotation();
        if (pixlevel < this.min_pix_level) {
            pixlevel = this.min_pix_level;
        } else if (pixlevel > this.max_pix_level) {
            pixlevel = this.max_pix_level;
        }
        this.PixelLevel.setValue(pixlevel);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Roi roi = i1.getRoi();
        if (roi != null) {
            if (roi.getType() == 2 & selected_cell > -1) {
                Polygon p = roi.getPolygon();
                int[] XXi = p.xpoints;
                int[] YYi = p.ypoints;
                this.bal1 = BalloonSegmentation_.pop.BallList.get(selected_cell);
                this.bal1.setXX(XXi);
                this.bal1.setYY(YYi);
                this.bal1.mass_geometry();
                BalloonSegmentation_.InitiateDraw();
                BalloonSegmentation_.drawBounds();
                BalloonSegmentation_.drawCellID();
                BalloonSegmentation_.drawCrosses();
                BalloonSegmentation_.drawPop();
                BalloonSegmentation_.showOverlay();
            } else if (roi.getType() == 2 & selected_cell == -1) {
                Polygon p = roi.getPolygon();
                int[] XXi = p.xpoints;
                int[] YYi = p.ypoints;
                pop.modify_boundaries(XXi, YYi);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.bnEdit.isSelected()) {
            int x = ic.offScreenX(e.getX());
            int y = ic.offScreenY(e.getY());
            boolean xx = false;
            String editType = (String)this.editOptionsList.getSelectedItem();
            if (editType == "Add") {
                this.InitiateBalloons(x, y);
            } else if (editType == "Del") {
                this.RemoveBalloons(x, y);
            } else if (editType == "Move") {
                this.MoveBalloons(x, y);
            }
            BalloonSegmentation_.InitiateDraw();
            BalloonSegmentation_.drawBounds();
            BalloonSegmentation_.drawCellID();
            BalloonSegmentation_.drawCrosses();
            BalloonSegmentation_.showOverlay();
            BalloonSegmentation_.currentStage[BalloonSegmentation_.currentSlice - 1] = 2;
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        Roi roi = i1.getRoi();
        Polygon p = roi.getPolygon();
        int[] XXi = p.xpoints;
        int[] YYi = p.ypoints;
        PolygonRoi Proi = new PolygonRoi(XXi, YYi, XXi.length, 2);
        i1.setRoi((Roi)Proi);
    }

    public String modifiers(int flags) {
        String s = " [ ";
        if (flags == 0) {
            return "";
        }
        if ((flags & 1) != 0) {
            s = s + "Shift ";
        }
        if ((flags & 2) != 0) {
            s = s + "Control ";
        }
        if ((flags & 4) != 0) {
            s = s + "Meta ";
        }
        if ((flags & 8) != 0) {
            s = s + "Alt ";
        }
        s = s + "] ";
        return s;
    }

    static {
        is_movepoint = false;
        channel = 1;
        font = new Font("Test", 0, 4);
        MROI = new RoiManager(true);
        OL = new Overlay();
        print_writer = null;
    }

    static class StackWindowRoi
    extends StackWindow
    implements MouseWheelListener {
        ListenerAdj Ladj;

        StackWindowRoi(ImagePlus image, ImageCanvas canvas) {
            super(image, canvas);
            this.imp.setSlice(1);
            this.Ladj = new ListenerAdj();
            if (i1.getStackSize() > 1) {
                this.sliceSelector.addAdjustmentListener(this.Ladj);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseWheelMoved(MouseWheelEvent event) {
            StackWindowRoi stackWindowRoi = this;
            synchronized (stackWindowRoi) {
                i1.killRoi();
                int slice = this.imp.getCurrentSlice() + event.getWheelRotation();
                if (slice < 1) {
                    slice = 1;
                } else if (slice > this.imp.getStack().getSize()) {
                    slice = this.imp.getStack().getSize();
                }
                this.imp.setSlice(slice);
                BalloonSegmentation_.drawCurrent();
            }
        }

        public void clearListener() {
            this.sliceSelector.removeAdjustmentListener(this.Ladj);
            this.removeMouseWheelListener(this);
        }

        class ListenerAdj
        implements AdjustmentListener {
            int oldSlice;

            ListenerAdj() {
            }

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                i1.killRoi();
                if (e.getAdjustmentType() == 5) {
                    currentSlice = i1.getCurrentSlice();
                    BalloonSegmentation_.drawCurrent();
                } else {
                    BalloonSegmentation_.ClearDraw();
                }
            }
        }
    }
}

