/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.stitching.fusion;

import java.util.HashSet;
import java.util.Set;
import mpicbg.stitching.fusion.Interval;

public class ClassifiedRegion {
    private final Interval[] intervals;
    private final Set<Integer> classes = new HashSet<Integer>();
    private int[] ints = null;

    public ClassifiedRegion(int size) {
        this.intervals = new Interval[size];
    }

    public ClassifiedRegion(Interval ... intervals) {
        this.intervals = intervals;
    }

    public ClassifiedRegion(ClassifiedRegion copy) {
        this.intervals = copy.intervals;
        this.addAllClasses(copy);
    }

    public void addClass(int label) {
        this.classes.add(label);
        this.ints = null;
    }

    public void addAllClasses(ClassifiedRegion region) {
        for (int c : region.classes) {
            this.addClass(c);
        }
    }

    public boolean coversClasses(ClassifiedRegion other) {
        return this.classes.containsAll(other.classes);
    }

    public int[] classArray() {
        if (this.ints == null) {
            this.ints = new int[this.classes.size()];
            int index = 0;
            for (Integer i : this.classes) {
                this.ints[index++] = i;
            }
        }
        return this.ints;
    }

    public void set(Interval interval, int index) {
        this.intervals[index] = interval;
    }

    public Interval get(int index) {
        return this.intervals[index];
    }

    public int size() {
        return this.intervals.length;
    }

    public boolean intersects(ClassifiedRegion other) {
        boolean matches = true;
        for (int i = 0; matches && i < Math.min(other.size(), this.size()); ++i) {
            matches = this.get(i).intersects(other.get(i));
        }
        return matches;
    }

    public boolean equalsRegion(ClassifiedRegion other) {
        boolean equal = this.size() == other.size();
        for (int i = 0; equal && i < this.size(); ++i) {
            equal = this.get(i).equalsInterval(other.get(i));
        }
        return equal;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.intervals.length; ++i) {
            s = s + this.intervals[i] + "; ";
        }
        return s;
    }
}

