/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.display.imagej;

import java.util.concurrent.ExecutorService;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.Sampler;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.converter.readwrite.SamplerConverter;
import net.imglib2.img.basictypeaccess.ByteAccess;
import net.imglib2.img.display.imagej.ImageJVirtualStack;
import net.imglib2.type.BooleanType;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.util.Util;

public class ImageJVirtualStackUnsignedByte
extends ImageJVirtualStack<UnsignedByteType> {
    public static <T extends RealType<?>> ImageJVirtualStackUnsignedByte wrap(RandomAccessibleInterval<T> source) {
        return new ImageJVirtualStackUnsignedByte(ImageJVirtualStackUnsignedByte.toUnsignedByteType(source));
    }

    private static <T extends RealType<?>> RandomAccessibleInterval<UnsignedByteType> toUnsignedByteType(RandomAccessibleInterval<T> source) {
        if (Util.getTypeFromInterval(source) instanceof UnsignedByteType) {
            return source;
        }
        return Converters.convert(source, (SamplerConverter)new ToUnsignedByteSamplerConverter((RealType)Util.getTypeFromInterval(source)));
    }

    public static ImageJVirtualStackUnsignedByte wrapAndScaleBitType(RandomAccessibleInterval<BitType> source) {
        return new ImageJVirtualStackUnsignedByte((RandomAccessibleInterval<UnsignedByteType>)Converters.convert(source, (SamplerConverter)new ToBitByteSamplerConverter()));
    }

    public <S> ImageJVirtualStackUnsignedByte(RandomAccessibleInterval<S> source, Converter<? super S, UnsignedByteType> converter) {
        this(source, converter, null);
    }

    public <S> ImageJVirtualStackUnsignedByte(RandomAccessibleInterval<S> source, Converter<? super S, UnsignedByteType> converter, ExecutorService service) {
        super(source, converter, new UnsignedByteType(), 8, service);
        this.setMinAndMax(0.0, 255.0);
    }

    private ImageJVirtualStackUnsignedByte(RandomAccessibleInterval<UnsignedByteType> source) {
        super(source, 8);
        this.setMinAndMax(0.0, 255.0);
    }

    private static class ToBitByteSamplerConverter
    implements SamplerConverter<BooleanType<?>, UnsignedByteType> {
        private ToBitByteSamplerConverter() {
        }

        public UnsignedByteType convert(final Sampler<? extends BooleanType<?>> sampler) {
            return new UnsignedByteType(new ByteAccess(){

                public byte getValue(int index) {
                    return ((BooleanType)sampler.get()).get() ? (byte)-1 : 0;
                }

                public void setValue(int index, byte value) {
                    ((BooleanType)sampler.get()).set(value != 0);
                }
            });
        }
    }

    private static class ToUnsignedByteSamplerConverter
    implements SamplerConverter<RealType, UnsignedByteType> {
        private final double min;
        private final double max;

        ToUnsignedByteSamplerConverter(RealType<?> type) {
            this.min = type.getMinValue();
            this.max = type.getMaxValue();
        }

        public UnsignedByteType convert(final Sampler<? extends RealType> sampler) {
            return new UnsignedByteType(new ByteAccess(){

                public byte getValue(int index) {
                    double val = ((RealType)sampler.get()).getRealDouble() + 0.5;
                    if (val < 0.0) {
                        val = 0.0;
                    } else if (val > 255.0) {
                        val = 255.0;
                    }
                    return (byte)val;
                }

                public void setValue(int index, byte value) {
                    double val = value;
                    if (val < min) {
                        val = min;
                    } else if (val > max) {
                        val = max;
                    }
                    ((RealType)sampler.get()).setReal(val);
                }
            });
        }
    }
}

