/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.balloonSegmentation.structure;

import Jama.Matrix;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.awt.Point;
import java.awt.Polygon;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import sc.fiji.balloonSegmentation.structure.BalloonPopulation;

public class Balloon
extends Thread {
    double stiffness = 0.2;
    double plasticity_factor = 0.01;
    double BendStiff = 0.05;
    double stretch = 30.0;
    double interface_width = 4.0;
    double mass = 1.0;
    double dt = 0.05;
    double visc = 2.0;
    public int n0 = 15;
    public double Radius0 = 4.0;
    public int id;
    public double[] XX;
    public double[] YY;
    private double[] L0s;
    private double[] VX;
    private double[] VY;
    private double[] VX0;
    private double[] VY0;
    public int[] FIX;
    public int x0;
    public int y0;
    BalloonPopulation POP;
    public PolygonRoi Proi;
    private double Length0 = this.Radius0 * Math.sqrt(Math.pow(Math.cos(6.28318 / (double)this.n0) - this.Radius0, 2.0) + Math.pow(Math.sin(6.28318 / (double)this.n0), 2.0));
    private double angle0 = -3.14159;
    private double pressure = (6.3 * this.stiffness / (double)this.n0 - this.Length0 / this.Radius0) * 2.0;
    double PressRatio = 0.05;
    public double PixLevel = 0.0;
    public double Ixx;
    public double Iyy;
    public double Ixy;
    public double lx;
    public double ly;
    public double area;
    public double radius;
    public double radius_min;
    public boolean docontact = false;
    ImageProcessor ipb;
    ImageProcessor ip_gradx_p;
    ImageProcessor ip_grady_p;
    ImageProcessor ip_gradx_m;
    ImageProcessor ip_grady_m;
    int channel = 1;
    int w;
    int h;
    public double sig_vol;
    public Matrix StrainVector;
    public double[] StrainValues;
    public Matrix StrainTensor = new Matrix(2, 2);
    public int id_mother = -1;
    public int n_generation = 0;
    public int id_line = -1;
    public int div_x0;
    public int div_y0;
    public int div_x1;
    public int div_y1;
    public boolean is_growing = true;
    int length_history = 30;
    public ArrayList<Double> history_radius = new ArrayList();

    public Balloon(int x, int y, int ID, ImageProcessor ip, BalloonPopulation BP, int rgbchannel) {
        this.channel = rgbchannel;
        this.ip_gradx_p = BP.ip_gradx_p;
        this.ip_grady_p = BP.ip_grady_p;
        this.ip_gradx_m = BP.ip_gradx_m;
        this.ip_grady_m = BP.ip_grady_m;
        this.POP = BP;
        this.init(x, y, ID, ip);
        this.loadProperties();
        this.InitiateGrowingRegion();
        float sti = 0.0f;
        for (int i = 0; i < this.length_history; ++i) {
            this.history_radius.add((double)sti * 0.05 + (double)sti);
        }
    }

    public Balloon(int[] Ax, int[] Ay, int ID, ImageProcessor ip, BalloonPopulation BP, int rgbchannel) {
        this.loadProperties();
        this.channel = rgbchannel;
        this.ip_gradx_p = BP.ip_gradx_p;
        this.ip_grady_p = BP.ip_grady_p;
        this.ip_gradx_m = BP.ip_gradx_m;
        this.ip_grady_m = BP.ip_grady_m;
        this.POP = BP;
        this.init(0, 0, ID, ip);
        this.n0 = Ax.length;
        this.XX = new double[this.n0];
        this.YY = new double[this.n0];
        this.VX = new double[this.n0];
        this.VY = new double[this.n0];
        this.VX0 = new double[this.n0];
        this.VY0 = new double[this.n0];
        this.FIX = new int[this.n0];
        this.L0s = new double[this.n0];
        for (int i = 0; i < this.n0; ++i) {
            this.XX[i] = Ax[i];
            this.YY[i] = Ay[i];
            this.VX0[i] = 0.0;
            this.VY0[i] = 0.0;
            this.VX[i] = 0.0;
            this.VY[i] = 0.0;
            this.FIX[i] = 0;
            this.L0s[i] = this.Length0;
        }
        this.mass_geometry();
        float sti = 0.0f;
        for (int i = 0; i < this.length_history; ++i) {
            this.history_radius.add((double)sti * 0.05 + (double)sti);
        }
    }

    private void init(int x, int y, int ID, ImageProcessor ip) {
        this.ipb = ip;
        this.w = this.ipb.getWidth();
        this.h = this.ipb.getHeight();
        this.x0 = x;
        this.y0 = y;
        this.XX = new double[this.n0];
        this.YY = new double[this.n0];
        this.L0s = new double[this.n0];
        this.VX = new double[this.n0];
        this.VY = new double[this.n0];
        this.VX0 = new double[this.n0];
        this.VY0 = new double[this.n0];
        this.FIX = new int[this.n0];
        this.Ixx = 0.0;
        this.Iyy = 0.0;
        this.Ixy = 0.0;
        this.lx = 0.0;
        this.ly = 0.0;
        this.id = ID;
        this.id_mother = ID;
        this.id_line = ID;
        double[] eigValues = new double[]{0.0, 0.0};
        double[][] eigVectors = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        this.StrainVector = new Matrix((double[][])eigVectors);
        this.StrainValues = eigValues;
        this.sig_vol = 0.0;
    }

    public void init() {
        this.XX = new double[this.n0];
        this.YY = new double[this.n0];
        this.L0s = new double[this.n0];
        this.VX = new double[this.n0];
        this.VY = new double[this.n0];
        this.VX0 = new double[this.n0];
        this.VY0 = new double[this.n0];
        this.FIX = new int[this.n0];
        this.Ixx = 0.0;
        this.Iyy = 0.0;
        this.Ixy = 0.0;
        this.lx = 0.0;
        this.ly = 0.0;
        double[] eigValues = new double[]{0.0, 0.0};
        double[][] eigVectors = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        this.StrainVector = new Matrix((double[][])eigVectors);
        this.StrainValues = eigValues;
        this.sig_vol = 0.0;
    }

    @Override
    public void run() {
    }

    public void loadProperties() {
        Properties tempProp = new Properties();
        try {
            InputStream propsFile = this.getClass().getResourceAsStream("/BalloonSegmentation.properties");
            tempProp.load(propsFile);
            propsFile.close();
            this.stiffness = Double.parseDouble(tempProp.getProperty("stiffness"));
            this.plasticity_factor = Double.parseDouble(tempProp.getProperty("plasticity_factor"));
            this.BendStiff = Double.parseDouble(tempProp.getProperty("BendStiff"));
            this.interface_width = Double.parseDouble(tempProp.getProperty("interface_width"));
            this.mass = Double.parseDouble(tempProp.getProperty("mass"));
            this.dt = Double.parseDouble(tempProp.getProperty("dt"));
            this.visc = Double.parseDouble(tempProp.getProperty("visc"));
            this.n0 = Integer.parseInt(tempProp.getProperty("n0"));
            this.Radius0 = Double.parseDouble(tempProp.getProperty("Radius0"));
        }
        catch (IOException ioe) {
            IJ.error((String)"I/O Exception: cannot read .properties file");
        }
    }

    public void InitiateGrowingRegion() {
        this.Length0 = this.Radius0 * Math.sqrt(Math.pow(Math.cos(6.28318 / (double)this.n0) - 1.0, 2.0) + Math.pow(Math.sin(6.28318 / (double)this.n0), 2.0));
        float sti = 0.0f;
        for (int i = 0; i < this.length_history; ++i) {
            this.history_radius.add((double)sti * 0.05 + (double)sti);
        }
        for (int i = 0; i < this.n0; ++i) {
            double angle = (double)i * 360.0 / (double)this.n0;
            this.XX[i] = (double)this.x0 + this.Radius0 * Math.cos(angle * 3.14159 / 180.0);
            this.YY[i] = (double)this.y0 + this.Radius0 * Math.sin(angle * 3.14159 / 180.0);
            this.VX0[i] = 0.0;
            this.VY0[i] = 0.0;
            this.VX[i] = 0.0;
            this.VY[i] = 0.0;
            this.FIX[i] = 0;
            this.L0s[i] = this.Length0;
        }
    }

    public void Inflate_inc() {
        int n = this.n0;
        double[] F = new double[3];
        double[] NX = new double[3];
        double[] NX1 = new double[3];
        double[] NX2 = new double[3];
        double[] NY = new double[3];
        double[] NZ = new double[]{0.0, 0.0, -1.0};
        double Dl2 = 0.0;
        double Dl1 = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < this.n0; ++i) {
            if (this.FIX[i] < 10) {
                int ii3 = (n + i + 2) % n;
                int ii2 = (n + i + 1) % n;
                int ii1 = (i + n) % n;
                int ii0 = (i - 1 + n) % n;
                int iim1 = (i - 2 + n) % n;
                double L2 = this.getSegmentLength(ii1);
                double L1 = this.getSegmentLength(ii0);
                double L20 = Math.sqrt(Math.pow(this.XX[ii2] - this.VX0[ii2] * this.dt - (this.XX[ii1] - this.VX0[ii1] * this.dt), 2.0) + Math.pow(this.YY[ii2] - this.VY0[ii2] * this.dt - (this.YY[ii1] - this.VY0[ii1] * this.dt), 2.0));
                double L10 = Math.sqrt(Math.pow(this.XX[ii1] - this.VX0[ii1] * this.dt - (this.XX[ii0] - this.VX0[ii0] * this.dt), 2.0) + Math.pow(this.YY[ii1] - this.VY0[ii1] * this.dt - (this.YY[ii0] - this.VY0[ii0] * this.dt), 2.0));
                Dl2 = (L2 - this.L0s[i]) * this.stiffness;
                Dl1 = (L1 - this.L0s[i]) * this.stiffness;
                int n2 = i;
                this.L0s[n2] = this.L0s[n2] + (L2 - this.L0s[i]) * this.plasticity_factor;
                NX2[0] = this.XX[ii2] - this.XX[ii1];
                NX2[1] = this.YY[ii2] - this.YY[ii1];
                NX2[2] = 0.0;
                NX1[0] = this.XX[ii1] - this.XX[ii0];
                NX1[1] = this.YY[ii1] - this.YY[ii0];
                NX1[2] = 0.0;
                NX = this.prod(this.add(NX1, NX2), 0.5);
                NY = this.cross(NZ, NX);
                double[] NR = new double[]{this.XX[i] - (double)this.x0, this.YY[i] - (double)this.y0, 0.0};
                NR = this.normalized(NR);
                double force = Math.max((this.PixLevel - (double)this.ipb.get((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5))) * this.PressRatio, 0.0);
                F = this.prod(NY, force);
                if (Dl1 > 0.0 & Dl2 > 0.0) {
                    F = this.add(F, this.prod(NX2, Dl2));
                    F = this.add(F, this.prod(NX1, -Dl1));
                }
                double angle2 = this.angle(this.XX[ii3] - this.XX[ii2], this.YY[ii3] - this.YY[ii2], this.XX[ii1] - this.XX[ii2], this.YY[ii1] - this.YY[ii2]);
                double angle1 = this.angle(this.XX[ii2] - this.XX[ii1], this.YY[ii2] - this.YY[ii1], this.XX[ii0] - this.XX[ii1], this.YY[ii0] - this.YY[ii1]);
                double angle0 = this.angle(this.XX[ii1] - this.XX[ii0], this.YY[ii1] - this.YY[ii0], this.XX[iim1] - this.XX[ii0], this.YY[iim1] - this.YY[ii0]);
                double rota2 = 3.14159 - angle2;
                double rota1 = 3.14159 - angle1;
                double rota0 = 3.14159 - angle0;
                rota2 = Math.pow(rota2, 3.0) * 0.002;
                rota1 = Math.pow(rota1, 3.0) * 0.002;
                rota0 = Math.pow(rota0, 3.0) * 0.002;
                double LN = (L1 + L2) / 2.0;
                if (this.radius_min / Math.abs(LN * Math.cos(3.14159 - angle1)) > 45.0) {
                    int n3 = ii1;
                    this.XX[n3] = this.XX[n3] + ((this.XX[ii0] + this.XX[ii2]) / 2.0 - this.XX[ii1]);
                    int n4 = ii1;
                    this.YY[n4] = this.YY[n4] + ((this.YY[ii0] + this.YY[ii2]) / 2.0 - this.YY[ii1]);
                    this.VX0[ii1] = 0.0;
                    this.VY0[ii1] = 0.0;
                    F[0] = 0.0;
                    F[1] = 0.0;
                    F[2] = 0.0;
                } else {
                    F = this.add(F, this.prod(NY, this.BendStiff * rota2 / LN));
                    F = this.add(F, this.prod(NY, this.BendStiff * rota0 / LN));
                    F = this.sub(F, this.prod(NY, 2.0 * this.BendStiff * rota1 / LN));
                }
                if (this.FIX[i] > 0 & this.FIX[i] < 10) {
                    if (this.dot(F, NX2) > 0.0) {
                        NX2 = this.normalized(NX2);
                        F = this.prod(NX2, this.dot(F, NX2));
                        this.FIX[i] = 0;
                    } else {
                        NX1 = this.normalized(NX1);
                        F = this.prod(NX1, this.dot(F, NX1));
                        this.FIX[i] = 0;
                    }
                }
                if (this.FIX[i] < 10) {
                    this.VX[i] = this.VX0[i] + (F[0] - this.visc * this.VX0[i]) * this.dt / this.mass;
                    this.VY[i] = this.VY0[i] + (F[1] - this.visc * this.VY0[i]) * this.dt / this.mass;
                    int n5 = i;
                    this.XX[n5] = this.XX[n5] + this.VX[i] * this.dt;
                    int n6 = i;
                    this.YY[n6] = this.YY[n6] + this.VY[i] * this.dt;
                    this.VX0[i] = this.VX[i];
                    this.VY0[i] = this.VY[i];
                }
            }
            x += this.XX[i] / (double)n;
            y += this.YY[i] / (double)n;
            double dx = this.XX[i] - (double)this.x0;
            double dy = this.YY[i] - (double)this.y0;
            this.radius = Math.max(this.radius, Math.sqrt(dx * dx + dy * dy));
            this.radius_min = Math.min(this.radius, Math.sqrt(dx * dx + dy * dy));
        }
        this.history_radius.add(this.radius);
        this.history_radius.remove(0);
        this.x0 = (int)Math.round(x);
        this.y0 = (int)Math.round(y);
    }

    public void Optimize_inc() {
        int n = this.n0;
        double[] F = new double[3];
        double[] NX = new double[3];
        double[] NX1 = new double[3];
        double[] NX2 = new double[3];
        double[] NY = new double[3];
        double[] NZ = new double[]{0.0, 0.0, -1.0};
        double Dl2 = 0.0;
        double Dl1 = 0.0;
        double x = 0.0;
        double y = 0.0;
        for (int i = 0; i < this.n0; ++i) {
            boolean is_out_of_bound = false;
            if (this.XX[i] <= 0.0) {
                this.XX[i] = 0.0;
                is_out_of_bound = true;
            }
            if (this.XX[i] >= (double)(this.w - 1)) {
                this.XX[i] = this.w - 1;
                is_out_of_bound = true;
            }
            if (this.YY[i] <= 0.0) {
                this.YY[i] = 0.0;
                is_out_of_bound = true;
            }
            if (this.YY[i] >= (double)(this.h - 1)) {
                this.YY[i] = this.h - 1;
                is_out_of_bound = true;
            }
            if (this.FIX[i] < 1 | !is_out_of_bound) {
                int ii3 = (n + i + 2) % n;
                int ii2 = (n + i + 1) % n;
                int ii1 = (i + n) % n;
                int ii0 = (i - 1 + n) % n;
                int iim1 = (i - 2 + n) % n;
                double L2 = this.getSegmentLength(ii1);
                double L1 = this.getSegmentLength(ii0);
                double L20 = Math.sqrt(Math.pow(this.XX[ii2] - this.VX0[ii2] * this.dt - (this.XX[ii1] - this.VX0[ii1] * this.dt), 2.0) + Math.pow(this.YY[ii2] - this.VY0[ii2] * this.dt - (this.YY[ii1] - this.VY0[ii1] * this.dt), 2.0));
                double L10 = Math.sqrt(Math.pow(this.XX[ii1] - this.VX0[ii1] * this.dt - (this.XX[ii0] - this.VX0[ii0] * this.dt), 2.0) + Math.pow(this.YY[ii1] - this.VY0[ii1] * this.dt - (this.YY[ii0] - this.VY0[ii0] * this.dt), 2.0));
                Dl2 = (L2 - this.L0s[i]) * this.stiffness;
                Dl1 = (L1 - this.L0s[i]) * this.stiffness;
                NX2[0] = this.XX[ii2] - this.XX[ii1];
                NX2[1] = this.YY[ii2] - this.YY[ii1];
                NX2[2] = 0.0;
                NX1[0] = this.XX[ii1] - this.XX[ii0];
                NX1[1] = this.YY[ii1] - this.YY[ii0];
                NX1[2] = 0.0;
                NX = this.prod(this.add(NX1, NX2), 0.5);
                NY = this.cross(NZ, NX);
                double[] NR = new double[]{this.XX[i] - (double)this.x0, this.YY[i] - (double)this.y0, 0.0};
                NR = this.normalized(NR);
                F[0] = (double)(-(this.ip_gradx_p.get((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5)) - this.ip_gradx_m.get((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5)))) * this.PressRatio;
                F[1] = (double)(-(this.ip_grady_p.get((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5)) - this.ip_grady_m.get((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5)))) * this.PressRatio;
                F[2] = 0.0;
                if (Dl1 > 0.0 & Dl2 > 0.0) {
                    F = this.add(F, this.prod(NX2, Dl2));
                    F = this.add(F, this.prod(NX1, -Dl1));
                }
                double angle2 = this.angle(this.XX[ii3] - this.XX[ii2], this.YY[ii3] - this.YY[ii2], this.XX[ii1] - this.XX[ii2], this.YY[ii1] - this.YY[ii2]);
                double angle1 = this.angle(this.XX[ii2] - this.XX[ii1], this.YY[ii2] - this.YY[ii1], this.XX[ii0] - this.XX[ii1], this.YY[ii0] - this.YY[ii1]);
                double angle0 = this.angle(this.XX[ii1] - this.XX[ii0], this.YY[ii1] - this.YY[ii0], this.XX[iim1] - this.XX[ii0], this.YY[iim1] - this.YY[ii0]);
                double rota2 = 3.14159 - angle2;
                double rota1 = 3.14159 - angle1;
                double rota0 = 3.14159 - angle0;
                rota2 = Math.pow(rota2, 3.0) * 0.002;
                rota1 = Math.pow(rota1, 3.0) * 0.002;
                rota0 = Math.pow(rota0, 3.0) * 0.002;
                double LN = (L1 + L2) / 2.0;
                if (this.radius_min / (LN * Math.cos(3.14159 - angle1)) > 45.0) {
                    int n2 = ii1;
                    this.XX[n2] = this.XX[n2] + ((this.XX[ii0] + this.XX[ii2]) / 2.0 - this.XX[ii1]);
                    int n3 = ii1;
                    this.YY[n3] = this.YY[n3] + ((this.YY[ii0] + this.YY[ii2]) / 2.0 - this.YY[ii1]);
                    this.VX0[ii1] = 0.0;
                    this.VY0[ii1] = 0.0;
                    F[0] = 0.0;
                    F[1] = 0.0;
                    F[2] = 0.0;
                } else {
                    F = this.add(F, this.prod(NY, this.BendStiff * rota2 / LN));
                    F = this.add(F, this.prod(NY, this.BendStiff * rota0 / LN));
                    F = this.sub(F, this.prod(NY, 2.0 * this.BendStiff * rota1 / LN));
                }
                if (this.FIX[i] > 0 & this.FIX[i] < 10) {
                    if (this.dot(F, NX2) > 0.0) {
                        NX2 = this.normalized(NX2);
                        F = this.prod(NX2, this.dot(F, NX2));
                        this.FIX[i] = 0;
                    } else {
                        NX1 = this.normalized(NX1);
                        F = this.prod(NX1, this.dot(F, NX1));
                        this.FIX[i] = 0;
                    }
                }
                if (this.FIX[i] < 10) {
                    this.VX[i] = this.VX0[i] + (F[0] - this.visc * this.VX0[i] * 10.0) * this.dt / this.mass * 0.3;
                    this.VY[i] = this.VY0[i] + (F[1] - this.visc * this.VY0[i] * 10.0) * this.dt / this.mass * 0.3;
                    int n4 = i;
                    this.XX[n4] = this.XX[n4] + Math.min(this.VX[i] * this.dt, 0.05 * this.Length0);
                    int n5 = i;
                    this.YY[n5] = this.YY[n5] + Math.min(this.VY[i] * this.dt, 0.05 * this.Length0);
                    this.VX0[i] = this.VX[i];
                    this.VY0[i] = this.VY[i];
                }
            }
            x += this.XX[i] / (double)n;
            y += this.YY[i] / (double)n;
            double dx = this.XX[i] - (double)this.x0;
            double dy = this.YY[i] - (double)this.y0;
            this.radius = Math.max(this.radius, Math.sqrt(dx * dx + dy * dy));
            this.radius_min = Math.min(this.radius, Math.sqrt(dx * dx + dy * dy));
        }
        this.history_radius.add(this.radius);
        this.history_radius.remove(0);
        this.x0 = (int)Math.round(x);
        this.y0 = (int)Math.round(y);
    }

    public void init_opt() {
        for (int i = 0; i < this.n0; ++i) {
            double L2;
            int ii1 = (i + this.n0) % this.n0;
            this.L0s[i] = L2 = this.getSegmentLength(ii1);
            this.VX0[i] = 0.0;
            this.VY0[i] = 0.0;
            this.VX[i] = 0.0;
            this.VY[i] = 0.0;
            this.FIX[i] = 0;
        }
    }

    public void refineStructure() {
        int i;
        int n1 = this.n0;
        ArrayList<Double> Xnew = new ArrayList<Double>();
        ArrayList<Double> Ynew = new ArrayList<Double>();
        for (i = 1; i < this.n0 + 1; ++i) {
            int ii1 = (i + this.n0) % this.n0;
            int ii0 = i - 1;
            int iim1 = (i + this.n0 - 2) % this.n0;
            double leni = Math.sqrt(Math.pow(this.XX[i % this.n0] - this.XX[i - 1], 2.0) + Math.pow(this.YY[i % this.n0] - this.YY[i - 1], 2.0));
            double len2i = Math.sqrt(Math.pow(this.XX[(i + this.n0) % this.n0] - this.XX[(i + this.n0 - 2) % this.n0], 2.0) + Math.pow(this.YY[(i + this.n0) % this.n0] - this.YY[(i + this.n0 - 2) % this.n0], 2.0));
            double angle = this.angle(this.XX[ii1] - this.XX[ii0], this.YY[ii1] - this.YY[ii0], this.XX[iim1] - this.XX[ii0], this.YY[iim1] - this.YY[ii0]);
            double rota = 3.14159 - angle;
            if (leni > (double)this.POP.max_length) {
                Xnew.add(this.XX[i - 1]);
                Ynew.add(this.YY[i - 1]);
                Xnew.add((this.XX[i - 1] + this.XX[i % this.n0]) / 2.0);
                Ynew.add((this.YY[i - 1] + this.YY[i % this.n0]) / 2.0);
                ++n1;
                continue;
            }
            if (this.n0 > 20 & leni < (double)this.POP.max_length / 4.0) {
                --n1;
                continue;
            }
            Xnew.add(this.XX[i - 1]);
            Ynew.add(this.YY[i - 1]);
        }
        this.XX = new double[n1];
        this.YY = new double[n1];
        for (i = 0; i < n1; ++i) {
            this.XX[i] = (Double)Xnew.get(i);
            this.YY[i] = (Double)Ynew.get(i);
        }
        this.n0 = n1;
        if (this.n0 > this.POP.max_n0) {
            this.POP.max_n0 = this.n0;
        }
        this.L0s = new double[n1];
        this.VX = new double[n1];
        this.VY = new double[n1];
        this.VX0 = new double[n1];
        this.VY0 = new double[n1];
        this.FIX = new int[n1];
        for (i = 0; i < this.n0; ++i) {
            double L2;
            int i1 = (i + this.n0) % this.n0;
            this.L0s[i] = L2 = this.getSegmentLength(i1);
        }
    }

    public void translateTo(int x, int y) {
        int Tx = x - this.x0;
        int Ty = y - this.y0;
        this.x0 = x;
        this.y0 = y;
        int i = 0;
        while (i < this.n0) {
            int n = i;
            this.XX[n] = this.XX[n] + (double)Tx;
            int n2 = i++;
            this.YY[n2] = this.YY[n2] + (double)Ty;
        }
    }

    public boolean contact(double x, double y, int bx0, int by0) {
        Polygon cell = new Polygon();
        double[] r = new double[2];
        for (int i = 0; i < this.n0; ++i) {
            r[0] = this.XX[i] - (double)this.x0;
            r[1] = this.YY[i] - (double)this.y0;
            r = this.prod(this.normalized(r), this.interface_width);
            cell.addPoint((int)(this.XX[i] + r[0] + 0.5), (int)(this.YY[i] + r[1] + 0.5));
        }
        boolean contain1 = cell.contains((int)(x + 0.5), (int)(y + 0.5));
        cell = new Polygon();
        for (int i = 0; i < this.n0; ++i) {
            cell.addPoint((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5));
        }
        r[0] = x - (double)bx0;
        r[1] = y - (double)by0;
        r = this.prod(this.normalized(r), this.interface_width);
        boolean contain2 = cell.contains((int)(x + r[0] + 0.5), (int)(y + r[1] + 0.5));
        return contain1 | contain2;
    }

    public boolean contain(double x, double y, int bx0, int by0) {
        Polygon cell = new Polygon();
        for (int i = 0; i < this.n0; ++i) {
            cell.addPoint((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5));
        }
        boolean contain = cell.contains((int)(x + 0.5), (int)(y + 0.5));
        return contain;
    }

    public int[][] Cexpand(boolean is_interface) {
        int n = this.n0;
        int[][] OUTPT = new int[2][n];
        for (int i = 0; i < n; ++i) {
            double rx = this.XX[i] - (double)this.x0;
            double ry = this.YY[i] - (double)this.y0;
            double d = Math.sqrt(rx * rx + ry * ry);
            rx = 0.0;
            ry = 0.0;
            if (is_interface) {
                rx = this.interface_width * rx / d;
                ry = this.interface_width * ry / d;
            }
            OUTPT[0][i] = (int)(this.XX[i] + rx + 0.5);
            OUTPT[1][i] = (int)(this.YY[i] + ry + 0.5);
        }
        return OUTPT;
    }

    public void fix(int i) {
        this.FIX[i] = 1;
    }

    public void encastre(int i) {
        this.FIX[i] = 10;
    }

    public void mass_geometry() {
        int i;
        int j;
        int i2;
        int[] SXi = new int[this.n0];
        int[] SYi = new int[this.n0];
        int[] XXi = this.getXXi();
        int[] YYi = this.getYYi();
        for (int i3 = 0; i3 < this.n0; ++i3) {
            SXi[i3] = (int)(this.XX[i3] + 0.5);
            SYi[i3] = (int)(this.YY[i3] + 0.5);
        }
        Arrays.sort(SXi);
        Arrays.sort(SYi);
        int x_min = SXi[0];
        int x_max = SXi[this.n0 - 1];
        int y_min = SYi[0];
        int y_max = SYi[this.n0 - 1];
        this.Proi = new PolygonRoi(XXi, YYi, XXi.length, 2);
        int nn = 0;
        this.x0 = 0;
        this.y0 = 0;
        for (i2 = x_min; i2 < x_max + 1; ++i2) {
            for (j = y_min; j < y_max + 1; ++j) {
                if (!this.Proi.contains(i2, j)) continue;
                this.x0 += i2;
                this.y0 += j;
                ++nn;
            }
        }
        if (nn > 0) {
            this.x0 /= nn;
            this.y0 /= nn;
        }
        this.Ixx = 0.0;
        this.Iyy = 0.0;
        this.Ixy = 0.0;
        this.area = 0.0;
        for (i2 = x_min; i2 < x_max + 1; ++i2) {
            for (j = y_min; j < y_max + 1; ++j) {
                if (!this.Proi.contains(i2, j)) continue;
                this.Ixx += (double)((i2 - this.x0) * (i2 - this.x0));
                this.Iyy += (double)((j - this.y0) * (j - this.y0));
                this.Ixy += (double)((i2 - this.x0) * (j - this.y0));
                this.area += 1.0;
            }
        }
        this.radius = 0.0;
        double minx = 100000.0;
        double maxx = -1.0;
        double miny = 100000.0;
        double maxy = -1.0;
        for (i = 0; i < this.n0; ++i) {
            double dx = this.XX[i] - (double)this.x0;
            double dy = this.YY[i] - (double)this.y0;
            this.radius = Math.max(this.radius, Math.sqrt(dx * dx + dy * dy));
        }
        this.lx = x_max - x_min;
        this.ly = y_max - y_min;
        this.lx = 0.0;
        for (i = x_min; i < x_max; ++i) {
            if (!this.Proi.contains(i, (int)((double)(y_max / 2 + y_min / 2) + 0.5))) continue;
            this.lx += 1.0;
        }
    }

    public void Fill_balloon(ImagePlus i1) {
        ImageProcessor ip = i1.getProcessor();
        double scale_volumetric = 350.0;
        double scale_principal = 50.0;
        double si = Math.abs(this.sig_vol) + this.sig_vol;
        ip.setColor(new Color((int)Math.min(si * scale_volumetric, 255.0), 0, 0));
        int[] XXi = this.getXXi();
        int[] YYi = this.getYYi();
        this.Proi = new PolygonRoi(XXi, YYi, XXi.length, 2);
        ip.setRoi((Roi)this.Proi);
        ip.fill(this.Proi.getMask());
        double nx = this.StrainVector.get(0, 0) * (this.StrainValues[0] + Math.abs(this.StrainValues[0])) / 2.0;
        double ny = this.StrainVector.get(1, 0) * (this.StrainValues[0] + Math.abs(this.StrainValues[0])) / 2.0;
        double mx = this.StrainVector.get(0, 1) * (this.StrainValues[1] + Math.abs(this.StrainValues[1])) / 2.0;
        double my = this.StrainVector.get(1, 1) * (this.StrainValues[1] + Math.abs(this.StrainValues[1])) / 2.0;
        ip.setLineWidth(4);
        ip.setColor(new Color(0, 250, 0));
        ip.drawLine(this.x0 - (int)(nx * scale_principal + 0.5), this.y0 - (int)(ny * scale_principal + 0.5), this.x0 + (int)(nx * scale_principal + 0.5), this.y0 + (int)(ny * scale_principal + 0.5));
        ip.setColor(new Color(0, 0, 250));
        ip.drawLine(this.x0 - (int)(mx * scale_principal + 0.5), this.y0 - (int)(my * scale_principal + 0.5), this.x0 + (int)(mx * scale_principal + 0.5), this.y0 + (int)(my * scale_principal + 0.5));
        ip.setColor(new Color(250, 250, 250));
        ip.setLineWidth(2);
        int n = this.XX.length;
        for (int i = 0; i < n; ++i) {
            ip.drawLine((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5), (int)(this.XX[(i + 1) % n] + 0.5), (int)(this.YY[(i + 1) % n] + 0.5));
        }
    }

    public void Fill_balloon(ImagePlus i1, int level) {
        ImageProcessor ip = i1.getProcessor();
        int[] XXi = this.getXXi();
        int[] YYi = this.getYYi();
        ip.setColor(new Color(level, 0, 255 - level));
        this.Proi = new PolygonRoi(XXi, YYi, XXi.length, 2);
        ip.setRoi((Roi)this.Proi);
        ip.fill(this.Proi.getMask());
        ip.setColor(new Color(250, 250, 250));
        ip.setLineWidth(2);
        int n = this.XX.length;
        for (int i = 0; i < n; ++i) {
            ip.drawLine((int)(this.XX[i] + 0.5), (int)(this.YY[i] + 0.5), (int)(this.XX[(i + 1) % n] + 0.5), (int)(this.YY[(i + 1) % n] + 0.5));
        }
    }

    public Point getPoint() {
        Point P = new Point(this.x0, this.y0);
        return P;
    }

    private double getSegmentLength(int i) {
        return Math.sqrt(Math.pow(this.XX[(i + 1) % this.n0] - this.XX[i], 2.0) + Math.pow(this.YY[(i + 1) % this.n0] - this.YY[i], 2.0));
    }

    public void setXX(int[] X) {
        for (int i = 0; i < X.length; ++i) {
            this.XX[i] = X[i];
        }
    }

    public void setYY(int[] Y) {
        for (int i = 0; i < Y.length; ++i) {
            this.YY[i] = Y[i];
        }
    }

    public int[] getXXi() {
        int[] XXi = new int[this.n0];
        for (int i = 0; i < XXi.length; ++i) {
            XXi[i] = (int)(this.XX[i] + 0.5);
        }
        return XXi;
    }

    public int[] getYYi() {
        int[] YYi = new int[this.n0];
        for (int i = 0; i < YYi.length; ++i) {
            YYi[i] = (int)(this.YY[i] + 0.5);
        }
        return YYi;
    }

    public double[] cross(double[] a, double[] b) {
        double[] r = new double[3];
        if (a.length == 3 & b.length == 3) {
            r[0] = a[1] * b[2] - b[1] * a[2];
            r[1] = a[2] * b[0] - b[2] * a[0];
            r[2] = a[0] * b[1] - b[0] * a[1];
        } else {
            IJ.log((String)"Cross product is defined for 3D arrays only");
            r[0] = 0.0;
            r[1] = 0.0;
            r[2] = 0.0;
        }
        return r;
    }

    public double[] prod(double[] a, double[] b) {
        int n = Math.min(a.length, b.length);
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = a[i] * b[i];
        }
        if (a.length != b.length) {
            IJ.log((String)"Warning: Arrays of different dimensions");
        }
        return r;
    }

    public double[] prod(double[] a, double b) {
        double[] r = new double[a.length];
        for (int i = 0; i < a.length; ++i) {
            r[i] = a[i] * b;
        }
        return r;
    }

    public double dot(double[] a, double[] b) {
        double r = 0.0;
        for (int i = 0; i < a.length; ++i) {
            r += a[i] * b[i];
        }
        return r;
    }

    public double[] add(double[] a, double[] b) {
        int n = Math.min(a.length, b.length);
        double[] r = new double[n];
        for (int i = 0; i < n; ++i) {
            r[i] = a[i] + b[i];
        }
        if (a.length != b.length) {
            IJ.log((String)"Warning: Arrays of different dimensions");
        }
        return r;
    }

    public double[] sub(double[] a, double[] b) {
        double[] r = this.add(a, this.prod(b, -1.0));
        return r;
    }

    public double dist(double[] a, double[] b) {
        double l = Math.sqrt(Math.pow(a[0] - b[0], 2.0) + Math.pow(a[1] - b[1], 2.0) + Math.pow(a[2] - b[2], 2.0));
        return l;
    }

    public double norm(double x, double y) {
        double l = Math.sqrt(x * x + y * y);
        return l;
    }

    public double norm(double[] a) {
        double l = 0.0;
        for (int i = 0; i < a.length; ++i) {
            l += a[i] * a[i];
        }
        return Math.sqrt(l);
    }

    public double[] normalized(double[] a) {
        double[] r = new double[a.length];
        double l = this.norm(a);
        r = l > 0.0 ? this.prod(a, 1.0 / l) : a;
        return r;
    }

    public double angle(double x1, double y1, double x2, double y2) {
        double c = (x1 * x2 + y1 * y2) / (Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2));
        double s = (x1 * y2 - y1 * x2) / (Math.sqrt(x1 * x1 + y1 * y1) * Math.sqrt(x2 * x2 + y2 * y2));
        if (c < -0.98) {
            return -3.14159;
        }
        if (s >= 0.0) {
            return Math.acos(c);
        }
        return 6.28318 - Math.acos(c);
    }
}

