/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats.imaris;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ResolutionLevel {
    private static final long BYTES_PER_MB = 0x100000L;
    private final int imageByteDepth_;
    private final int resIndex_;
    private long blockSizeX_;
    private long blockSizeY_;
    private long blockSizeZ_;
    private long blockSizeT_;
    private final int imageSizeX_;
    private final int imageSizeY_;
    private final int imageSizeZ_;
    private final int imageSizeT_;
    private int containerX_;
    private int containerY_;
    private int containerZ_;
    private final int reductionFactorX_;
    private final int reductionFactorY_;
    private final int reductionFactorZ_;

    public ResolutionLevel(int index, int baseWidth, int baseHeight, int baseDepth, int imageWidth, int imageHeight, int imageDepth, int numTimePoints, int byteDepth) {
        this.resIndex_ = index;
        this.imageSizeX_ = imageWidth;
        this.imageSizeY_ = imageHeight;
        this.imageSizeZ_ = imageDepth;
        this.imageSizeT_ = numTimePoints;
        this.imageByteDepth_ = byteDepth;
        this.reductionFactorX_ = (int)Math.ceil((double)baseWidth / (double)this.imageSizeX_);
        this.reductionFactorY_ = (int)Math.ceil((double)baseHeight / (double)this.imageSizeY_);
        this.reductionFactorZ_ = (int)Math.ceil((double)baseDepth / (double)this.imageSizeZ_);
        this.calculateBlockSize();
    }

    private void calculateBlockSize() {
        long blockSize = (long)Math.pow(2.0, Math.floor(Math.log(0x100000L / (long)this.imageByteDepth_) / Math.log(2.0)));
        long minBlockSizeX = 1L;
        long minBlockSizeY = 1L;
        long minBlockSizeZ = 1L;
        long minBlockSizeT = 1L;
        long imageSizeXYZT = this.imageSizeX_ * this.imageSizeY_ * this.imageSizeZ_ * this.imageSizeT_;
        ArrayList<BlockLayoutCost> blockLayoutCosts = new ArrayList<BlockLayoutCost>();
        for (long blockSizeX = 1L; blockSizeX <= blockSize; blockSizeX *= 2L) {
            long blockSizeY = 1L;
            while (blockSizeY * blockSizeX <= blockSize) {
                long blockSizeZ = 1L;
                while (blockSizeZ * blockSizeX * blockSizeY <= blockSize) {
                    long blockSizeT = blockSize / (blockSizeX * blockSizeY * blockSizeZ);
                    if ((this.imageSizeZ_ > 1 && blockSizeX == blockSizeY && blockSizeZ > 2L || this.imageSizeZ_ == 1 && blockSizeX <= 4L * blockSizeY && blockSizeY <= 4L * blockSizeX && blockSizeZ == 1L) && blockSizeX * blockSizeY * blockSizeZ * blockSizeT == blockSize && blockSizeX >= 1L && blockSizeY >= 1L && blockSizeZ >= 1L && blockSizeT >= 1L) {
                        long numBlocksX = 1L + (long)(this.imageSizeX_ - 1) / blockSizeX;
                        long numBlocksY = 1L + (long)(this.imageSizeY_ - 1) / blockSizeY;
                        long numBlocksZ = 1L + (long)(this.imageSizeZ_ - 1) / blockSizeZ;
                        long numBlocksT = 1L + (long)(this.imageSizeT_ - 1) / blockSizeT;
                        BlockLayoutCost cost = new BlockLayoutCost();
                        cost.sizeX = blockSizeX;
                        cost.sizeY = blockSizeY;
                        cost.sizeZ = blockSizeZ;
                        cost.sizeT = blockSizeT;
                        cost.costSlice = 1L + numBlocksX * numBlocksY + numBlocksX * numBlocksZ + numBlocksY * numBlocksZ - numBlocksX - numBlocksY - numBlocksZ;
                        cost.costGeometry = numBlocksX * numBlocksY + numBlocksX * numBlocksZ + numBlocksY * numBlocksZ;
                        cost.costMemory = numBlocksX * blockSizeX * numBlocksY * blockSizeY * numBlocksZ * blockSizeZ * numBlocksT * blockSizeT / imageSizeXYZT;
                        blockLayoutCosts.add(cost);
                    }
                    blockSizeZ *= 2L;
                }
                blockSizeY *= 2L;
            }
        }
        if (!blockLayoutCosts.isEmpty()) {
            Collections.sort(blockLayoutCosts, this.getLayoutCostComparator());
            BlockLayoutCost blcOptimum = (BlockLayoutCost)blockLayoutCosts.get(0);
            double memoryCostMax = 2.0;
            if (blcOptimum.costMemory > 2.0) {
                for (int i = 1; i < blockLayoutCosts.size(); ++i) {
                    if (!(((BlockLayoutCost)blockLayoutCosts.get((int)i)).costMemory <= 2.0)) continue;
                    blcOptimum = (BlockLayoutCost)blockLayoutCosts.get(i);
                    break;
                }
            }
            this.blockSizeX_ = blcOptimum.sizeX;
            this.blockSizeY_ = blcOptimum.sizeY;
            this.blockSizeZ_ = blcOptimum.sizeZ;
            this.blockSizeT_ = blcOptimum.sizeT;
        } else {
            int log2BlockSize = 0;
            while (Math.pow(2.0, log2BlockSize) < (double)(0x100000L / (long)this.imageByteDepth_)) {
                ++log2BlockSize;
            }
            int log2BlockSizeZ = log2BlockSize / 3;
            int log2BlockSizeY = (log2BlockSize - log2BlockSizeZ) / 2;
            int log2BlockSizeX = log2BlockSize - log2BlockSizeZ - log2BlockSizeY;
            this.blockSizeZ_ = (long)Math.pow(2.0, log2BlockSizeZ);
            this.blockSizeX_ = (long)Math.pow(2.0, log2BlockSizeX);
            this.blockSizeY_ = (long)Math.pow(2.0, log2BlockSizeY);
            this.blockSizeT_ = 1L;
        }
        this.containerX_ = (int)((double)this.blockSizeX_ * Math.ceil((double)this.imageSizeX_ / (double)this.blockSizeX_));
        this.containerY_ = (int)((double)this.blockSizeY_ * Math.ceil((double)this.imageSizeY_ / (double)this.blockSizeY_));
        this.containerZ_ = (int)((double)this.blockSizeZ_ * Math.ceil((double)this.imageSizeZ_ / (double)this.blockSizeZ_));
    }

    private Comparator<BlockLayoutCost> getLayoutCostComparator() {
        return new Comparator<BlockLayoutCost>(){

            @Override
            public int compare(BlockLayoutCost c1, BlockLayoutCost c2) {
                if (c1.costSlice != c2.costSlice) {
                    if (c1.costSlice < c2.costSlice) {
                        return -1;
                    }
                    return 1;
                }
                if (c1.costGeometry != c2.costGeometry) {
                    if (c1.costGeometry < c2.costGeometry) {
                        return -1;
                    }
                    return 1;
                }
                if (c1.costMemory < c2.costMemory) {
                    return -1;
                }
                if (c1.costMemory > c2.costMemory) {
                    return 1;
                }
                return 0;
            }
        };
    }

    public int getImageNumBytes() {
        return this.imageByteDepth_ * this.imageSizeX_ * this.imageSizeY_ * this.imageSizeZ_;
    }

    public int getImageByteDepth() {
        return this.imageByteDepth_;
    }

    public int getIndex() {
        return this.resIndex_;
    }

    public int getXBlockSize() {
        return (int)this.blockSizeX_;
    }

    public int getYBlockSize() {
        return (int)this.blockSizeY_;
    }

    public int getZBlockSize() {
        return (int)this.blockSizeZ_;
    }

    public int getTBlockSize() {
        return (int)this.blockSizeT_;
    }

    public int getImageSizeX() {
        return this.imageSizeX_;
    }

    public int getImageSizeY() {
        return this.imageSizeY_;
    }

    public int getImageSizeZ() {
        return this.imageSizeZ_;
    }

    public int getContainerSizeX() {
        return this.containerX_;
    }

    public int getContainerSizeY() {
        return this.containerY_;
    }

    public int getContainerSizeZ() {
        return this.containerZ_;
    }

    public int getReductionFactorX() {
        return this.reductionFactorX_;
    }

    public int getReductionFactorY() {
        return this.reductionFactorY_;
    }

    public int getReductionFactorZ() {
        return this.reductionFactorZ_;
    }

    private class BlockLayoutCost {
        public long sizeX;
        public long sizeY;
        public long sizeZ;
        public long sizeT;
        public double costSlice;
        public double costGeometry;
        public double costMemory;

        private BlockLayoutCost() {
        }
    }
}

