/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.imglib.container.shapelist;

import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.shapelist.ShapeList;
import mpicbg.imglib.container.shapelist.ShapeListCached;
import mpicbg.imglib.type.Type;

public class ShapeListContainerFactory
extends ContainerFactory {
    boolean useCaching = false;
    int cacheSize = 32;

    public ShapeListContainerFactory() {
    }

    public ShapeListContainerFactory(int cacheSize) {
        this.useCaching = true;
        this.cacheSize = cacheSize;
    }

    public void setCaching(boolean useCaching) {
        this.useCaching = useCaching;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean getCaching() {
        return this.useCaching;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public <T extends Type<T>> ShapeList<T> createContainer(int[] dim, T type) {
        if (this.useCaching) {
            return new ShapeListCached<T>(this, dim, type);
        }
        return new ShapeList<T>(this, dim, type);
    }

    @Override
    public String getErrorMessage() {
        return null;
    }

    @Override
    public void printProperties() {
    }

    @Override
    public void setParameters(String configuration) {
    }
}

