/*
 * Decompiled with CFR 0.152.
 */
package org.jogamp.java3d.utils.geometry;

import org.jogamp.java3d.utils.geometry.Triangulator;
import org.jogamp.vecmath.Point2f;
import org.jogamp.vecmath.Tuple2f;

class Clean {
    Clean() {
    }

    static void initPUnsorted(Triangulator triRef, int number) {
        if (number > triRef.maxNumPUnsorted) {
            triRef.maxNumPUnsorted = number;
            triRef.pUnsorted = new Point2f[triRef.maxNumPUnsorted];
            for (int i = 0; i < triRef.maxNumPUnsorted; ++i) {
                triRef.pUnsorted[i] = new Point2f();
            }
        }
    }

    static int cleanPolyhedralFace(Triangulator triRef, int i1, int i2) {
        int j;
        int i;
        Clean.initPUnsorted(triRef, triRef.numPoints);
        for (i = 0; i < triRef.numPoints; ++i) {
            triRef.pUnsorted[i].set((Tuple2f)triRef.points[i]);
        }
        Clean.sort(triRef.points, triRef.numPoints);
        i = 0;
        for (j = 1; j < triRef.numPoints; ++j) {
            if (Clean.pComp(triRef.points[i], triRef.points[j]) == 0) continue;
            triRef.points[++i] = triRef.points[j];
        }
        int numSorted = i + 1;
        int removed = triRef.numPoints - numSorted;
        for (i = i1; i < i2; ++i) {
            int ind1 = triRef.loops[i];
            int ind2 = triRef.fetchNextData(ind1);
            int index = triRef.fetchData(ind2);
            while (ind2 != ind1) {
                j = Clean.findPInd(triRef.points, numSorted, triRef.pUnsorted[index]);
                triRef.updateIndex(ind2, j);
                ind2 = triRef.fetchNextData(ind2);
                index = triRef.fetchData(ind2);
            }
            j = Clean.findPInd(triRef.points, numSorted, triRef.pUnsorted[index]);
            triRef.updateIndex(ind2, j);
        }
        triRef.numPoints = numSorted;
        return removed;
    }

    static void sort(Point2f[] points, int numPts) {
        Point2f swap = new Point2f();
        for (int i = 0; i < numPts; ++i) {
            for (int j = i + 1; j < numPts; ++j) {
                if (Clean.pComp(points[i], points[j]) <= 0) continue;
                swap.set((Tuple2f)points[i]);
                points[i].set((Tuple2f)points[j]);
                points[j].set((Tuple2f)swap);
            }
        }
    }

    static int findPInd(Point2f[] sorted, int numPts, Point2f pnt) {
        for (int i = 0; i < numPts; ++i) {
            if (pnt.x != sorted[i].x || pnt.y != sorted[i].y) continue;
            return i;
        }
        return -1;
    }

    static int pComp(Point2f a, Point2f b) {
        if (a.x < b.x) {
            return -1;
        }
        if (a.x > b.x) {
            return 1;
        }
        if (a.y < b.y) {
            return -1;
        }
        if (a.y > b.y) {
            return 1;
        }
        return 0;
    }
}

