/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import Jama.Matrix;
import ij.gui.Plot;
import java.awt.Color;
import sc.fiji.timelapse.LinearRegression;
import sc.fiji.timelapse.PlotUtils;

public class Extrema {
    protected double tolerance;
    protected double[] series;
    protected int extremaCount;
    protected double min;
    protected double max;
    protected int left;
    protected int right;
    protected double[] x;
    protected double[] intensities;

    public Extrema(double[] series, double tolerance, boolean findMaxima) {
        this.series = series;
        this.tolerance = tolerance;
        if (findMaxima) {
            this.negate(series);
        }
        this.getMinAndMax();
        this.x = new double[series.length];
        this.intensities = new double[series.length];
        this.extremaCount = 0;
        for (int i = 1; i < series.length - 1; ++i) {
            if (!this.getMinimumInterval(i)) continue;
            this.addMinimum(i);
        }
        this.x = this.shorten(this.x, this.extremaCount);
        this.intensities = this.shorten(this.intensities, this.extremaCount);
        if (findMaxima) {
            this.negate(series);
            this.negate(this.intensities);
        }
    }

    public Extrema(double[] series, int window, double minimalSlope, boolean findMaxima) {
        int i;
        this.series = series;
        double factor = findMaxima ? 1.0 : -1.0;
        this.x = new double[series.length];
        this.extremaCount = 0;
        for (i = window; i < series.length - window; ++i) {
            if (!(this.getSlope(i - window, i) * factor >= minimalSlope) || !(this.getSlope(i, i + window) * factor < -minimalSlope)) continue;
            if (this.extremaCount > 0 && (double)i - this.x[this.extremaCount - 1] < (double)(4 * window)) {
                if (!(series[(int)this.x[this.extremaCount - 1]] * factor < series[i] * factor)) continue;
                this.x[this.extremaCount - 1] = i;
                continue;
            }
            this.x[this.extremaCount++] = i;
        }
        this.x = this.shorten(this.x, this.extremaCount);
        this.intensities = new double[this.extremaCount];
        for (i = 0; i < this.extremaCount; ++i) {
            this.intensities[i] = series[(int)this.x[i]];
        }
    }

    protected double getSlope(int from, int to) {
        int i;
        LinearRegression regression = new LinearRegression();
        int n = i = from > 0 ? from : 0;
        while (i <= to && i < this.series.length) {
            regression.add(i, this.series[i]);
            ++i;
        }
        return regression.getA();
    }

    protected void negate(double[] series) {
        int i = 0;
        while (i < series.length) {
            int n = i++;
            series[n] = series[n] * -1.0;
        }
    }

    public double[] getX() {
        return this.x;
    }

    public double[] getIntensities() {
        return this.intensities;
    }

    protected boolean getMinimumInterval(int index) {
        double maxIntensity = this.series[index] + this.tolerance * (this.max - this.min);
        this.left = index;
        while (this.left > 0) {
            if (this.series[this.left - 1] < this.series[index]) {
                return false;
            }
            if (this.series[this.left - 1] > maxIntensity) break;
            --this.left;
        }
        this.right = index;
        while (this.right < this.series.length - 1) {
            if (this.series[this.right + 1] < this.series[index]) {
                return false;
            }
            if (this.series[this.right + 1] > maxIntensity) break;
            ++this.right;
        }
        return true;
    }

    protected void addMinimum(int middle) {
        this.x[this.extremaCount] = middle;
        this.intensities[this.extremaCount] = this.series[middle];
        ++this.extremaCount;
    }

    protected void addFittedMinimum(int middle) {
        if (this.left + 1 == this.right) {
            if (this.series[this.left] > this.series[this.right]) {
                this.left = this.right;
            } else {
                this.right = this.left;
            }
        }
        if (this.left == this.right) {
            this.x[this.extremaCount] = this.left;
            this.intensities[this.extremaCount] = this.series[this.left];
            ++this.extremaCount;
            return;
        }
        double yx2 = 0.0;
        double yx1 = 0.0;
        double y = 0.0;
        double x4 = 0.0;
        double x3 = 0.0;
        double x2 = 0.0;
        double x1 = 0.0;
        double total = this.right + 1 - this.left;
        while (this.left <= this.right) {
            x1 += (double)this.left;
            x2 += (double)(this.left * this.left);
            x3 += (double)(this.left * this.left * this.left);
            x4 += (double)(this.left * this.left * this.left * this.left);
            y += this.series[this.left];
            yx1 += this.series[this.left] * (double)this.left;
            yx2 += this.series[this.left] * (double)this.left * (double)this.left;
            ++this.left;
        }
        Matrix matrix = new Matrix((double[][])new double[][]{{x4 /= total, x3 /= total, x2 /= total}, {x3, x2, x1 /= total}, {x2, x1, 1.0}});
        Matrix rhs = new Matrix((double[][])new double[][]{{yx2 /= total}, {yx1 /= total}, {y /= total}});
        Matrix abc = matrix.solve(rhs);
        double a = abc.get(0, 0);
        double b = abc.get(1, 0);
        double c = abc.get(2, 0);
        this.x[this.extremaCount] = -b / 2.0 / a;
        this.intensities[this.extremaCount] = a * this.x[this.extremaCount] * this.x[this.extremaCount] + b * this.x[this.extremaCount] + c;
        ++this.extremaCount;
    }

    protected double[] shorten(double[] array, int length) {
        double[] result = new double[length];
        System.arraycopy(array, 0, result, 0, length);
        return result;
    }

    protected void getMinAndMax() {
        this.min = this.series[0];
        this.max = this.series[0];
        for (int i = 11; i < this.series.length; ++i) {
            if (this.min > this.series[i]) {
                this.min = this.series[i];
                continue;
            }
            if (!(this.max < this.series[i])) continue;
            this.max = this.series[i];
        }
    }

    public Plot getPlot() {
        double[] x = PlotUtils.range(0.0, this.series.length - 1);
        Plot plot = new Plot("Profile", "x", "intensity", x, this.series);
        PlotUtils.setLimits(plot, x, this.series, this.getX(), this.getIntensities());
        plot.draw();
        plot.setColor(Color.BLUE);
        plot.addPoints(this.getX(), this.getIntensities(), 0);
        return plot;
    }
}

