/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import mpicbg.ij.FeatureTransform;
import mpicbg.ij.SIFT;
import mpicbg.ij.util.Util;
import mpicbg.imagefeatures.Feature;
import mpicbg.imagefeatures.FloatArray2DSIFT;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;

public class SIFT_ExtractPointRoi
implements PlugIn {
    private static final DecimalFormat decimalFormat = new DecimalFormat();
    private static final DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
    private ImagePlus imp1;
    private ImagePlus imp2;
    private final List<Feature> fs1 = new ArrayList<Feature>();
    private final List<Feature> fs2 = new ArrayList<Feature>();
    private static final Param p = new Param();

    public SIFT_ExtractPointRoi() {
        decimalFormatSymbols.setGroupingSeparator(',');
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        decimalFormat.setMaximumFractionDigits(3);
        decimalFormat.setMinimumFractionDigits(3);
    }

    public void run(String args) {
        this.fs1.clear();
        this.fs2.clear();
        if (IJ.versionLessThan((String)"1.40")) {
            return;
        }
        int[] ids = WindowManager.getIDList();
        if (ids == null || ids.length < 2) {
            IJ.showMessage((String)"You should have at least two images open.");
            return;
        }
        String[] titles = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            titles[i] = WindowManager.getImage((int)ids[i]).getTitle();
        }
        GenericDialog gd = new GenericDialog("Extract SIFT Landmark Correspondences");
        gd.addMessage("Image Selection:");
        String current = WindowManager.getCurrentImage().getTitle();
        gd.addChoice("source_image", titles, current);
        gd.addChoice("target_image", titles, current.equals(titles[0]) ? titles[1] : titles[0]);
        gd.addMessage("Scale Invariant Interest Point Detector:");
        gd.addNumericField("initial_gaussian_blur :", (double)SIFT_ExtractPointRoi.p.sift.initialSigma, 2, 6, "px");
        gd.addNumericField("steps_per_scale_octave :", (double)SIFT_ExtractPointRoi.p.sift.steps, 0);
        gd.addNumericField("minimum_image_size :", (double)SIFT_ExtractPointRoi.p.sift.minOctaveSize, 0, 6, "px");
        gd.addNumericField("maximum_image_size :", (double)SIFT_ExtractPointRoi.p.sift.maxOctaveSize, 0, 6, "px");
        gd.addMessage("Feature Descriptor:");
        gd.addNumericField("feature_descriptor_size :", (double)SIFT_ExtractPointRoi.p.sift.fdSize, 0);
        gd.addNumericField("feature_descriptor_orientation_bins :", (double)SIFT_ExtractPointRoi.p.sift.fdBins, 0);
        gd.addNumericField("closest/next_closest_ratio :", (double)SIFT_ExtractPointRoi.p.rod, 2);
        gd.addMessage("Geometric Consensus Filter:");
        gd.addCheckbox("filter matches by geometric consensus", SIFT_ExtractPointRoi.p.useGeometricConsensusFilter);
        gd.addNumericField("maximal_alignment_error :", (double)SIFT_ExtractPointRoi.p.maxEpsilon, 2, 6, "px");
        gd.addNumericField("minimal_inlier_ratio :", (double)SIFT_ExtractPointRoi.p.minInlierRatio, 2);
        gd.addNumericField("minimal_number_of_inliers :", (double)SIFT_ExtractPointRoi.p.minNumInliers, 0);
        gd.addChoice("expected_transformation :", Param.modelStrings, Param.modelStrings[SIFT_ExtractPointRoi.p.modelIndex]);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.imp1 = WindowManager.getImage((int)ids[gd.getNextChoiceIndex()]);
        this.imp2 = WindowManager.getImage((int)ids[gd.getNextChoiceIndex()]);
        SIFT_ExtractPointRoi.p.sift.initialSigma = (float)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.sift.steps = (int)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.sift.minOctaveSize = (int)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.sift.maxOctaveSize = (int)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.sift.fdSize = (int)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.sift.fdBins = (int)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.rod = (float)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.useGeometricConsensusFilter = gd.getNextBoolean();
        SIFT_ExtractPointRoi.p.maxEpsilon = (float)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.minInlierRatio = (float)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.minNumInliers = (int)gd.getNextNumber();
        SIFT_ExtractPointRoi.p.modelIndex = gd.getNextChoiceIndex();
        this.exec(this.imp1, this.imp2);
    }

    public void exec(ImagePlus imp1, ImagePlus imp2, float initialSigma, int steps, int minOctaveSize, int maxOctaveSize, int fdSize, int fdBins, float rod, float maxEpsilon, float minInlierRatio, int modelIndex) {
        SIFT_ExtractPointRoi.p.sift.initialSigma = initialSigma;
        SIFT_ExtractPointRoi.p.sift.steps = steps;
        SIFT_ExtractPointRoi.p.sift.minOctaveSize = minOctaveSize;
        SIFT_ExtractPointRoi.p.sift.maxOctaveSize = maxOctaveSize;
        SIFT_ExtractPointRoi.p.sift.fdSize = fdSize;
        SIFT_ExtractPointRoi.p.sift.fdBins = fdBins;
        SIFT_ExtractPointRoi.p.rod = rod;
        SIFT_ExtractPointRoi.p.useGeometricConsensusFilter = true;
        SIFT_ExtractPointRoi.p.maxEpsilon = maxEpsilon;
        SIFT_ExtractPointRoi.p.minInlierRatio = minInlierRatio;
        SIFT_ExtractPointRoi.p.minNumInliers = 7;
        SIFT_ExtractPointRoi.p.modelIndex = modelIndex;
        this.exec(imp1, imp2);
    }

    public void exec(ImagePlus imp1, ImagePlus imp2, int modelIndex) {
        if (modelIndex < 0 || modelIndex > 3) {
            IJ.log((String)("Invalid model index: " + modelIndex));
            return;
        }
        SIFT_ExtractPointRoi.p.modelIndex = modelIndex;
        this.exec(imp1, imp2);
    }

    public void exec(ImagePlus imp1, ImagePlus imp2) {
        ArrayList inliers;
        FloatArray2DSIFT sift = new FloatArray2DSIFT(SIFT_ExtractPointRoi.p.sift);
        SIFT ijSIFT = new SIFT(sift);
        long start_time = System.currentTimeMillis();
        IJ.log((String)"Processing SIFT ...");
        ijSIFT.extractFeatures(imp1.getProcessor(), this.fs1);
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        IJ.log((String)(this.fs1.size() + " features extracted."));
        start_time = System.currentTimeMillis();
        IJ.log((String)"Processing SIFT ...");
        ijSIFT.extractFeatures(imp2.getProcessor(), this.fs2);
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        IJ.log((String)(this.fs2.size() + " features extracted."));
        start_time = System.currentTimeMillis();
        IJ.log((String)"Identifying correspondence candidates using brute force ...");
        ArrayList candidates = new ArrayList();
        FeatureTransform.matchFeatures(this.fs1, this.fs2, candidates, (float)SIFT_ExtractPointRoi.p.rod);
        IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
        ArrayList p1 = new ArrayList();
        ArrayList p2 = new ArrayList();
        if (SIFT_ExtractPointRoi.p.useGeometricConsensusFilter) {
            boolean modelFound;
            TranslationModel2D model;
            IJ.log((String)(candidates.size() + " potentially corresponding features identified."));
            start_time = System.currentTimeMillis();
            IJ.log((String)"Filtering correspondence candidates by geometric consensus ...");
            inliers = new ArrayList();
            switch (SIFT_ExtractPointRoi.p.modelIndex) {
                case 0: {
                    model = new TranslationModel2D();
                    break;
                }
                case 1: {
                    model = new RigidModel2D();
                    break;
                }
                case 2: {
                    model = new SimilarityModel2D();
                    break;
                }
                case 3: {
                    model = new AffineModel2D();
                    break;
                }
                case 4: {
                    model = new HomographyModel2D();
                    break;
                }
                default: {
                    return;
                }
            }
            try {
                modelFound = model.filterRansac(candidates, inliers, 1000, (double)SIFT_ExtractPointRoi.p.maxEpsilon, (double)SIFT_ExtractPointRoi.p.minInlierRatio, SIFT_ExtractPointRoi.p.minNumInliers);
            }
            catch (NotEnoughDataPointsException e) {
                modelFound = false;
            }
            IJ.log((String)(" took " + (System.currentTimeMillis() - start_time) + "ms."));
            if (modelFound) {
                PointMatch.apply(inliers, (CoordinateTransform)model);
                IJ.log((String)(inliers.size() + " corresponding features with an average displacement of " + decimalFormat.format(PointMatch.meanDistance(inliers)) + "px identified."));
                IJ.log((String)("Estimated transformation model: " + model));
            } else {
                IJ.log((String)"No correspondences found.");
            }
        } else {
            inliers = candidates;
            IJ.log((String)(candidates.size() + " corresponding features identified."));
        }
        if (inliers.size() > 0) {
            PointMatch.sourcePoints(inliers, p1);
            PointMatch.targetPoints(inliers, p2);
            imp1.setRoi((Roi)Util.pointsToPointRoi(p1));
            imp2.setRoi((Roi)Util.pointsToPointRoi(p2));
        }
    }

    private static class Param {
        public final FloatArray2DSIFT.Param sift = new FloatArray2DSIFT.Param();
        public float rod = 0.92f;
        public boolean useGeometricConsensusFilter = true;
        public float maxEpsilon = 25.0f;
        public float minInlierRatio = 0.05f;
        public int minNumInliers = 7;
        public static final String[] modelStrings = new String[]{"Translation", "Rigid", "Similarity", "Affine", "Perspective"};
        public int modelIndex = 1;

        private Param() {
        }
    }
}

