/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.gui.BigWarpLandmarkPanel;
import bigwarp.BigWarp;
import bigwarp.landmarks.LandmarkTableModel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.scijava.ui.behaviour.util.AbstractNamedAction;

public class LandmarkPointMenu
extends JPopupMenu {
    public static final boolean MOVING = true;
    public static final boolean FIXED = false;
    private static final long serialVersionUID = -3676180390835767585L;
    protected BigWarpLandmarkPanel landmarkPanel;
    protected BigWarp<?> bw;
    public ClearSelectedHandler clearSelectedMoving;
    public ClearSelectedHandler clearSelectedFixed;
    public DeleteSelectedHandler deleteSelectedHandler;
    public ActivateSelectedHandler activateSelectedHandler;
    public DeactivateSelectedHandler deactivateSelectedHandler;
    public AddToSelection addAboveHandler;
    public AddToSelection addAllAboveHandler;
    public AddToSelection addBelowHandler;
    public AddToSelection addAllBelowHandler;
    protected MouseListener popupListener;
    protected JMenuItem deleteAllItem;
    protected JMenuItem activateAllItem;
    protected JMenuItem deactivateAllItem;
    protected JMenuItem clearSelectedMovingItem;
    protected JMenuItem clearSelectedFixedItem;
    private Point clickPt;

    public LandmarkPointMenu(BigWarp<?> bw) {
        this(bw.getLandmarkPanel());
        this.bw = bw;
    }

    public LandmarkPointMenu(BigWarpLandmarkPanel landmarkPanel) {
        this.landmarkPanel = landmarkPanel;
        this.deleteSelectedHandler = new DeleteSelectedHandler("table delete selected");
        this.activateSelectedHandler = new ActivateSelectedHandler("table activate selected");
        this.deactivateSelectedHandler = new DeactivateSelectedHandler("table deactivate selected ");
        this.clearSelectedMoving = new ClearSelectedHandler("table clear selected moving", true);
        this.clearSelectedFixed = new ClearSelectedHandler("table clear selected fixed", false);
        this.addAboveHandler = new AddToSelection("select landmark above", true, false);
        this.addAllAboveHandler = new AddToSelection("select all landmarks above", true, true);
        this.addBelowHandler = new AddToSelection("select landmark below", false, false);
        this.addAllBelowHandler = new AddToSelection("select all landmarks below", false, true);
        this.popupListener = new PopupListener();
        this.deleteAllItem = new JMenuItem("Delete");
        this.deleteAllItem.addActionListener((ActionListener)((Object)this.deleteSelectedHandler));
        this.clearSelectedMovingItem = new JMenuItem("Clear moving");
        this.clearSelectedMovingItem.addActionListener((ActionListener)((Object)this.clearSelectedMoving));
        this.clearSelectedFixedItem = new JMenuItem("Clear fixed");
        this.clearSelectedFixedItem.addActionListener((ActionListener)((Object)this.clearSelectedFixed));
        this.activateAllItem = new JMenuItem("Activate");
        this.activateAllItem.addActionListener((ActionListener)((Object)this.activateSelectedHandler));
        this.deactivateAllItem = new JMenuItem("Deactivate");
        this.deactivateAllItem.addActionListener((ActionListener)((Object)this.deactivateSelectedHandler));
        this.add(this.deleteAllItem);
        this.addSeparator();
        this.add(this.clearSelectedMovingItem);
        this.add(this.clearSelectedFixedItem);
        this.addSeparator();
        this.add(this.activateAllItem);
        this.add(this.deactivateAllItem);
    }

    public void setupListeners() {
        this.landmarkPanel.getJTable().addMouseListener(this.popupListener);
    }

    public static void updateBigwarp(BigWarp<?> bw, LandmarkTableModel model) {
        if (bw != null) {
            if (model.getActiveRowCount() < 4 && bw.getOverlayP().getIsTransformed()) {
                bw.getViewerFrameP().getViewerPanel().showMessage("Require 4 points for transform");
                bw.setIsMovingDisplayTransformed(false);
            } else {
                bw.restimateTransformation();
            }
        }
    }

    public class AddToSelection
    extends AbstractNamedAction {
        private static final long serialVersionUID = -904756750247052099L;
        private final boolean before;
        private final boolean all;

        public AddToSelection(String name, boolean before, boolean all) {
            super(name);
            this.before = before;
            this.all = all;
        }

        public void actionPerformed(ActionEvent e) {
            int i;
            int j;
            int[] selectedRows = LandmarkPointMenu.this.landmarkPanel.getJTable().getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
            Arrays.sort(selectedRows);
            if (this.before) {
                j = selectedRows[0];
                i = this.all ? 0 : j - 1;
            } else {
                i = selectedRows[selectedRows.length - 1];
                j = this.all ? LandmarkPointMenu.this.landmarkPanel.getJTable().getRowCount() - 1 : i + 1;
            }
            LandmarkPointMenu.this.landmarkPanel.getJTable().getSelectionModel().addSelectionInterval(i, j);
            if (LandmarkPointMenu.this.bw != null) {
                LandmarkPointMenu.this.bw.restimateTransformation();
            }
            LandmarkPointMenu.this.landmarkPanel.repaint();
        }
    }

    public class DeactivateSelectedHandler
    extends AbstractNamedAction {
        private static final long serialVersionUID = -7703797647219426189L;

        public DeactivateSelectedHandler(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = LandmarkPointMenu.this.landmarkPanel.getJTable().getSelectedRows();
            Arrays.sort(selectedRows);
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int j = selectedRows[i];
                LandmarkPointMenu.this.landmarkPanel.getTableModel().setIsActive(j, false);
            }
            if (LandmarkPointMenu.this.bw != null) {
                LandmarkPointMenu.this.bw.restimateTransformation();
            }
            LandmarkPointMenu.this.landmarkPanel.repaint();
        }
    }

    public class ActivateSelectedHandler
    extends AbstractNamedAction {
        private static final long serialVersionUID = 3617611493865908091L;

        public ActivateSelectedHandler(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = LandmarkPointMenu.this.landmarkPanel.getJTable().getSelectedRows();
            Arrays.sort(selectedRows);
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int j = selectedRows[i];
                LandmarkPointMenu.this.landmarkPanel.getTableModel().setIsActive(j, true);
            }
            if (LandmarkPointMenu.this.bw != null) {
                LandmarkPointMenu.this.bw.restimateTransformation();
            }
            LandmarkPointMenu.this.landmarkPanel.repaint();
        }
    }

    public class ClearSelectedHandler
    extends AbstractNamedAction {
        private static final long serialVersionUID = -7023942870606943587L;
        final boolean moving;

        public ClearSelectedHandler(String name, boolean isMoving) {
            super(name);
            this.moving = isMoving;
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = LandmarkPointMenu.this.landmarkPanel.getJTable().getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int j = selectedRows[i];
                LandmarkPointMenu.this.landmarkPanel.getTableModel().clearPt(j, this.moving);
            }
            if (LandmarkPointMenu.this.bw != null) {
                LandmarkPointMenu.this.bw.restimateTransformation();
            }
            LandmarkPointMenu.this.landmarkPanel.repaint();
        }
    }

    public class ClearHandler
    extends AbstractNamedAction {
        private static final long serialVersionUID = -2082631635521009679L;
        final boolean moving;

        public ClearHandler(String name, boolean isMoving) {
            super(name);
            this.moving = isMoving;
        }

        public void actionPerformed(ActionEvent e) {
            int j = LandmarkPointMenu.this.landmarkPanel.getJTable().rowAtPoint(LandmarkPointMenu.this.clickPt);
            LandmarkPointMenu.this.landmarkPanel.getTableModel().clearPt(j, this.moving);
            if (LandmarkPointMenu.this.bw != null) {
                LandmarkPointMenu.this.bw.restimateTransformation();
            }
            LandmarkPointMenu.this.landmarkPanel.repaint();
        }
    }

    public class DeleteSelectedHandler
    extends AbstractNamedAction {
        private static final long serialVersionUID = -6499718644014842587L;

        public DeleteSelectedHandler(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            int[] selectedRows = LandmarkPointMenu.this.landmarkPanel.getJTable().getSelectedRows();
            for (int i = selectedRows.length - 1; i >= 0; --i) {
                int j = selectedRows[i];
                LandmarkPointMenu.this.landmarkPanel.getTableModel().deleteRow(j);
            }
            LandmarkPointMenu.updateBigwarp(LandmarkPointMenu.this.bw, LandmarkPointMenu.this.landmarkPanel.getTableModel());
            LandmarkPointMenu.this.landmarkPanel.repaint();
        }
    }

    public class DeleteHandler
    extends AbstractNamedAction {
        private static final long serialVersionUID = -3405442710985689438L;

        public DeleteHandler(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            int j = LandmarkPointMenu.this.landmarkPanel.getJTable().rowAtPoint(LandmarkPointMenu.this.clickPt);
            LandmarkTableModel model = LandmarkPointMenu.this.landmarkPanel.getTableModel();
            model.deleteRow(j);
            LandmarkPointMenu.updateBigwarp(LandmarkPointMenu.this.bw, LandmarkPointMenu.this.landmarkPanel.getTableModel());
            LandmarkPointMenu.this.landmarkPanel.repaint();
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (this.isRightClick(e)) {
                LandmarkPointMenu.this.clickPt = e.getPoint();
                LandmarkPointMenu.this.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        private boolean isRightClick(MouseEvent e) {
            return e.getButton() == 3;
        }
    }
}

