/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer.animate;

import bdv.viewer.animate.AbstractTransformAnimator;
import bigwarp.util.Rotation2DHelpers;
import net.imglib2.realtransform.AffineTransform3D;

public class RotationAnimator2D
extends AbstractTransformAnimator {
    private final AffineTransform3D transformStart;
    private final double cX;
    private final double cY;
    private final double totalAngle;
    private final AffineTransform3D transform;

    public RotationAnimator2D(AffineTransform3D transformStart, double viewerCenterX, double viewerCenterY, AffineTransform3D target, long duration) {
        super(duration);
        this.transformStart = transformStart;
        this.cX = viewerCenterX;
        this.cY = viewerCenterY;
        double angleStart = Rotation2DHelpers.extractRotation(transformStart);
        double angleEnd = Rotation2DHelpers.extractRotation(target);
        this.totalAngle = Rotation2DHelpers.shorterAngleBetweenRotations(angleStart, angleEnd);
        this.transform = new AffineTransform3D();
    }

    public AffineTransform3D get(double t) {
        this.transform.set(this.transformStart);
        this.transform.translate(new double[]{-this.cX, -this.cY, 0.0});
        this.transform.rotate(2, this.totalAngle * t);
        this.transform.translate(new double[]{this.cX, this.cY, 0.0});
        return this.transform;
    }
}

