/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout.hierarchical;

import com.mxgraph.layout.hierarchical.model.mxGraphHierarchyModel;
import com.mxgraph.layout.hierarchical.stage.mxCoordinateAssignment;
import com.mxgraph.layout.hierarchical.stage.mxMedianHybridCrossingReduction;
import com.mxgraph.layout.hierarchical.stage.mxMinimumCycleRemover;
import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGraphModel;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import com.mxgraph.view.mxGraphView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class mxHierarchicalLayout
extends mxGraphLayout {
    protected List<Object> roots = null;
    protected boolean resizeParent = true;
    protected boolean moveParent = false;
    protected int parentBorder = 0;
    protected double intraCellSpacing = 30.0;
    protected double interRankCellSpacing = 50.0;
    protected double interHierarchySpacing = 60.0;
    protected double parallelEdgeSpacing = 10.0;
    protected int orientation = 1;
    protected boolean disableEdgeStyle = true;
    protected boolean fineTuning = true;
    protected boolean traverseAncestors = true;
    protected mxGraphHierarchyModel model = null;

    public mxHierarchicalLayout(mxGraph graph) {
        this(graph, 1);
    }

    public mxHierarchicalLayout(mxGraph graph, int orientation) {
        super(graph);
        this.orientation = orientation;
    }

    public mxGraphHierarchyModel getModel() {
        return this.model;
    }

    @Override
    public void execute(Object parent) {
        this.execute(parent, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object parent, List<Object> roots) {
        super.execute(parent);
        mxIGraphModel model = this.graph.getModel();
        if (roots == null && parent == null) {
            return;
        }
        if (roots != null && parent != null) {
            for (Object root : roots) {
                if (model.isAncestor(parent, root)) continue;
                roots.remove(root);
            }
        }
        this.roots = roots;
        model.beginUpdate();
        try {
            this.run(parent);
            if (this.isResizeParent() && !this.graph.isCellCollapsed(parent)) {
                this.graph.updateGroupBounds(new Object[]{parent}, this.getParentBorder(), this.isMoveParent());
            }
        }
        finally {
            model.endUpdate();
        }
    }

    public List<Object> findRoots(Object parent, Set<Object> vertices) {
        ArrayList<Object> roots = new ArrayList<Object>();
        Object best = null;
        int maxDiff = -100000;
        mxIGraphModel model = this.graph.getModel();
        for (Object vertex : vertices) {
            int diff;
            if (!model.isVertex(vertex) || !this.graph.isCellVisible(vertex)) continue;
            Object[] conns = this.getEdges(vertex);
            int fanOut = 0;
            int fanIn = 0;
            for (int k = 0; k < conns.length; ++k) {
                Object src = this.graph.getView().getVisibleTerminal(conns[k], true);
                if (src == vertex) {
                    ++fanOut;
                    continue;
                }
                ++fanIn;
            }
            if (fanIn == 0 && fanOut > 0) {
                roots.add(vertex);
            }
            if ((diff = fanOut - fanIn) <= maxDiff) continue;
            maxDiff = diff;
            best = vertex;
        }
        if (roots.isEmpty() && best != null) {
            roots.add(best);
        }
        return roots;
    }

    public Object[] getEdges(Object cell) {
        mxIGraphModel model = this.graph.getModel();
        boolean isCollapsed = this.graph.isCellCollapsed(cell);
        ArrayList<Object> edges = new ArrayList<Object>();
        int childCount = model.getChildCount(cell);
        for (int i = 0; i < childCount; ++i) {
            Object child = model.getChildAt(cell, i);
            if (!isCollapsed && this.graph.isCellVisible(child)) continue;
            edges.addAll(Arrays.asList(mxGraphModel.getEdges(model, child, true, true, false)));
        }
        edges.addAll(Arrays.asList(mxGraphModel.getEdges(model, cell, true, true, false)));
        ArrayList result = new ArrayList(edges.size());
        for (Object e : edges) {
            Object target;
            mxCellState state = this.graph.getView().getState(e);
            Object source = state != null ? state.getVisibleTerminal(true) : this.graph.getView().getVisibleTerminal(e, true);
            if (source == (target = state != null ? state.getVisibleTerminal(false) : this.graph.getView().getVisibleTerminal(e, false)) || (target != cell || this.parent != null && !this.graph.isValidAncestor(source, this.parent, this.traverseAncestors)) && (source != cell || this.parent != null && !this.graph.isValidAncestor(target, this.parent, this.traverseAncestors))) continue;
            result.add(e);
        }
        return result.toArray();
    }

    public void run(Object parent) {
        ArrayList<Set<Object>> hierarchyVertices = new ArrayList<Set<Object>>();
        LinkedHashSet<Object> allVertexSet = new LinkedHashSet<Object>();
        if (this.roots == null && parent != null) {
            Set<Object> filledVertexSet = this.filterDescendants(parent);
            this.roots = new ArrayList<Object>();
            while (!filledVertexSet.isEmpty()) {
                List<Object> candidateRoots = this.findRoots(parent, filledVertexSet);
                for (Object object : candidateRoots) {
                    LinkedHashSet<Object> vertexSet = new LinkedHashSet<Object>();
                    hierarchyVertices.add(vertexSet);
                    this.traverse(object, true, null, allVertexSet, vertexSet, hierarchyVertices, filledVertexSet);
                }
                this.roots.addAll(candidateRoots);
            }
        } else {
            for (int i = 0; i < this.roots.size(); ++i) {
                LinkedHashSet<Object> vertexSet = new LinkedHashSet<Object>();
                hierarchyVertices.add(vertexSet);
                this.traverse(this.roots.get(i), true, null, allVertexSet, vertexSet, hierarchyVertices, null);
            }
        }
        double initialX = 0.0;
        for (Set set : hierarchyVertices) {
            this.model = new mxGraphHierarchyModel(this, set.toArray(), this.roots, parent);
            this.cycleStage(parent);
            this.layeringStage();
            this.crossingStage(parent);
            initialX = this.placementStage(initialX, parent);
        }
    }

    public Set<Object> filterDescendants(Object cell) {
        mxIGraphModel model = this.graph.getModel();
        LinkedHashSet<Object> result = new LinkedHashSet<Object>();
        if (model.isVertex(cell) && cell != this.parent && this.graph.isCellVisible(cell)) {
            result.add(cell);
        }
        if (this.traverseAncestors || cell == this.parent && this.graph.isCellVisible(cell)) {
            int childCount = model.getChildCount(cell);
            for (int i = 0; i < childCount; ++i) {
                Object child = model.getChildAt(cell, i);
                result.addAll(this.filterDescendants(child));
            }
        }
        return result;
    }

    protected void traverse(Object vertex, boolean directed, Object edge, Set<Object> allVertices, Set<Object> currentComp, List<Set<Object>> hierarchyVertices, Set<Object> filledVertexSet) {
        mxGraphView view = this.graph.getView();
        mxIGraphModel model = this.graph.getModel();
        if (vertex != null && allVertices != null) {
            if (!allVertices.contains(vertex) && (filledVertexSet == null || filledVertexSet.contains(vertex))) {
                int edgeCount;
                currentComp.add(vertex);
                allVertices.add(vertex);
                if (filledVertexSet != null) {
                    filledVertexSet.remove(vertex);
                }
                if ((edgeCount = model.getEdgeCount(vertex)) > 0) {
                    for (int i = 0; i < edgeCount; ++i) {
                        boolean isSource;
                        Object e = model.getEdgeAt(vertex, i);
                        boolean bl = isSource = view.getVisibleTerminal(e, true) == vertex;
                        if (directed && !isSource) continue;
                        Object next = view.getVisibleTerminal(e, !isSource);
                        this.traverse(next, directed, e, allVertices, currentComp, hierarchyVertices, filledVertexSet);
                    }
                }
            } else if (!currentComp.contains(vertex)) {
                Set<Object> matchComp = null;
                for (Set<Object> comp : hierarchyVertices) {
                    if (!comp.contains(vertex)) continue;
                    currentComp.addAll(comp);
                    matchComp = comp;
                    break;
                }
                if (matchComp != null) {
                    hierarchyVertices.remove(matchComp);
                }
            }
        }
    }

    public void cycleStage(Object parent) {
        mxMinimumCycleRemover cycleStage = new mxMinimumCycleRemover(this);
        cycleStage.execute(parent);
    }

    public void layeringStage() {
        this.model.initialRank();
        this.model.fixRanks();
    }

    public void crossingStage(Object parent) {
        mxMedianHybridCrossingReduction crossingStage = new mxMedianHybridCrossingReduction(this);
        crossingStage.execute(parent);
    }

    public double placementStage(double initialX, Object parent) {
        mxCoordinateAssignment placementStage = new mxCoordinateAssignment(this, this.intraCellSpacing, this.interRankCellSpacing, this.orientation, initialX, this.parallelEdgeSpacing);
        placementStage.setFineTuning(this.fineTuning);
        placementStage.execute(parent);
        return placementStage.getLimitX() + this.interHierarchySpacing;
    }

    public boolean isResizeParent() {
        return this.resizeParent;
    }

    public void setResizeParent(boolean value) {
        this.resizeParent = value;
    }

    public boolean isMoveParent() {
        return this.moveParent;
    }

    public void setMoveParent(boolean value) {
        this.moveParent = value;
    }

    public int getParentBorder() {
        return this.parentBorder;
    }

    public void setParentBorder(int value) {
        this.parentBorder = value;
    }

    public double getIntraCellSpacing() {
        return this.intraCellSpacing;
    }

    public void setIntraCellSpacing(double intraCellSpacing) {
        this.intraCellSpacing = intraCellSpacing;
    }

    public double getInterRankCellSpacing() {
        return this.interRankCellSpacing;
    }

    public void setInterRankCellSpacing(double interRankCellSpacing) {
        this.interRankCellSpacing = interRankCellSpacing;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.orientation = orientation;
    }

    public double getInterHierarchySpacing() {
        return this.interHierarchySpacing;
    }

    public void setInterHierarchySpacing(double interHierarchySpacing) {
        this.interHierarchySpacing = interHierarchySpacing;
    }

    public double getParallelEdgeSpacing() {
        return this.parallelEdgeSpacing;
    }

    public void setParallelEdgeSpacing(double parallelEdgeSpacing) {
        this.parallelEdgeSpacing = parallelEdgeSpacing;
    }

    public boolean isFineTuning() {
        return this.fineTuning;
    }

    public void setFineTuning(boolean fineTuning) {
        this.fineTuning = fineTuning;
    }

    public boolean isDisableEdgeStyle() {
        return this.disableEdgeStyle;
    }

    public void setDisableEdgeStyle(boolean disableEdgeStyle) {
        this.disableEdgeStyle = disableEdgeStyle;
    }

    public String toString() {
        return "Hierarchical";
    }
}

