/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class INRReader
extends FormatReader {
    private static final String INR_MAGIC = "#INRIMAGE";
    private static final int HEADER_SIZE = 256;

    public INRReader() {
        super("INR", "inr");
        this.domains = new String[]{"Unknown"};
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = INR_MAGIC.length();
        if (!FormatTools.validStream((RandomAccessInputStream)stream, (int)blockLen, (boolean)false)) {
            return false;
        }
        return stream.readString(blockLen).indexOf(INR_MAGIC) == 0;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        long planeSize = FormatTools.getPlaneSize((IFormatReader)this);
        this.in.seek(256L + (long)no * planeSize);
        this.readPlane(this.in, x, y, w, h, buf);
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        LOGGER.info("Reading header");
        String header = this.in.readString(256);
        String[] lines = header.split("\n");
        Double physicalSizeX = null;
        Double physicalSizeY = null;
        Double physicalSizeZ = null;
        boolean isSigned = false;
        int nBits = 0;
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        for (String line : lines) {
            int index = line.indexOf(61);
            if (index < 0) continue;
            String key = line.substring(0, index);
            String value = line.substring(index + 1);
            this.addGlobalMeta(key, value);
            if (key.equals("XDIM")) {
                m.sizeX = Integer.parseInt(value);
                continue;
            }
            if (key.equals("YDIM")) {
                m.sizeY = Integer.parseInt(value);
                continue;
            }
            if (key.equals("ZDIM")) {
                m.sizeZ = Integer.parseInt(value);
                continue;
            }
            if (key.equals("VDIM")) {
                m.sizeT = Integer.parseInt(value);
                continue;
            }
            if (key.equals("TYPE")) {
                isSigned = value.toLowerCase().startsWith("signed");
                continue;
            }
            if (key.equals("PIXSIZE")) {
                String bits = value.substring(0, value.indexOf(32));
                nBits = Integer.parseInt(bits);
                continue;
            }
            if (key.equals("VX")) {
                physicalSizeX = DataTools.parseDouble(value);
                continue;
            }
            if (key.equals("VY")) {
                physicalSizeY = DataTools.parseDouble(value);
                continue;
            }
            if (!key.equals("VZ")) continue;
            physicalSizeZ = DataTools.parseDouble(value);
        }
        LOGGER.info("Populating metadata");
        if (this.getSizeZ() == 0) {
            m.sizeZ = 1;
        }
        if (this.getSizeT() == 0) {
            m.sizeT = 1;
        }
        m.sizeC = 1;
        m.imageCount = this.getSizeZ() * this.getSizeT() * this.getSizeC();
        m.pixelType = FormatTools.pixelTypeFromBytes((int)(nBits / 8), (boolean)isSigned, (boolean)false);
        m.dimensionOrder = "XYZTC";
        LOGGER.info("Populating OME metadata");
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            Length sizeX = FormatTools.getPhysicalSizeX(physicalSizeX);
            Length sizeY = FormatTools.getPhysicalSizeY(physicalSizeY);
            Length sizeZ = FormatTools.getPhysicalSizeZ(physicalSizeZ);
            if (sizeX != null) {
                store.setPixelsPhysicalSizeX(sizeX, 0);
            }
            if (sizeY != null) {
                store.setPixelsPhysicalSizeY(sizeY, 0);
            }
            if (sizeZ != null) {
                store.setPixelsPhysicalSizeZ(sizeZ, 0);
            }
        }
    }
}

