/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.vaa3d.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.zip.DataFormatException;
import org.janelia.vaa3d.reader.Pbd16InputStream;
import org.janelia.vaa3d.reader.Pbd8InputStream;

public class V3dRawImageStream {
    public static final String[] V3DRAW_MAGIC_COOKIE = new String[]{"raw_image_stack_by_hpeng", "v3d_volume_pkbitdf_encod", "v3d_stack_pkbit_by_gene1"};
    private InputStream inStream;
    private String headerKey;
    private Format format;
    private int pixelBytes = 0;
    private ByteOrder endian = ByteOrder.LITTLE_ENDIAN;
    private int[] dimensions = new int[]{0, 0, 0, 0};
    private Slice currentSlice;

    public V3dRawImageStream(InputStream input) {
        this.inStream = input;
        try {
            this.loadHeader(input);
        }
        catch (IOException exc) {
            throw new IllegalArgumentException(exc);
        }
        catch (DataFormatException exc) {
            throw new IllegalArgumentException(exc);
        }
    }

    public ByteOrder getByteOrder() {
        return this.endian;
    }

    public InputStream getDataInputStream() {
        return this.inStream;
    }

    public int getDimension(int index) {
        return this.dimensions[index];
    }

    public int getPixelBytes() {
        return this.pixelBytes;
    }

    public void writeHeader(OutputStream headerOutputStream, Format v3dFormat) throws IOException {
        byte[] buffer0 = new byte[4];
        ByteBuffer buffer = ByteBuffer.wrap(buffer0);
        buffer.order(this.endian);
        ShortBuffer shortBuffer = buffer.asShortBuffer();
        IntBuffer intBuffer = buffer.asIntBuffer();
        headerOutputStream.write(V3DRAW_MAGIC_COOKIE[v3dFormat.ordinal()].getBytes(), 0, 24);
        if (this.endian == ByteOrder.BIG_ENDIAN) {
            headerOutputStream.write("B".getBytes(), 0, 1);
        } else {
            headerOutputStream.write("L".getBytes(), 0, 1);
        }
        shortBuffer.rewind();
        shortBuffer.put((short)this.pixelBytes);
        headerOutputStream.write(buffer0, 0, 2);
        for (int dim : this.dimensions) {
            intBuffer.rewind();
            intBuffer.put(dim);
            headerOutputStream.write(buffer0, 0, 4);
        }
    }

    private void loadHeader(InputStream headerInputStream) throws IOException, DataFormatException {
        byte[] buffer0 = new byte[43];
        ByteBuffer buffer = ByteBuffer.wrap(buffer0);
        headerInputStream.read(buffer.array(), 0, 43);
        buffer.rewind();
        this.headerKey = new String(buffer.array(), 0, 24);
        this.format = null;
        for (Format f : Format.values()) {
            if (!this.headerKey.equals(V3DRAW_MAGIC_COOKIE[f.ordinal()])) continue;
            this.format = f;
            break;
        }
        if (this.format == null) {
            throw new DataFormatException("Vaa3D raw file header mismatch: " + this.headerKey);
        }
        buffer.position(24);
        char endianChar = (char)buffer.get();
        if (endianChar == 'B') {
            this.endian = ByteOrder.BIG_ENDIAN;
        } else if (endianChar == 'L') {
            this.endian = ByteOrder.LITTLE_ENDIAN;
        } else {
            throw new DataFormatException("Unrecognized endian field: " + endianChar);
        }
        buffer.order(this.endian);
        this.pixelBytes = buffer.getShort();
        if (this.pixelBytes <= 0 || this.pixelBytes > 4) {
            throw new DataFormatException("Illegal number of pixel bytes: " + this.pixelBytes);
        }
        this.dimensions = new int[]{buffer.getInt(), buffer.getInt(), buffer.getInt(), buffer.getInt()};
        this.currentSlice = new Slice(this.dimensions[0], this.dimensions[1], this.pixelBytes, this.endian);
        if (this.format == Format.FORMAT_MURPHY_PBD) {
            this.inStream = this.pixelBytes == 1 ? new Pbd8InputStream(this.inStream) : new Pbd16InputStream(this.inStream, this.endian);
        } else {
            if (this.format == Format.FORMAT_MYERS_PBD) {
                throw new IllegalArgumentException("Loading Myers' pbd is not yet implemented");
            }
            if (this.format == Format.FORMAT_PENG_RAW) {
                // empty if block
            }
        }
    }

    public Slice getCurrentSlice() {
        return this.currentSlice;
    }

    public void loadNextSlice() throws IOException {
        this.currentSlice.read(this.inStream);
    }

    class Slice {
        private int sliceByteCount;
        private ByteBuffer sliceBuffer;
        private int sliceIndex;
        private int sx;
        private int pixelBytes;

        public Slice(int sizeX, int sizeY, int pixelBytes, ByteOrder byteOrder) {
            this.sliceByteCount = sizeX * sizeY * pixelBytes;
            byte[] buffer0 = new byte[this.sliceByteCount];
            this.sliceBuffer = ByteBuffer.wrap(buffer0);
            this.sliceBuffer.order(byteOrder);
            this.sliceIndex = -1;
            this.sx = sizeX;
            this.pixelBytes = pixelBytes;
        }

        public int getSliceIndex() {
            return this.sliceIndex;
        }

        public ByteBuffer getByteBuffer() {
            return this.sliceBuffer;
        }

        public int getValue(int x, int y) {
            int index = x + this.sx * y;
            if (this.pixelBytes == 1) {
                return this.sliceBuffer.get(index);
            }
            if (this.pixelBytes == 2) {
                return this.sliceBuffer.getShort(index);
            }
            return this.sliceBuffer.getInt(index);
        }

        public void read(InputStream inStream) throws IOException {
            inStream.read(this.sliceBuffer.array(), 0, this.sliceByteCount);
            ++this.sliceIndex;
        }
    }

    public static enum Format {
        FORMAT_PENG_RAW,
        FORMAT_MURPHY_PBD,
        FORMAT_MYERS_PBD;

    }
}

