/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import java.util.AbstractList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Stream;
import net.imglib2.type.label.MappedAccess;
import net.imglib2.type.label.MappedAccessData;
import net.imglib2.type.label.MappedObject;
import net.imglib2.type.label.RefList;

public class MappedObjectArrayList<O extends MappedObject<O, T>, T extends MappedAccess<T>>
extends AbstractList<O>
implements RefList<O> {
    private static final int DEFAULT_CAPACITY = 1;
    private final O type;
    protected MappedAccessData<T> data;
    private long baseOffset;
    private long elementBaseOffset;
    private final T access;
    private int size;
    private final ConcurrentLinkedQueue<O> tmpObjRefs = new ConcurrentLinkedQueue();

    public MappedObjectArrayList(O type) {
        this(type, 1);
    }

    public MappedObjectArrayList(O type, int capacity) {
        this(type, ((MappedObject)type).storageFactory.createStorage(4 + capacity * ((MappedObject)type).getSizeInBytes()), 0L);
    }

    protected MappedObjectArrayList(O type, MappedAccessData<T> data, long baseOffset) {
        this.type = type;
        this.access = ((MappedObject)type).storageFactory.createAccess();
        this.referToDataAt(data, baseOffset);
        this.ensureCapacity(0);
    }

    protected void referToDataAt(MappedAccessData<T> data, long baseOffset) {
        this.data = data;
        this.baseOffset = baseOffset;
        this.elementBaseOffset = baseOffset + 4L;
        data.updateAccess(this.access, baseOffset);
        this.size = baseOffset < data.size() ? this.access.getInt(0) : 0;
    }

    public void createListAt(MappedAccessData<T> data, long baseOffset) {
        this.referToDataAt(data, baseOffset);
        this.clear();
    }

    @Override
    public void clear() {
        this.ensureCapacity(0);
        this.setSize(0);
    }

    protected void setSize(int size) {
        this.access.putInt(size, 0);
        this.size = size;
    }

    @Override
    public O createRef() {
        MappedObject obj = (MappedObject)this.tmpObjRefs.poll();
        return (O)(obj == null ? ((MappedObject)this.type).createRef() : obj);
    }

    private O createRefAt(int index) {
        Object ref = this.createRef();
        this.setRefAt(ref, index);
        return (O)ref;
    }

    private void setRefAt(O ref, int index) {
        this.data.updateAccess(((MappedObject)ref).access, this.elementBaseOffset + (long)(index * this.elementSizeInBytes()));
    }

    @Override
    public void releaseRef(O ref) {
        this.tmpObjRefs.add(ref);
    }

    private int elementSizeInBytes() {
        return ((MappedObject)this.type).getSizeInBytes();
    }

    protected void ensureCapacity(int size) {
        int required = (size + 1) * this.elementSizeInBytes();
        if (this.data.size() < this.elementBaseOffset + (long)required) {
            this.data.resize(2L * (this.elementBaseOffset + (long)required));
        }
    }

    public long getBaseOffset() {
        return this.baseOffset;
    }

    public long getSizeInBytes() {
        return 4 + this.size() * ((MappedObject)this.type).getSizeInBytes();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public O get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.createRefAt(index);
    }

    @Override
    public O get(int index, O ref) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.setRefAt(ref, index);
        return ref;
    }

    @Override
    public O set(int index, O element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        Object ref = this.createRef();
        this.set(index, element, ref);
        this.releaseRef((O)ref);
        return null;
    }

    public O set(int index, O element, O ref) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.setRefAt(ref, index);
        ((MappedObject)ref).set(element);
        return null;
    }

    @Override
    public boolean addAll(Collection<? extends O> c) {
        return this.addAll(this.size(), c);
    }

    public boolean addAll(Collection<? extends O> c, O ref) {
        return this.addAll(this.size(), c, ref);
    }

    @Override
    public boolean addAll(int index, Collection<? extends O> c) {
        Object ref = this.createRef();
        boolean modified = this.addAll(index, c, ref);
        this.releaseRef((O)ref);
        return modified;
    }

    public boolean addAll(int index, Collection<? extends O> c, O ref) {
        boolean modified = false;
        for (MappedObject e : c) {
            this.add(index++, e, ref);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean add(O obj) {
        Object ref = this.createRef();
        boolean ret = this.add(obj, ref);
        this.releaseRef((O)ref);
        return ret;
    }

    public boolean add(O obj, O ref) {
        int size = this.size();
        this.ensureCapacity(size + 1);
        this.setSize(size + 1);
        this.setRefAt(ref, size);
        ((MappedObject)ref).set(obj);
        return true;
    }

    @Override
    public void add(int index, O obj) {
        O ref = this.createRefAt(index);
        this.add(index, obj, ref);
        this.releaseRef(ref);
    }

    public void add(int index, O obj, O ref) {
        int size = this.size();
        this.ensureCapacity(size + 1);
        this.setSize(size + 1);
        this.setRefAt(ref, index);
        if (index < size) {
            O shift = this.createRefAt(index + 1);
            ((MappedObject)shift).access.copyFrom(((MappedObject)ref).access, this.elementSizeInBytes() * (size - index));
            this.releaseRef(shift);
        }
        ((MappedObject)ref).set(obj);
    }

    @Override
    public RefList.RefIterator<O> iterator() {
        return new RefList.RefIterator<O>(){
            private O ref;
            private int i;
            {
                this.ref = MappedObjectArrayList.this.createRef();
                this.i = 0;
            }

            @Override
            public boolean hasNext() {
                if (this.i < MappedObjectArrayList.this.size()) {
                    return true;
                }
                this.release();
                return false;
            }

            @Override
            public O next() {
                return MappedObjectArrayList.this.get(this.i++, this.ref);
            }

            @Override
            public void release() {
                if (this.ref != null) {
                    MappedObjectArrayList.this.releaseRef(this.ref);
                    this.ref = null;
                }
            }

            @Override
            public void reset() {
                if (this.ref == null) {
                    this.ref = MappedObjectArrayList.this.createRef();
                }
                this.i = 0;
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        if (o instanceof RefList) {
            Iterator e1 = this.iterator();
            Iterator e2 = ((RefList)o).iterator();
            while (e1.hasNext() && e2.hasNext()) {
                Object o2;
                MappedObject o1 = (MappedObject)e1.next();
                if (o1.equals(o2 = e2.next())) continue;
                e1.release();
                e2.release();
                return false;
            }
            return !e1.hasNext() && !e2.hasNext();
        }
        ListIterator e1 = this.listIterator();
        ListIterator e2 = ((List)o).listIterator();
        while (e1.hasNext() && e2.hasNext()) {
            MappedObject o1 = (MappedObject)e1.next();
            Object o2 = e2.next();
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return !e1.hasNext() && !e2.hasNext();
    }

    @Override
    public void sort(Comparator<? super O> comparator) {
        if (this.size() < 2) {
            return;
        }
        Object r1 = this.createRef();
        Object r2 = this.createRef();
        Object r3 = this.createRef();
        this.quicksort(0, this.size() - 1, comparator, r1, r2, r3);
        this.releaseRef((O)r3);
        this.releaseRef((O)r2);
        this.releaseRef((O)r1);
    }

    public void limitSize(int sizeLimit) {
        if (this.size() > sizeLimit) {
            this.setSize(sizeLimit);
        }
    }

    private void quicksort(int low, int high, Comparator<? super O> comparator, O tmpRef1, O tmpRef2, O tmpRef3) {
        int pivotpos = (low + high) / 2;
        O pivot = this.get(pivotpos, tmpRef1);
        int i = low;
        int j = high;
        while (true) {
            if (comparator.compare(this.get(i, tmpRef2), pivot) < 0) {
                ++i;
                continue;
            }
            while (comparator.compare(pivot, this.get(j, tmpRef3)) < 0) {
                --j;
            }
            if (i <= j) {
                ((MappedObject)this.get((int)i, tmpRef2)).access.swapWith(((MappedObject)this.get((int)j, tmpRef3)).access, this.elementSizeInBytes());
                if (pivotpos == i) {
                    pivotpos = j;
                    this.get(pivotpos, pivot);
                } else if (pivotpos == j) {
                    pivotpos = i;
                    this.get(pivotpos, pivot);
                }
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (low < j) {
            this.quicksort(low, j, comparator, tmpRef1, tmpRef2, tmpRef3);
        }
        if (i < high) {
            this.quicksort(i, high, comparator, tmpRef1, tmpRef2, tmpRef3);
        }
    }

    @Override
    public Stream<O> stream() {
        throw new UnsupportedOperationException("Streams are not compatible with " + this.getClass().getName() + " because its iterator reuses the same reference.");
    }

    @Override
    public Stream<O> parallelStream() {
        throw new UnsupportedOperationException("Streams are not compatible with " + this.getClass().getName() + " because its iterator reuses the same reference.");
    }
}

