/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.event;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import org.jhotdraw.draw.DrawingEditor;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.event.FigureSelectionEvent;
import org.jhotdraw.draw.event.FigureSelectionListener;
import org.jhotdraw.draw.tool.SelectionTool;

public class SelectionComponentDisplayer
implements PropertyChangeListener,
FigureSelectionListener {
    @Nullable
    protected DrawingView view;
    @Nullable
    protected DrawingEditor editor;
    protected WeakReference<JComponent> weakRef;
    protected int minSelectionCount = 1;
    protected boolean isVisibleIfCreationTool = true;

    public SelectionComponentDisplayer(DrawingEditor editor, JComponent component) {
        this.editor = editor;
        this.weakRef = new WeakReference<JComponent>(component);
        if (editor.getActiveView() != null) {
            this.view = editor.getActiveView();
            this.view.addPropertyChangeListener(this);
            this.view.addFigureSelectionListener(this);
        }
        editor.addPropertyChangeListener(this);
        this.updateVisibility();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name == "activeView") {
            if (this.view != null) {
                this.view.removePropertyChangeListener(this);
                this.view.removeFigureSelectionListener(this);
            }
            this.view = (DrawingView)evt.getNewValue();
            if (this.view != null) {
                this.view.addPropertyChangeListener(this);
                this.view.addFigureSelectionListener(this);
            }
            this.updateVisibility();
        } else if (name == "tool") {
            this.updateVisibility();
        }
    }

    @Override
    public void selectionChanged(FigureSelectionEvent evt) {
        this.updateVisibility();
    }

    public void updateVisibility() {
        boolean newValue = this.editor != null && this.editor.getActiveView() != null && (this.isVisibleIfCreationTool && this.editor.getTool() != null && !(this.editor.getTool() instanceof SelectionTool) || this.editor.getActiveView().getSelectionCount() >= this.minSelectionCount);
        JComponent component = (JComponent)this.weakRef.get();
        if (component == null) {
            this.dispose();
            return;
        }
        if (newValue != component.isVisible()) {
            component.setVisible(newValue);
            if (newValue) {
                component.setPreferredSize(null);
            } else {
                component.setPreferredSize(new Dimension(0, 0));
            }
            component.revalidate();
        }
    }

    @Nullable
    protected JComponent getComponent() {
        return (JComponent)this.weakRef.get();
    }

    public void dispose() {
        if (this.editor != null) {
            this.editor.removePropertyChangeListener(this);
            this.editor = null;
        }
        if (this.view != null) {
            this.view.removePropertyChangeListener(this);
            this.view.removeFigureSelectionListener(this);
            this.view = null;
        }
    }

    public void setMinSelectionCount(int newValue) {
        this.minSelectionCount = newValue;
        this.updateVisibility();
    }

    public void setVisibleIfCreationTool(boolean newValue) {
        this.isVisibleIfCreationTool = newValue;
    }
}

