/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.handle;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.handle.AbstractHandle;
import org.jhotdraw.draw.handle.HandleAttributeKeys;
import org.jhotdraw.util.ResourceBundleUtil;

public class TextOverflowHandle
extends AbstractHandle {
    public TextOverflowHandle(TextHolderFigure owner) {
        super(owner);
    }

    @Override
    public TextHolderFigure getOwner() {
        return (TextHolderFigure)super.getOwner();
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getOwner().isTextOverflow()) {
            this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            g.setColor(this.getEditor().getHandleAttribute(HandleAttributeKeys.OVERFLOW_HANDLE_STROKE_COLOR));
            Rectangle r = this.basicGetBounds();
            g.drawLine(r.x + 1, r.y + 1, r.x + r.width - 2, r.y + r.height - 2);
            g.drawLine(r.x + r.width - 2, r.y + 1, r.x + 1, r.y + r.height - 2);
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle2D.Double b = this.getOwner().getBounds();
        Point2D.Double p = new Point2D.Double(b.x + b.width, b.y + b.height);
        TextHolderFigure o = this.getOwner();
        if (o.get(AttributeKeys.TRANSFORM) != null) {
            o.get(AttributeKeys.TRANSFORM).transform(p, p);
        }
        Rectangle r = new Rectangle(this.view.drawingToView(p));
        int h = this.getHandlesize();
        r.x -= h;
        r.y -= h;
        r.width = r.height = h;
        return r;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public String getToolTipText(Point p) {
        return this.getOwner().isTextOverflow() ? ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.textOverflow.toolTipText") : null;
    }
}

