/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.RootPaneContainer;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import javax.swing.plaf.basic.BasicPanelUI;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;

public class PalettePanelUI
extends BasicPanelUI {
    private static PanelUI panelUI;

    public static ComponentUI createUI(JComponent c) {
        if (panelUI == null) {
            panelUI = new PalettePanelUI();
        }
        return panelUI;
    }

    @Override
    protected void installDefaults(JPanel p) {
        PaletteLookAndFeel.installColorsAndFont(p, "Panel.background", "Panel.foreground", "Panel.font");
        PaletteLookAndFeel.installBorder(p, "Panel.border");
        PaletteLookAndFeel.installProperty(p, "opaque", PaletteLookAndFeel.getInstance().get("Panel.opaque"));
    }

    @Override
    protected void uninstallDefaults(JPanel p) {
        super.uninstallDefaults(p);
    }

    public static boolean isInTabbedPane(Component comp) {
        if (comp == null) {
            return false;
        }
        for (Container parent = comp.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JTabbedPane) {
                return true;
            }
            if (parent instanceof JRootPane) {
                return false;
            }
            if (parent instanceof RootPaneContainer) {
                return false;
            }
            if (!(parent instanceof Window)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void paint(Graphics gr, JComponent c) {
        Graphics2D g = (Graphics2D)gr;
        if (c.isOpaque()) {
            g.setColor(c.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }
}

