/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.RecursiveExponentialFilter;
import edu.mines.jtk.dsp.SincInterpolator;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.Parallel;

public class DynamicWarping {
    private int _nl;
    private int _lmin;
    private int _lmax;
    private ErrorExtrapolation _extrap;
    private float _epow = 2.0f;
    private int _esmooth = 0;
    private double _usmooth1 = 0.0;
    private double _usmooth2 = 0.0;
    private double _usmooth3 = 0.0;
    private int _bstrain1 = 1;
    private int _bstrain2 = 1;
    private int _bstrain3 = 1;
    private RecursiveExponentialFilter _ref1;
    private RecursiveExponentialFilter _ref2;
    private RecursiveExponentialFilter _ref3;
    private SincInterpolator _si;
    private int _owl2 = 50;
    private int _owl3 = 50;
    private double _owf2 = 0.5;
    private double _owf3 = 0.5;

    public DynamicWarping(int shiftMin, int shiftMax) {
        Check.argument(shiftMax - shiftMin > 1, "shiftMax-shiftMin>1");
        this._lmin = shiftMin;
        this._lmax = shiftMax;
        this._nl = 1 + this._lmax - this._lmin;
        this._si = new SincInterpolator();
        this._extrap = ErrorExtrapolation.NEAREST;
    }

    public void setStrainMax(double strainMax) {
        Check.argument(strainMax <= 1.0, "strainMax<=1.0");
        Check.argument(strainMax > 0.0, "strainMax>0.0");
        this.setStrainMax(strainMax, strainMax);
    }

    public void setStrainMax(double strainMax1, double strainMax2) {
        Check.argument(strainMax1 <= 1.0, "strainMax1<=1.0");
        Check.argument(strainMax2 <= 1.0, "strainMax2<=1.0");
        Check.argument(strainMax1 > 0.0, "strainMax1>0.0");
        Check.argument(strainMax2 > 0.0, "strainMax2>0.0");
        this.setStrainMax(strainMax1, strainMax2, strainMax2);
    }

    public void setStrainMax(double strainMax1, double strainMax2, double strainMax3) {
        Check.argument(strainMax1 <= 1.0, "strainMax1<=1.0");
        Check.argument(strainMax2 <= 1.0, "strainMax2<=1.0");
        Check.argument(strainMax3 <= 1.0, "strainMax3<=1.0");
        Check.argument(strainMax1 > 0.0, "strainMax1>0.0");
        Check.argument(strainMax2 > 0.0, "strainMax2>0.0");
        Check.argument(strainMax3 > 0.0, "strainMax3>0.0");
        this._bstrain1 = (int)ArrayMath.ceil(1.0 / strainMax1);
        this._bstrain2 = (int)ArrayMath.ceil(1.0 / strainMax2);
        this._bstrain3 = (int)ArrayMath.ceil(1.0 / strainMax3);
        this.updateSmoothingFilters();
    }

    public void setErrorExtrapolation(ErrorExtrapolation ee) {
        this._extrap = ee;
    }

    public void setErrorExponent(double e) {
        this._epow = (float)e;
    }

    public void setErrorSmoothing(int esmooth) {
        this._esmooth = esmooth;
    }

    public void setShiftSmoothing(double usmooth) {
        this.setShiftSmoothing(usmooth, usmooth);
    }

    public void setShiftSmoothing(double usmooth1, double usmooth2) {
        this.setShiftSmoothing(usmooth1, usmooth2, usmooth2);
    }

    public void setShiftSmoothing(double usmooth1, double usmooth2, double usmooth3) {
        this._usmooth1 = usmooth1;
        this._usmooth2 = usmooth2;
        this._usmooth3 = usmooth3;
        this.updateSmoothingFilters();
    }

    public void setWindowSizeAndOverlap(int l2, int l3, double f2, double f3) {
        this._owl2 = l2;
        this._owl3 = l3;
        this._owf2 = f2;
        this._owf3 = f3;
    }

    public float[] findShifts(float[] f, float[] g) {
        float[] u = DynamicWarping.like(f);
        this.findShifts(f, g, u);
        return u;
    }

    public float[][] findShifts(float[][] f, float[][] g) {
        float[][] u = DynamicWarping.like(f);
        this.findShifts(f, g, u);
        return u;
    }

    public float[][][] findShifts(float[][][] f, float[][][] g) {
        float[][][] u = DynamicWarping.like(f);
        this.findShifts(f, g, u);
        return u;
    }

    public float[] findShifts1(float[][] f, float[][] g) {
        float[] u = DynamicWarping.like(f[0]);
        this.findShifts1(f, g, u);
        return u;
    }

    public float[] findShifts1(float[][][] f, float[][][] g) {
        float[] u = DynamicWarping.like(f[0][0]);
        this.findShifts1(f, g, u);
        return u;
    }

    public void findShifts(float[] f, float[] g, float[] u) {
        float[][] e = this.computeErrors(f, g);
        for (int is = 0; is < this._esmooth; ++is) {
            this.smoothErrors(e, e);
        }
        float[][] d = this.accumulateForward(e);
        this.backtrackReverse(d, e, u);
        this.smoothShifts(u, u);
    }

    public void findShifts(float[][] f, float[][] g, float[][] u) {
        final float[][][] e = this.computeErrors(f, g);
        final int nl = e[0][0].length;
        final int n1 = e[0].length;
        int n2 = e.length;
        final float[][] uf = u;
        for (int is = 0; is < this._esmooth; ++is) {
            this.smoothErrors(e, e);
        }
        final Parallel.Unsafe du = new Parallel.Unsafe();
        Parallel.loop(n2, new Parallel.LoopInt(){

            @Override
            public void compute(int i2) {
                float[][] d = (float[][])du.get();
                if (d == null) {
                    d = new float[n1][nl];
                    du.set(d);
                }
                DynamicWarping.this.accumulateForward(e[i2], d);
                DynamicWarping.this.backtrackReverse(d, e[i2], uf[i2]);
            }
        });
        this.smoothShifts(u, u);
    }

    public void findShifts(float[][][] f, float[][][] g, float[][][] u) {
        int n1 = f[0][0].length;
        int n2 = f[0].length;
        int n3 = f.length;
        OverlappingWindows2 ow = new OverlappingWindows2(n2, n3, this._owl2, this._owl3, this._owf2, this._owf3);
        int m2 = ow.getM1();
        int m3 = ow.getM2();
        int l2 = ow.getL1();
        int l3 = ow.getL2();
        float[][][] fw = new float[l3][l2][];
        float[][][] gw = new float[l3][l2][];
        float[][][] uw = new float[l3][l2][n1];
        float[][][][] ew = new float[l3][l2][n1][this._nl];
        for (int k3 = 0; k3 < m3; ++k3) {
            int i3 = ow.getI2(k3);
            for (int k2 = 0; k2 < m2; ++k2) {
                int j2;
                int j3;
                int i2 = ow.getI1(k2);
                for (j3 = 0; j3 < l3; ++j3) {
                    for (j2 = 0; j2 < l2; ++j2) {
                        fw[j3][j2] = f[i3 + j3][i2 + j2];
                        gw[j3][j2] = g[i3 + j3][i2 + j2];
                    }
                }
                this.computeErrors(fw, gw, ew);
                DynamicWarping.normalizeErrors(ew);
                for (int is = 0; is < this._esmooth; ++is) {
                    this.smoothErrors(ew);
                }
                this.computeShifts(ew, uw);
                for (j3 = 0; j3 < l3; ++j3) {
                    for (j2 = 0; j2 < l2; ++j2) {
                        float wij = ow.getWeight(i2, i3, j2, j3);
                        float[] u32 = u[i3 + j3][i2 + j2];
                        for (int i1 = 0; i1 < n1; ++i1) {
                            int n = i1;
                            u32[n] = u32[n] + wij * uw[j3][j2][i1];
                        }
                    }
                }
            }
        }
        this.smoothShifts(u);
    }

    public void findShifts1(float[][] f, float[][] g, float[] u) {
        float[][] e = this.computeErrors1(f, g);
        for (int is = 0; is < this._esmooth; ++is) {
            this.smoothErrors(e, e);
        }
        float[][] d = this.accumulateForward(e);
        this.backtrackReverse(d, e, u);
        this.smoothShifts(u, u);
    }

    public void findShifts1(float[][][] f, float[][][] g, float[] u) {
        float[][] e = this.computeErrors1(f, g);
        for (int is = 0; is < this._esmooth; ++is) {
            this.smoothErrors(e, e);
        }
        float[][] d = this.accumulateForward(e);
        this.backtrackReverse(d, e, u);
        this.smoothShifts(u, u);
    }

    public float[] applyShifts(float[] u, float[] g) {
        float[] h = DynamicWarping.like(g);
        this.applyShifts(u, g, h);
        return h;
    }

    public float[][] applyShifts(float[][] u, float[][] g) {
        float[][] h = DynamicWarping.like(g);
        this.applyShifts(u, g, h);
        return h;
    }

    public float[][][] applyShifts(float[][][] u, float[][][] g) {
        float[][][] h = DynamicWarping.like(g);
        this.applyShifts(u, g, h);
        return h;
    }

    public void applyShifts(float[] u, float[] g, float[] h) {
        int n1 = u.length;
        for (int i1 = 0; i1 < n1; ++i1) {
            h[i1] = this._si.interpolate(n1, 1.0, 0.0, g, (double)((float)i1 + u[i1]));
        }
    }

    public void applyShifts(float[][] u, float[][] g, float[][] h) {
        final int n1 = u[0].length;
        int n2 = u.length;
        final float[][] uf = u;
        final float[][] gf = g;
        final float[][] hf = h;
        Parallel.loop(n2, new Parallel.LoopInt(){

            @Override
            public void compute(int i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    hf[i2][i1] = DynamicWarping.this._si.interpolate(n1, 1.0, 0.0, gf[i2], (double)((float)i1 + uf[i2][i1]));
                }
            }
        });
    }

    public void applyShifts(float[][][] u, float[][][] g, float[][][] h) {
        int n3 = u.length;
        final float[][][] uf = u;
        final float[][][] gf = g;
        final float[][][] hf = h;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                DynamicWarping.this.applyShifts(uf[i3], gf[i3], hf[i3]);
            }
        });
    }

    public float[][] computeErrors(float[] f, float[] g) {
        int n1 = f.length;
        float[][] e = new float[n1][this._nl];
        this.computeErrors(f, g, e);
        DynamicWarping.normalizeErrors(e);
        return e;
    }

    public float[][][] computeErrors(float[][] f, float[][] g) {
        int n1 = f[0].length;
        int n2 = f.length;
        final float[][] ff = f;
        final float[][] gf = g;
        final float[][][] ef = new float[n2][n1][this._nl];
        Parallel.loop(n2, new Parallel.LoopInt(){

            @Override
            public void compute(int i2) {
                DynamicWarping.this.computeErrors(ff[i2], gf[i2], ef[i2]);
            }
        });
        DynamicWarping.normalizeErrors(ef);
        return ef;
    }

    public float[][] computeErrors1(float[][] f, float[][] g) {
        final float[][] ff = f;
        final float[][] gf = g;
        final int nl = 1 + this._lmax - this._lmin;
        final int n1 = f[0].length;
        int n2 = f.length;
        float[][] e = Parallel.reduce(n2, new Parallel.ReduceInt<float[][]>(){

            @Override
            public float[][] compute(int i2) {
                float[][] e = new float[n1][nl];
                DynamicWarping.this.computeErrors(ff[i2], gf[i2], e);
                return e;
            }

            @Override
            public float[][] combine(float[][] ea, float[][] eb) {
                return ArrayMath.add(ea, eb);
            }
        });
        DynamicWarping.normalizeErrors(e);
        return e;
    }

    public float[][] computeErrors1(float[][][] f, float[][][] g) {
        final float[][][] ff = f;
        final float[][][] gf = g;
        final int nl = 1 + this._lmax - this._lmin;
        final int n1 = f[0][0].length;
        final int n2 = f[0].length;
        int n3 = f.length;
        float[][] e = Parallel.reduce(n2 * n3, new Parallel.ReduceInt<float[][]>(){

            @Override
            public float[][] compute(int i23) {
                int i2 = i23 % n2;
                int i3 = i23 / n2;
                float[][] e = new float[n1][nl];
                DynamicWarping.this.computeErrors(ff[i3][i2], gf[i3][i2], e);
                return e;
            }

            @Override
            public float[][] combine(float[][] ea, float[][] eb) {
                return ArrayMath.add(ea, eb);
            }
        });
        DynamicWarping.normalizeErrors(e);
        return e;
    }

    public float[][] smoothErrors(float[][] e) {
        float[][] es = DynamicWarping.like(e);
        this.smoothErrors(e, es);
        return es;
    }

    public float[][][] smoothErrors(float[][][] e) {
        float[][][] es = DynamicWarping.like(e);
        this.smoothErrors(e, es);
        return es;
    }

    public void smoothErrors(float[][] e, float[][] es) {
        DynamicWarping.smoothErrors1(this._bstrain1, e, es);
        DynamicWarping.normalizeErrors(es);
    }

    public void smoothErrors(float[][][] e, float[][][] es) {
        DynamicWarping.smoothErrors1(this._bstrain1, e, es);
        DynamicWarping.normalizeErrors(es);
        DynamicWarping.smoothErrors2(this._bstrain2, es, es);
        DynamicWarping.normalizeErrors(es);
    }

    public void smoothErrors1(float[][][] e, float[][][] es) {
        DynamicWarping.smoothErrors1(this._bstrain1, e, es);
        DynamicWarping.normalizeErrors(es);
    }

    public float[] smoothShifts(float[] u) {
        float[] us = DynamicWarping.like(u);
        this.smoothShifts(u, us);
        return us;
    }

    public float[][] smoothShifts(float[][] u) {
        float[][] us = DynamicWarping.like(u);
        this.smoothShifts(u, us);
        return us;
    }

    public void smoothShifts(float[] u, float[] us) {
        if (this._ref1 != null) {
            this._ref1.apply(u, us);
        } else if (u != us) {
            ArrayMath.copy(u, us);
        }
    }

    public void smoothShifts(float[][] u, float[][] us) {
        if (this._ref1 != null) {
            this._ref1.apply1(u, us);
        } else {
            ArrayMath.copy(u, us);
        }
        if (this._ref2 != null) {
            this._ref2.apply2(us, us);
        }
    }

    public float[][] accumulateForward(float[][] e) {
        float[][] d = DynamicWarping.like(e);
        this.accumulateForward(e, d);
        return d;
    }

    public float[][] accumulateReverse(float[][] e) {
        float[][] d = DynamicWarping.like(e);
        this.accumulateReverse(e, d);
        return d;
    }

    public float[][][] accumulateForward1(float[][][] e) {
        float[][][] d = DynamicWarping.like(e);
        this.accumulateForward1(e, d);
        return d;
    }

    public float[][][] accumulateReverse1(float[][][] e) {
        float[][][] d = DynamicWarping.like(e);
        this.accumulateReverse1(e, d);
        return d;
    }

    public float[][][] accumulateForward2(float[][][] e) {
        float[][][] d = DynamicWarping.like(e);
        this.accumulateForward2(e, d);
        return d;
    }

    public float[][][] accumulateReverse2(float[][][] e) {
        float[][][] d = DynamicWarping.like(e);
        this.accumulateReverse2(e, d);
        return d;
    }

    public void accumulateForward(float[][] e, float[][] d) {
        DynamicWarping.accumulate(1, this._bstrain1, e, d);
    }

    public void accumulateReverse(float[][] e, float[][] d) {
        DynamicWarping.accumulate(-1, this._bstrain1, e, d);
    }

    public void accumulateForward1(float[][][] e, float[][][] d) {
        int n2 = e.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.accumulateForward(e[i2], d[i2]);
        }
    }

    public void accumulateReverse1(float[][][] e, float[][][] d) {
        int n2 = e.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.accumulateReverse(e[i2], d[i2]);
        }
    }

    public void accumulateForward2(float[][][] e, float[][][] d) {
        int n1 = e[0].length;
        int n2 = e.length;
        float[][] ei1 = new float[n2][];
        float[][] di1 = new float[n2][];
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ei1[i2] = e[i2][i1];
                di1[i2] = d[i2][i1];
            }
            DynamicWarping.accumulate(1, this._bstrain2, ei1, di1);
        }
    }

    public void accumulateReverse2(float[][][] e, float[][][] d) {
        int n1 = e[0].length;
        int n2 = e.length;
        float[][] ei1 = new float[n2][];
        float[][] di1 = new float[n2][];
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                ei1[i2] = e[i2][i1];
                di1[i2] = d[i2][i1];
            }
            DynamicWarping.accumulate(-1, this._bstrain2, ei1, di1);
        }
    }

    public float[] backtrackReverse(float[][] d, float[][] e) {
        float[] u = new float[d.length];
        this.backtrackReverse(d, e, u);
        return u;
    }

    public float[][] backtrackReverse1(float[][][] d, float[][][] e) {
        float[][] u = new float[d.length][d[0].length];
        this.backtrackReverse1(d, e, u);
        return u;
    }

    public float[][] backtrackReverse2(float[][][] d, float[][][] e) {
        float[][] u = new float[d.length][d[0].length];
        this.backtrackReverse2(d, e, u);
        return u;
    }

    public void backtrackReverse(float[][] d, float[][] e, float[] u) {
        DynamicWarping.backtrack(-1, this._bstrain1, this._lmin, d, e, u);
    }

    public void backtrackReverse1(float[][][] d, float[][][] e, float[][] u) {
        int n2 = d.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.backtrackReverse(d[i2], e[i2], u[i2]);
        }
    }

    public void backtrackReverse2(float[][][] d, float[][][] e, float[][] u) {
        int n1 = d[0].length;
        int n2 = d.length;
        float[][] di1 = new float[n2][];
        float[][] ei1 = new float[n2][];
        float[] ui1 = new float[n2];
        for (int i1 = 0; i1 < n1; ++i1) {
            int i2;
            for (i2 = 0; i2 < n2; ++i2) {
                di1[i2] = d[i2][i1];
                ei1[i2] = e[i2][i1];
            }
            DynamicWarping.backtrack(-1, this._bstrain2, this._lmin, di1, ei1, ui1);
            for (i2 = 0; i2 < n2; ++i2) {
                u[i2][i1] = ui1[i2];
            }
        }
    }

    public static void normalizeErrors(float[][] e) {
        int nl = e[0].length;
        int n1 = e.length;
        float emin = e[0][0];
        float emax = e[0][0];
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int il = 0; il < nl; ++il) {
                float ei = e[i1][il];
                if (ei < emin) {
                    emin = ei;
                }
                if (!(ei > emax)) continue;
                emax = ei;
            }
        }
        DynamicWarping.shiftAndScale(emin, emax, e);
    }

    public static void normalizeErrors(float[][][] e) {
        final float[][][] ef = e;
        int n2 = e.length;
        MinMax mm = Parallel.reduce(n2, new Parallel.ReduceInt<MinMax>(){

            @Override
            public MinMax compute(int i2) {
                int nl = ef[i2][0].length;
                int n1 = ef[i2].length;
                float emin = Float.MAX_VALUE;
                float emax = -3.4028235E38f;
                for (int i1 = 0; i1 < n1; ++i1) {
                    for (int il = 0; il < nl; ++il) {
                        float ei = ef[i2][i1][il];
                        if (ei < emin) {
                            emin = ei;
                        }
                        if (!(ei > emax)) continue;
                        emax = ei;
                    }
                }
                return new MinMax(emin, emax);
            }

            @Override
            public MinMax combine(MinMax mm1, MinMax mm2) {
                return new MinMax(ArrayMath.min(mm1.emin, mm2.emin), ArrayMath.max(mm1.emax, mm2.emax));
            }
        });
        DynamicWarping.shiftAndScale(mm.emin, mm.emax, e);
    }

    public float sumErrors(float[][] e, float[] u) {
        int n1 = e.length;
        int nl = e[0].length;
        float ul = 0.5f - (float)this._lmin;
        double sum = 0.0;
        for (int i1 = 0; i1 < n1; ++i1) {
            int il = (int)(u[i1] + ul);
            il = ArrayMath.max(0, ArrayMath.min(nl - 1, il));
            sum += (double)e[i1][il];
        }
        return (float)sum;
    }

    public float sumErrors(float[][][] e, float[][] u) {
        int n2 = e.length;
        double sum = 0.0;
        for (int i2 = 0; i2 < n2; ++i2) {
            sum += (double)this.sumErrors(e[i2], u[i2]);
        }
        return (float)sum;
    }

    public static float[][] transposeLag(float[][] e) {
        int nl = e[0].length;
        int n1 = e.length;
        float[][] t = new float[nl][n1];
        for (int il = 0; il < nl; ++il) {
            for (int i1 = 0; i1 < n1; ++i1) {
                t[il][i1] = e[i1][il];
            }
        }
        return t;
    }

    public static float[][][] transposeLag(float[][][] e) {
        int nl = e[0][0].length;
        int n1 = e[0].length;
        int n2 = e.length;
        float[][][] t = new float[nl][n2][n1];
        for (int il = 0; il < nl; ++il) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    t[il][i2][i1] = e[i2][i1][il];
                }
            }
        }
        return t;
    }

    private float error(float f, float g) {
        return ArrayMath.pow(ArrayMath.abs(f - g), this._epow);
    }

    private void updateSmoothingFilters() {
        this._ref1 = this._usmooth1 <= 0.0 ? null : new RecursiveExponentialFilter(this._usmooth1 * (double)this._bstrain1);
        this._ref2 = this._usmooth2 <= 0.0 ? null : new RecursiveExponentialFilter(this._usmooth2 * (double)this._bstrain2);
        this._ref3 = this._usmooth3 <= 0.0 ? null : new RecursiveExponentialFilter(this._usmooth3 * (double)this._bstrain3);
    }

    private void computeErrors(float[] f, float[] g, float[][] e) {
        int il;
        int ilhi;
        int illo;
        int i1;
        int n1 = f.length;
        int nl = this._nl;
        int n1m = n1 - 1;
        boolean average = this._extrap == ErrorExtrapolation.AVERAGE;
        boolean nearest = this._extrap == ErrorExtrapolation.NEAREST;
        boolean reflect = this._extrap == ErrorExtrapolation.REFLECT;
        float[] eavg = average ? new float[nl] : null;
        int[] navg = average ? new int[nl] : null;
        float emax = 0.0f;
        for (i1 = 0; i1 < n1; ++i1) {
            illo = ArrayMath.max(0, -this._lmin - i1);
            ilhi = ArrayMath.min(nl, n1 - this._lmin - i1);
            il = illo;
            int j1 = i1 + il + this._lmin;
            while (il < ilhi) {
                float ei;
                e[i1][il] = ei = this.error(f[i1], g[j1]);
                if (average) {
                    int n = il;
                    eavg[n] = eavg[n] + ei;
                    int n2 = il;
                    navg[n2] = navg[n2] + 1;
                }
                if (ei > emax) {
                    emax = ei;
                }
                ++il;
                ++j1;
            }
        }
        if (average) {
            for (int il2 = 0; il2 < nl; ++il2) {
                if (navg[il2] <= 0) continue;
                int n = il2;
                eavg[n] = eavg[n] / (float)navg[il2];
            }
        }
        for (i1 = 0; i1 < n1; ++i1) {
            illo = ArrayMath.max(0, -this._lmin - i1);
            ilhi = ArrayMath.min(nl, n1 - this._lmin - i1);
            for (il = 0; il < nl; ++il) {
                if (il >= illo && il < ilhi) continue;
                if (average) {
                    if (navg[il] > 0) {
                        e[i1][il] = eavg[il];
                        continue;
                    }
                    e[i1][il] = emax;
                    continue;
                }
                if (nearest || reflect) {
                    int k1;
                    int n = k1 = il < illo ? -this._lmin - il : n1m - this._lmin - il;
                    if (reflect) {
                        k1 += k1 - i1;
                    }
                    if (0 <= k1 && k1 < n1) {
                        e[i1][il] = e[k1][il];
                        continue;
                    }
                    e[i1][il] = emax;
                    continue;
                }
                e[i1][il] = emax;
            }
        }
    }

    private static void accumulate(int dir, int b, float[][] e, float[][] d) {
        int nl = e[0].length;
        int ni = e.length;
        int nlm1 = nl - 1;
        int nim1 = ni - 1;
        int ib = dir > 0 ? 0 : nim1;
        int ie = dir > 0 ? ni : -1;
        int is = dir > 0 ? 1 : -1;
        for (int il = 0; il < nl; ++il) {
            d[ib][il] = 0.0f;
        }
        for (int ii = ib; ii != ie; ii += is) {
            int ji = ArrayMath.max(0, ArrayMath.min(nim1, ii - is));
            int jb = ArrayMath.max(0, ArrayMath.min(nim1, ii - is * b));
            for (int il = 0; il < nl; ++il) {
                int ilp1;
                int ilm1 = il - 1;
                if (ilm1 == -1) {
                    ilm1 = 0;
                }
                if ((ilp1 = il + 1) == nl) {
                    ilp1 = nlm1;
                }
                float dm = d[jb][ilm1];
                float di = d[ji][il];
                float dp = d[jb][ilp1];
                for (int kb = ji; kb != jb; kb -= is) {
                    dm += e[kb][ilm1];
                    dp += e[kb][ilp1];
                }
                d[ii][il] = DynamicWarping.min3(dm, di, dp) + e[ii][il];
            }
        }
    }

    private static void backtrack(int dir, int b, int lmin, float[][] d, float[][] e, float[] u) {
        float ob = 1.0f / (float)b;
        int nl = d[0].length;
        int ni = d.length;
        int nlm1 = nl - 1;
        int nim1 = ni - 1;
        int ib = dir > 0 ? 0 : nim1;
        int ie = dir > 0 ? nim1 : 0;
        int is = dir > 0 ? 1 : -1;
        int ii = ib;
        int il = ArrayMath.max(0, ArrayMath.min(nlm1, -lmin));
        float dl = d[ii][il];
        for (int jl = 1; jl < nl; ++jl) {
            if (!(d[ii][jl] < dl)) continue;
            dl = d[ii][jl];
            il = jl;
        }
        u[ii] = il + lmin;
        while (ii != ie) {
            int ilp1;
            int ji = ArrayMath.max(0, ArrayMath.min(nim1, ii + is));
            int jb = ArrayMath.max(0, ArrayMath.min(nim1, ii + is * b));
            int ilm1 = il - 1;
            if (ilm1 == -1) {
                ilm1 = 0;
            }
            if ((ilp1 = il + 1) == nl) {
                ilp1 = nlm1;
            }
            float dm = d[jb][ilm1];
            float di = d[ji][il];
            float dp = d[jb][ilp1];
            for (int kb = ji; kb != jb; kb += is) {
                dm += e[kb][ilm1];
                dp += e[kb][ilp1];
            }
            dl = DynamicWarping.min3(dm, di, dp);
            if (dl != di) {
                il = dl == dm ? ilm1 : ilp1;
            }
            u[ii += is] = il + lmin;
            if (il != ilm1 && il != ilp1) continue;
            float du = (u[ii] - u[ii - is]) * ob;
            u[ii] = u[ii - is] + du;
            for (int kb = ji; kb != jb; kb += is) {
                u[ii += is] = u[ii - is] + du;
            }
        }
    }

    private static void shiftAndScale(float emin, float emax, float[][] e) {
        int nl = e[0].length;
        int n1 = e.length;
        float eshift = emin;
        float escale = emax > emin ? 1.0f / (emax - emin) : 1.0f;
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int il = 0; il < nl; ++il) {
                e[i1][il] = (e[i1][il] - eshift) * escale;
            }
        }
    }

    private static void shiftAndScale(float emin, float emax, float[][][] e) {
        int n2 = e.length;
        final float eshift = emin;
        final float escale = emax > emin ? 1.0f / (emax - emin) : 1.0f;
        final float[][][] ef = e;
        Parallel.loop(n2, new Parallel.LoopInt(){

            @Override
            public void compute(int i2) {
                int nl = ef[i2][0].length;
                int n1 = ef[i2].length;
                for (int i1 = 0; i1 < n1; ++i1) {
                    for (int il = 0; il < nl; ++il) {
                        ef[i2][i1][il] = (ef[i2][i1][il] - eshift) * escale;
                    }
                }
            }
        });
    }

    private static void smoothErrors1(int b, float[][] e, float[][] es) {
        int nl = e[0].length;
        int n1 = e.length;
        float[][] ef = new float[n1][nl];
        float[][] er = new float[n1][nl];
        DynamicWarping.accumulate(1, b, e, ef);
        DynamicWarping.accumulate(-1, b, e, er);
        for (int i1 = 0; i1 < n1; ++i1) {
            for (int il = 0; il < nl; ++il) {
                es[i1][il] = ef[i1][il] + er[i1][il] - e[i1][il];
            }
        }
    }

    private static void smoothErrors1(int b, float[][][] e, float[][][] es) {
        int n2 = e.length;
        final int bf = b;
        final float[][][] ef = e;
        final float[][][] esf = es;
        Parallel.loop(n2, new Parallel.LoopInt(){

            @Override
            public void compute(int i2) {
                DynamicWarping.smoothErrors1(bf, ef[i2], esf[i2]);
            }
        });
    }

    private static void smoothErrors2(int b, float[][][] e, float[][][] es) {
        final int nl = e[0][0].length;
        int n1 = e[0].length;
        final int n2 = e.length;
        final int bf = b;
        final float[][][] ef = e;
        final float[][][] esf = es;
        final Parallel.Unsafe eeu = new Parallel.Unsafe();
        Parallel.loop(n1, new Parallel.LoopInt(){

            @Override
            public void compute(int i1) {
                int il;
                int i2;
                float[][][] ee = (float[][][])eeu.get();
                if (ee == null) {
                    ee = new float[4][n2][nl];
                    eeu.set(ee);
                }
                float[][] e1 = ee[0];
                float[][] es1 = ee[1];
                float[][] ef1 = ee[2];
                float[][] er1 = ee[3];
                for (i2 = 0; i2 < n2; ++i2) {
                    e1[i2] = ef[i2][i1];
                    es1[i2] = esf[i2][i1];
                    for (il = 0; il < nl; ++il) {
                        ef1[i2][il] = 0.0f;
                        er1[i2][il] = 0.0f;
                    }
                }
                DynamicWarping.accumulate(1, bf, e1, ef1);
                DynamicWarping.accumulate(-1, bf, e1, er1);
                for (i2 = 0; i2 < n2; ++i2) {
                    for (il = 0; il < nl; ++il) {
                        es1[i2][il] = ef1[i2][il] + er1[i2][il] - e1[i2][il];
                    }
                }
            }
        });
    }

    private static float min3(float a, float b, float c) {
        return b <= a ? (b <= c ? b : c) : (a <= c ? a : c);
    }

    private static float[] like(float[] a) {
        return new float[a.length];
    }

    private static float[][] like(float[][] a) {
        return new float[a.length][a[0].length];
    }

    private static float[][][] like(float[][][] a) {
        return new float[a.length][a[0].length][a[0][0].length];
    }

    private void computeErrors(float[][][] f, float[][][] g, float[][][][] e) {
        final int n2 = e[0].length;
        int n3 = e.length;
        final float[][][] ff = f;
        final float[][][] gf = g;
        final float[][][][] ef = e;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    DynamicWarping.this.computeErrors(ff[i3][i2], gf[i3][i2], ef[i3][i2]);
                }
            }
        });
        DynamicWarping.normalizeErrors(e);
    }

    private static void normalizeErrors(float[][][][] e) {
        final int nl = e[0][0][0].length;
        final int n1 = e[0][0].length;
        final int n2 = e[0].length;
        int n3 = e.length;
        final float[][][][] ef = e;
        MinMax mm = Parallel.reduce(n3, new Parallel.ReduceInt<MinMax>(){

            @Override
            public MinMax compute(int i3) {
                float emin = Float.MAX_VALUE;
                float emax = -3.4028235E38f;
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (int i1 = 0; i1 < n1; ++i1) {
                        for (int il = 0; il < nl; ++il) {
                            float ei = ef[i3][i2][i1][il];
                            if (ei < emin) {
                                emin = ei;
                            }
                            if (!(ei > emax)) continue;
                            emax = ei;
                        }
                    }
                }
                return new MinMax(emin, emax);
            }

            @Override
            public MinMax combine(MinMax mm1, MinMax mm2) {
                return new MinMax(ArrayMath.min(mm1.emin, mm2.emin), ArrayMath.max(mm1.emax, mm2.emax));
            }
        });
        DynamicWarping.shiftAndScale(mm.emin, mm.emax, e);
    }

    private static void shiftAndScale(float emin, float emax, float[][][][] e) {
        final int nl = e[0][0][0].length;
        final int n1 = e[0][0].length;
        final int n2 = e[0].length;
        int n3 = e.length;
        final float eshift = emin;
        final float escale = emax > emin ? 1.0f / (emax - emin) : 1.0f;
        final float[][][][] ef = e;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (int i1 = 0; i1 < n1; ++i1) {
                        for (int il = 0; il < nl; ++il) {
                            ef[i3][i2][i1][il] = (ef[i3][i2][i1][il] - eshift) * escale;
                        }
                    }
                }
            }
        });
    }

    private void smoothErrors(float[][][][] e) {
        int n2 = e[0].length;
        final int n3 = e.length;
        final float[][][][] ef = e;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                DynamicWarping.smoothErrors1(DynamicWarping.this._bstrain1, ef[i3], ef[i3]);
            }
        });
        DynamicWarping.normalizeErrors(e);
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                DynamicWarping.smoothErrors2(DynamicWarping.this._bstrain2, ef[i3], ef[i3]);
            }
        });
        DynamicWarping.normalizeErrors(e);
        Parallel.loop(n2, new Parallel.LoopInt(){

            @Override
            public void compute(int i2) {
                float[][][] ei2 = new float[n3][][];
                for (int i3 = 0; i3 < n3; ++i3) {
                    ei2[i3] = ef[i3][i2];
                }
                DynamicWarping.smoothErrors2(DynamicWarping.this._bstrain3, ei2, ei2);
            }
        });
        DynamicWarping.normalizeErrors(e);
    }

    private void computeShifts(float[][][][] e, float[][][] u) {
        final int nl = e[0][0][0].length;
        final int n1 = e[0][0].length;
        final int n2 = e[0].length;
        int n3 = e.length;
        final float[][][][] ef = e;
        final float[][][] uf = u;
        final Parallel.Unsafe du = new Parallel.Unsafe();
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                float[][] d = (float[][])du.get();
                if (d == null) {
                    d = new float[n1][nl];
                    du.set(d);
                }
                for (int i2 = 0; i2 < n2; ++i2) {
                    DynamicWarping.this.accumulateForward(ef[i3][i2], d);
                    DynamicWarping.this.backtrackReverse(d, ef[i3][i2], uf[i3][i2]);
                }
            }
        });
    }

    private void smoothShifts(float[][][] u) {
        if (this._ref1 != null) {
            this._ref1.apply1(u, u);
        }
        if (this._ref2 != null) {
            this._ref2.apply2(u, u);
        }
        if (this._ref3 != null) {
            this._ref3.apply3(u, u);
        }
    }

    private static class OverlappingWindows2 {
        private int _n1;
        private int _n2;
        private int _l1;
        private int _l2;
        private int _m1;
        private int _m2;
        private double _s1;
        private double _s2;
        private float[][] _w;
        private float[][] _s;

        public OverlappingWindows2(int n1, int n2, int l1, int l2, double f1, double f2) {
            Check.argument(0.0 <= f1 && f1 < 1.0, "0 <= f1 < 1");
            Check.argument(0.0 <= f2 && f2 < 1.0, "0 <= f2 < 1");
            this._n1 = n1;
            this._n2 = n2;
            this._l1 = ArrayMath.min(l1, n1);
            this._l2 = ArrayMath.min(l2, n2);
            this._m1 = 1 + (int)ArrayMath.ceil((double)(this._n1 - this._l1) / ((double)this._l1 * (1.0 - f1)));
            this._m2 = 1 + (int)ArrayMath.ceil((double)(this._n2 - this._l2) / ((double)this._l2 * (1.0 - f2)));
            this._s1 = (double)(this._n1 - this._l1) / (double)ArrayMath.max(1, this._m1 - 1);
            this._s2 = (double)(this._n2 - this._l2) / (double)ArrayMath.max(1, this._m2 - 1);
            this.makeWeights();
            this.makeScalars();
        }

        public int getN1() {
            return this._n1;
        }

        public int getN2() {
            return this._n2;
        }

        public int getL1() {
            return this._l1;
        }

        public int getL2() {
            return this._l2;
        }

        public int getM1() {
            return this._m1;
        }

        public int getM2() {
            return this._m2;
        }

        public int getI1(int k1) {
            return (int)((double)k1 * this._s1 + 0.5);
        }

        public int getI2(int k2) {
            return (int)((double)k2 * this._s2 + 0.5);
        }

        public float getWeight(int i1, int i2, int j1, int j2) {
            return this._w[j2][j1] * this._s[i2 + j2][i1 + j1];
        }

        public float[][] getWeights() {
            return this._w;
        }

        public float[][] getScalars() {
            return this._s;
        }

        private void makeWeights() {
            this._w = new float[this._l2][this._l1];
            for (int i2 = 0; i2 < this._l2; ++i2) {
                for (int i1 = 0; i1 < this._l1; ++i1) {
                    double s1 = ArrayMath.sin(((double)i1 + 1.0) * Math.PI / ((double)this._l1 + 1.0));
                    double s2 = ArrayMath.sin(((double)i2 + 1.0) * Math.PI / ((double)this._l2 + 1.0));
                    this._w[i2][i1] = (float)(s1 * s1 * s2 * s2);
                }
            }
        }

        private void makeScalars() {
            this._s = new float[this._n2][this._n1];
            for (int k2 = 0; k2 < this._m2; ++k2) {
                int i2 = this.getI2(k2);
                for (int k1 = 0; k1 < this._m1; ++k1) {
                    int i1 = this.getI1(k1);
                    for (int j2 = 0; j2 < this._l2; ++j2) {
                        for (int j1 = 0; j1 < this._l1; ++j1) {
                            float[] fArray = this._s[i2 + j2];
                            int n = i1 + j1;
                            fArray[n] = fArray[n] + this._w[j2][j1];
                        }
                    }
                }
            }
            for (int i2 = 0; i2 < this._n2; ++i2) {
                for (int i1 = 0; i1 < this._n1; ++i1) {
                    this._s[i2][i1] = 1.0f / this._s[i2][i1];
                }
            }
        }
    }

    private static class MinMax {
        float emin;
        float emax;

        MinMax(float emin, float emax) {
            this.emin = emin;
            this.emax = emax;
        }
    }

    public static enum ErrorExtrapolation {
        NEAREST,
        AVERAGE,
        REFLECT;

    }
}

