/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.mosaic;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.mosaic.IPanel;
import edu.mines.jtk.mosaic.Mosaic;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.Tile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.IndexColorModel;
import java.util.EnumSet;

public class ColorBar
extends IPanel
implements ColorMapListener {
    private static final long serialVersionUID = 1L;
    private Mosaic _mosaic = new Mosaic(1, 1, EnumSet.of(Mosaic.AxesPlacement.RIGHT));
    private Tile _tile;
    private PixelsView _pixels;

    public ColorBar() {
        this((String)null);
    }

    public ColorBar(String label) {
        if (label != null) {
            this._mosaic.getTileAxisRight(0).setLabel(label);
        }
        this._mosaic.setWidthMinimum(0, 15);
        this._mosaic.setWidthElastic(0, 0);
        this._tile = this._mosaic.getTile(0, 0);
        this.setLayout(new BorderLayout());
        this.add((Component)this._mosaic, "Center");
    }

    public void setLabel(String label) {
        this._mosaic.getTileAxisRight(0).setLabel(label);
        this.revalidate();
    }

    public void setWidthMinimum(int widthMinimum) {
        this._mosaic.getTileAxisRight(0).setWidthMinimum(widthMinimum);
        this.revalidate();
    }

    public void setFormat(String format) {
        this._mosaic.getTileAxisRight(0).setFormat(format);
        this.revalidate();
    }

    public void setInterval(double interval) {
        this._mosaic.getTileAxisRight(0).setInterval(interval);
        this.revalidate();
    }

    public Tile getTile() {
        return this._tile;
    }

    @Override
    public void colorMapChanged(ColorMap cm) {
        float vmax;
        float vmin = (float)cm.getMinValue();
        if (vmin == (vmax = (float)cm.getMaxValue())) {
            vmin -= Math.ulp(vmin);
            vmax += Math.ulp(vmax);
        }
        int nv = 256;
        double dv = (vmax - vmin) / (float)(nv - 1);
        double fv = vmin;
        Sampling vs = new Sampling(nv, dv, fv);
        float[][] va = new float[nv][1];
        Color[] ca = new Color[nv];
        for (int iv = 0; iv < nv; ++iv) {
            float vi;
            va[iv][0] = vi = (float)vs.getValue(iv);
            ca[iv] = cm.getColor(vi);
        }
        if (this._pixels == null) {
            this._pixels = new PixelsView(va);
            this._pixels.setOrientation(PixelsView.Orientation.X1RIGHT_X2UP);
            this._pixels.setInterpolation(PixelsView.Interpolation.LINEAR);
            this._tile.addTiledView(this._pixels);
        }
        IndexColorModel icm = ColorMap.makeIndexColorModel(ca);
        this._pixels.setClips(vmin, vmax);
        this._pixels.setColorModel(icm);
        Sampling s1 = new Sampling(1);
        Sampling s2 = vs;
        this._pixels.set(s1, s2, va);
    }

    @Override
    public void paintToRect(Graphics2D g2d, int x, int y, int w, int h) {
        this._mosaic.paintToRect(g2d, x, y, w, h);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this._mosaic != null) {
            this._mosaic.setFont(font);
        }
        this.revalidate();
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this._mosaic != null) {
            this._mosaic.setForeground(color);
        }
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this._mosaic != null) {
            this._mosaic.setBackground(color);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintToRect((Graphics2D)g, 0, 0, this.getWidth(), this.getHeight());
    }

    protected Mosaic getMosaic() {
        return this._mosaic;
    }
}

