/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.dsp.EigenTensors3;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedQuad;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.SimpleFrame;
import edu.mines.jtk.sgl.TensorsPanel;
import edu.mines.jtk.sgl.World;
import edu.mines.jtk.util.ArrayMath;

public class TensorsPanelTest {
    public static void main(String[] args) {
        TensorsPanelTest.test1();
        TensorsPanelTest.test2();
        TensorsPanelTest.test3();
    }

    public static void test1() {
        int n1 = 1;
        int n2 = 111;
        int n3 = 111;
        EigenTensors3 et = new EigenTensors3(n1, n2, n3, false);
        float eu = 1.0f;
        float ev = 1.0f;
        float ew = 0.01f;
        float u1 = 1.0f;
        float u2 = 0.0f;
        float u3 = 0.0f;
        float w1 = 0.0f;
        float w2 = 0.0f;
        float w3 = 1.0f;
        int i1 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            float a = (float)i3 * (float)Math.PI / 2.0f / (float)(n3 - 1);
            w2 = ArrayMath.sin(a);
            w3 = ArrayMath.cos(a);
            for (int i2 = 0; i2 < n2; ++i2) {
                et.setEigenvalues(i1, i2, i3, eu, ev, ew);
                et.setEigenvectorU(i1, i2, i3, u1, u2, u3);
                et.setEigenvectorW(i1, i2, i3, w1, w2, w3);
            }
        }
        TensorsPanel tp = new TensorsPanel(et);
        AxisAlignedQuad aaq = new AxisAlignedQuad(Axis.Z, new Point3(0.0, 0.0, i1), new Point3(n3 - 1, n2 - 1, i1));
        aaq.getFrame().addChild(tp);
        TensorsPanelTest.show(aaq);
    }

    public static void test2() {
        int n1 = 111;
        int n2 = 1;
        int n3 = 111;
        EigenTensors3 et = new EigenTensors3(n1, n2, n3, false);
        float eu = 0.01f;
        float ev = 1.0f;
        float ew = 1.0f;
        float u1 = 1.0f;
        float u2 = 0.0f;
        float u3 = 0.0f;
        float w1 = 0.0f;
        float w2 = 1.0f;
        float w3 = 0.0f;
        int i2 = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            float a = (float)i3 * (float)Math.PI / 2.0f / (float)(n3 - 1);
            u1 = ArrayMath.cos(a);
            u3 = ArrayMath.sin(a);
            for (int i1 = 0; i1 < n1; ++i1) {
                et.setEigenvalues(i1, i2, i3, eu, ev, ew);
                et.setEigenvectorU(i1, i2, i3, u1, u2, u3);
                et.setEigenvectorW(i1, i2, i3, w1, w2, w3);
            }
        }
        TensorsPanel tp = new TensorsPanel(et);
        AxisAlignedQuad aaq = new AxisAlignedQuad(Axis.Y, new Point3(0.0, i2, 0.0), new Point3(n3 - 1, i2, n1 - 1));
        aaq.getFrame().addChild(tp);
        TensorsPanelTest.show(aaq);
    }

    public static void test3() {
        int n1 = 111;
        int n2 = 111;
        int n3 = 1;
        EigenTensors3 et = new EigenTensors3(n1, n2, n3, false);
        float eu = 0.01f;
        float ev = 1.0f;
        float ew = 1.0f;
        float u1 = 1.0f;
        float u2 = 0.0f;
        float u3 = 0.0f;
        float w1 = 0.0f;
        float w2 = 0.0f;
        float w3 = 1.0f;
        int i3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            float a = (float)i2 * (float)Math.PI / 2.0f / (float)(n2 - 1);
            u1 = ArrayMath.cos(a);
            u2 = ArrayMath.sin(a);
            for (int i1 = 0; i1 < n1; ++i1) {
                et.setEigenvalues(i1, i2, i3, eu, ev, ew);
                et.setEigenvectorU(i1, i2, i3, u1, u2, u3);
                et.setEigenvectorW(i1, i2, i3, w1, w2, w3);
            }
        }
        TensorsPanel tp = new TensorsPanel(et);
        AxisAlignedQuad aaq = new AxisAlignedQuad(Axis.X, new Point3(i3, 0.0, 0.0), new Point3(i3, n2 - 1, n1 - 1));
        aaq.getFrame().addChild(tp);
        TensorsPanelTest.show(aaq);
    }

    private static void show(Node node) {
        World world = new World();
        world.addChild(node);
        SimpleFrame sf = new SimpleFrame(world);
        sf.getOrbitView().setScale(2.0);
    }
}

