/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.io.SaveDialog;
import ij.measure.Measurements;
import ij.measure.ResultsTable;
import ij.plugin.filter.ParticleAnalyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ByteProcessor;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;

public class MTrack2_
implements PlugInFilter,
Measurements {
    ImagePlus imp;
    int nParticles;
    float[][] ssx;
    float[][] ssy;
    String directory;
    String filename;
    static int minSize = 1;
    static int maxSize = 999999;
    static int minTrackLength = 2;
    static boolean bSaveResultsFile = false;
    static boolean bShowLabels = false;
    static boolean bShowPositions = false;
    static boolean bShowPaths = false;
    static boolean bShowPathLengths = false;
    static float maxVelocity = 10.0f;
    static int maxColumns = 75;
    static boolean skipDialogue = false;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        if (IJ.versionLessThan((String)"1.17y")) {
            return 4096;
        }
        return 129;
    }

    public static void setProperty(String arg1, String arg2) {
        if (arg1.equals("minSize")) {
            minSize = Integer.parseInt(arg2);
        } else if (arg1.equals("maxSize")) {
            maxSize = Integer.parseInt(arg2);
        } else if (arg1.equals("minTrackLength")) {
            minTrackLength = Integer.parseInt(arg2);
        } else if (arg1.equals("maxVelocity")) {
            maxVelocity = Float.valueOf(arg2).floatValue();
        } else if (arg1.equals("saveResultsFile")) {
            bSaveResultsFile = Boolean.valueOf(arg2);
        } else if (arg1.equals("showPathLengths")) {
            bShowPathLengths = Boolean.valueOf(arg2);
        } else if (arg1.equals("showLabels")) {
            bShowLabels = Boolean.valueOf(arg2);
        } else if (arg1.equals("showPositions")) {
            bShowPositions = Boolean.valueOf(arg2);
        } else if (arg1.equals("showPaths")) {
            bShowPaths = Boolean.valueOf(arg2);
        } else if (arg1.equals("skipDialogue")) {
            skipDialogue = Boolean.valueOf(arg2);
        }
    }

    public void run(ImageProcessor ip) {
        if (!skipDialogue) {
            GenericDialog gd = new GenericDialog("Object Tracker");
            gd.addNumericField("Minimum Object Size (pixels): ", (double)minSize, 0);
            gd.addNumericField("Maximum Object Size (pixels): ", (double)maxSize, 0);
            gd.addNumericField("Maximum_ Velocity:", (double)maxVelocity, 0);
            gd.addNumericField("Minimum_ track length (frames)", (double)minTrackLength, 0);
            gd.addCheckbox("Save Results File", bSaveResultsFile);
            gd.addCheckbox("Display Path Lengths", bShowPathLengths);
            gd.addCheckbox("Show Labels", bShowLabels);
            gd.addCheckbox("Show Positions", bShowPositions);
            gd.addCheckbox("Show Paths", bShowPaths);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            minSize = (int)gd.getNextNumber();
            maxSize = (int)gd.getNextNumber();
            maxVelocity = (float)gd.getNextNumber();
            minTrackLength = (int)gd.getNextNumber();
            bSaveResultsFile = gd.getNextBoolean();
            bShowPathLengths = gd.getNextBoolean();
            bShowLabels = gd.getNextBoolean();
            bShowPositions = gd.getNextBoolean();
            bShowPaths = gd.getNextBoolean();
            if (bShowPositions) {
                bShowLabels = true;
            }
        }
        if (bSaveResultsFile) {
            SaveDialog sd = new SaveDialog("Save Track Results", "trackresults", ".txt");
            this.directory = sd.getDirectory();
            this.filename = sd.getFileName();
        }
        this.track(this.imp, minSize, maxSize, maxVelocity, this.directory, this.filename);
    }

    public void track(ImagePlus imp, int minSize, int maxSize, float maxVelocity, String directory, String filename) {
        boolean writefile;
        ArrayList theTracks;
        int trackCount;
        ArrayList[] theParticles;
        ImageStack stack;
        int nFrames;
        block52: {
            int repeat;
            float reTest;
            nFrames = imp.getStackSize();
            if (nFrames < 2) {
                IJ.showMessage((String)"Tracker", (String)"Stack required");
                return;
            }
            stack = imp.getStack();
            int options = 0;
            int measurements = 32;
            ResultsTable rt = new ResultsTable();
            rt.reset();
            theParticles = new ArrayList[nFrames];
            trackCount = 0;
            for (int iFrame = 1; iFrame <= nFrames; ++iFrame) {
                theParticles[iFrame - 1] = new ArrayList();
                rt.reset();
                ParticleAnalyzer pa = new ParticleAnalyzer(options, measurements, rt, (double)minSize, (double)maxSize);
                pa.analyze(imp, stack.getProcessor(iFrame));
                float[] sxRes = rt.getColumn(6);
                float[] syRes = rt.getColumn(7);
                if (sxRes == null) continue;
                for (int iPart = 0; iPart < sxRes.length; ++iPart) {
                    particle aParticle = new particle();
                    aParticle.x = sxRes[iPart];
                    aParticle.y = syRes[iPart];
                    aParticle.z = iFrame - 1;
                    theParticles[iFrame - 1].add(aParticle);
                }
                IJ.showProgress((double)((double)iFrame / (double)nFrames));
            }
            theTracks = new ArrayList();
            for (int i = 0; i <= nFrames - 1; ++i) {
                IJ.showProgress((double)((double)i / (double)nFrames));
                ListIterator j = theParticles[i].listIterator();
                while (j.hasNext()) {
                    particle aParticle = (particle)j.next();
                    if (aParticle.inTrack) continue;
                    ArrayList<particle> aTrack = new ArrayList<particle>();
                    aParticle.inTrack = true;
                    aParticle.trackNr = ++trackCount;
                    aTrack.add(aParticle);
                    boolean searchOn = true;
                    particle oldParticle = new particle();
                    particle tmpParticle = new particle();
                    oldParticle.copy(aParticle);
                    for (int iF = i + 1; iF <= nFrames - 1; ++iF) {
                        boolean foundOne = false;
                        particle newParticle = new particle();
                        ListIterator jF = theParticles[iF].listIterator();
                        while (jF.hasNext() && searchOn) {
                            particle testParticle = (particle)jF.next();
                            float distance = testParticle.distance(oldParticle);
                            if (distance < maxVelocity && !testParticle.inTrack) {
                                if (!foundOne) {
                                    tmpParticle = testParticle;
                                    testParticle.inTrack = true;
                                    testParticle.trackNr = trackCount;
                                    newParticle.copy(testParticle);
                                    foundOne = true;
                                    continue;
                                }
                                testParticle.flag = true;
                                if (distance < newParticle.distance(oldParticle)) {
                                    testParticle.inTrack = true;
                                    testParticle.trackNr = trackCount;
                                    newParticle.copy(testParticle);
                                    tmpParticle.inTrack = false;
                                    tmpParticle.trackNr = 0;
                                    tmpParticle = testParticle;
                                    continue;
                                }
                                newParticle.flag = true;
                                continue;
                            }
                            if (!(distance < maxVelocity)) continue;
                            testParticle.flag = true;
                        }
                        if (foundOne) {
                            aTrack.add(newParticle);
                        } else {
                            searchOn = false;
                        }
                        oldParticle.copy(newParticle);
                    }
                    theTracks.add(aTrack);
                }
            }
            String strHeadings = "Frame";
            int frameCount = 1;
            ListIterator iT = theTracks.listIterator();
            while (iT.hasNext()) {
                ArrayList bTrack = (ArrayList)iT.next();
                if (bTrack.size() < minTrackLength) continue;
                if (frameCount <= maxColumns) {
                    strHeadings = strHeadings + "\tX" + frameCount + "\tY" + frameCount + "\tFlag" + frameCount;
                }
                ++frameCount;
            }
            String contents = "";
            writefile = false;
            if (filename != null) {
                File outputfile = new File(directory, filename);
                if (!outputfile.canWrite()) {
                    try {
                        outputfile.createNewFile();
                    }
                    catch (IOException e) {
                        IJ.showMessage((String)"Error", (String)("Could not create " + directory + filename));
                    }
                }
                if (outputfile.canWrite()) {
                    writefile = true;
                } else {
                    IJ.showMessage((String)"Error", (String)("Could not write to " + directory + filename));
                }
            }
            if ((reTest = (float)frameCount / (float)maxColumns) > (float)(repeat = frameCount / maxColumns)) {
                ++repeat;
            }
            if (!writefile) {
                IJ.setColumnHeadings((String)strHeadings);
                for (int j = 1; j <= repeat; ++j) {
                    int to = j * maxColumns;
                    if (to > frameCount - 1) {
                        to = frameCount - 1;
                    }
                    String stLine = "Tracks " + ((j - 1) * maxColumns + 1) + " to " + to;
                    IJ.write((String)stLine);
                    for (int i = 0; i <= nFrames - 1; ++i) {
                        String strLine = "" + (i + 1);
                        int trackNr = 0;
                        int listTrackNr = 0;
                        ListIterator iT2 = theTracks.listIterator();
                        while (iT2.hasNext()) {
                            ++trackNr;
                            ArrayList bTrack = (ArrayList)iT2.next();
                            boolean particleFound = false;
                            if (bTrack.size() < minTrackLength || ++listTrackNr <= (j - 1) * maxColumns || listTrackNr > j * maxColumns) continue;
                            ListIterator k = theParticles[i].listIterator();
                            while (k.hasNext() && !particleFound) {
                                particle aParticle = (particle)k.next();
                                if (aParticle.trackNr != trackNr) continue;
                                particleFound = true;
                                String flag = aParticle.flag ? "*" : " ";
                                strLine = strLine + "\t" + aParticle.x + "\t" + aParticle.y + "\t" + flag;
                            }
                            if (particleFound) continue;
                            strLine = strLine + "\t \t \t ";
                        }
                        IJ.write((String)strLine);
                    }
                }
            }
            if (writefile) {
                try {
                    File outputfile = new File(directory, filename);
                    BufferedWriter dos = new BufferedWriter(new FileWriter(outputfile));
                    dos.write(strHeadings + "\n", 0, strHeadings.length() + 1);
                    for (int j = 1; j <= repeat; ++j) {
                        int to = j * maxColumns;
                        if (to > frameCount - 1) {
                            to = frameCount - 1;
                        }
                        String stLine = "Tracks " + ((j - 1) * maxColumns + 1) + " to " + to;
                        dos.write(stLine + "\n", 0, stLine.length() + 1);
                        for (int i = 0; i <= nFrames - 1; ++i) {
                            String strLine = "" + (i + 1);
                            int trackNr = 0;
                            int listTrackNr = 0;
                            ListIterator iT3 = theTracks.listIterator();
                            while (iT3.hasNext()) {
                                ++trackNr;
                                ArrayList bTrack = (ArrayList)iT3.next();
                                boolean particleFound = false;
                                if (bTrack.size() < minTrackLength || ++listTrackNr <= (j - 1) * maxColumns || listTrackNr > j * maxColumns) continue;
                                ListIterator k = theParticles[i].listIterator();
                                while (k.hasNext() && !particleFound) {
                                    particle aParticle = (particle)k.next();
                                    if (aParticle.trackNr != trackNr) continue;
                                    particleFound = true;
                                    String flag = aParticle.flag ? "*" : " ";
                                    strLine = strLine + "\t" + aParticle.x + "\t" + aParticle.y + "\t" + flag;
                                }
                                if (particleFound) continue;
                                strLine = strLine + "\t \t \t ";
                            }
                            dos.write(strLine + "\n", 0, strLine.length() + 1);
                        }
                    }
                    if (bShowPathLengths) {
                        double[] lengths = new double[trackCount];
                        double[] distances = new double[trackCount];
                        int[] frames = new int[trackCount];
                        int trackNr = 0;
                        int displayTrackNr = 0;
                        ListIterator iT4 = theTracks.listIterator();
                        while (iT4.hasNext()) {
                            ++trackNr;
                            ArrayList bTrack = (ArrayList)iT4.next();
                            if (bTrack.size() < minTrackLength) continue;
                            ListIterator jT = bTrack.listIterator();
                            particle oldParticle = (particle)jT.next();
                            particle firstParticle = new particle();
                            firstParticle.copy(oldParticle);
                            frames[++displayTrackNr - 1] = bTrack.size();
                            while (jT.hasNext()) {
                                particle newParticle = (particle)jT.next();
                                int n = displayTrackNr - 1;
                                lengths[n] = lengths[n] + Math.sqrt(this.sqr(oldParticle.x - newParticle.x) + this.sqr(oldParticle.y - newParticle.y));
                                oldParticle = newParticle;
                            }
                            distances[displayTrackNr - 1] = Math.sqrt(this.sqr(oldParticle.x - firstParticle.x) + this.sqr(oldParticle.y - firstParticle.y));
                        }
                        dos.write("\n");
                        dos.write("Track \tLength\tDistance traveled\tNr of Frames\n", 0, 45);
                        for (int i = 0; i < displayTrackNr; ++i) {
                            String str = "" + (i + 1) + "\t" + (float)lengths[i] + "\t" + (float)distances[i] + "\t" + frames[i];
                            dos.write(str + "\n", 0, str.length() + 1);
                        }
                    }
                    dos.close();
                }
                catch (IOException e) {
                    if (filename == null) break block52;
                    IJ.error((String)("An error occurred writing the file. \n \n " + e));
                }
            }
        }
        if (bShowLabels) {
            ImageStack newstack = imp.createEmptyStack();
            int xHeight = newstack.getHeight();
            int yWidth = newstack.getWidth();
            for (int i = 0; i <= nFrames - 1; ++i) {
                int iFrame = i + 1;
                String strLine = "" + i;
                ImageProcessor ip = stack.getProcessor(iFrame);
                newstack.addSlice(stack.getSliceLabel(iFrame), ip.crop());
                ImageProcessor nip = newstack.getProcessor(iFrame);
                nip.setColor(Color.black);
                int trackNr = 0;
                int displayTrackNr = 0;
                ListIterator iT = theTracks.listIterator();
                while (iT.hasNext()) {
                    ++trackNr;
                    ArrayList bTrack = (ArrayList)iT.next();
                    if (bTrack.size() < minTrackLength) continue;
                    ++displayTrackNr;
                    ListIterator k = theParticles[i].listIterator();
                    while (k.hasNext()) {
                        particle aParticle = (particle)k.next();
                        if (aParticle.trackNr != trackNr) continue;
                        String strPart = "" + displayTrackNr;
                        if (bShowPositions) {
                            strPart = strPart + "=" + (int)aParticle.x + "," + (int)aParticle.y;
                        }
                        nip.moveTo((int)aParticle.x + 5, this.doOffset((int)aParticle.y, yWidth, 5));
                        nip.drawString(strPart);
                    }
                }
                IJ.showProgress((double)((double)iFrame / (double)nFrames));
            }
            ImagePlus nimp = new ImagePlus(imp.getTitle() + " labels", newstack);
            nimp.show();
            imp.show();
            nimp.updateAndDraw();
        }
        if (bShowPathLengths && !writefile) {
            double[] lengths = new double[trackCount];
            double[] distances = new double[trackCount];
            int[] frames = new int[trackCount];
            int trackNr = 0;
            int displayTrackNr = 0;
            ListIterator iT = theTracks.listIterator();
            while (iT.hasNext()) {
                ++trackNr;
                ArrayList bTrack = (ArrayList)iT.next();
                if (bTrack.size() < minTrackLength) continue;
                ListIterator jT = bTrack.listIterator();
                particle oldParticle = (particle)jT.next();
                particle firstParticle = new particle();
                firstParticle.copy(oldParticle);
                frames[++displayTrackNr - 1] = bTrack.size();
                while (jT.hasNext()) {
                    particle newParticle = (particle)jT.next();
                    int n = displayTrackNr - 1;
                    lengths[n] = lengths[n] + Math.sqrt(this.sqr(oldParticle.x - newParticle.x) + this.sqr(oldParticle.y - newParticle.y));
                    oldParticle = newParticle;
                }
                distances[displayTrackNr - 1] = Math.sqrt(this.sqr(oldParticle.x - firstParticle.x) + this.sqr(oldParticle.y - firstParticle.y));
            }
            IJ.write((String)"");
            IJ.write((String)"Track \tLength\tDistance traveled\tNr of Frames");
            for (int i = 0; i < displayTrackNr; ++i) {
                String str = "" + (i + 1) + ":\t" + (float)lengths[i] + "\t" + (float)distances[i] + "\t" + frames[i];
                IJ.write((String)str);
            }
        }
        if (bShowPaths) {
            if (imp.getCalibration().scaled()) {
                IJ.showMessage((String)"MultiTracker", (String)"Cannot display paths if image is spatially calibrated");
                return;
            }
            ByteProcessor ip = new ByteProcessor(imp.getWidth(), imp.getHeight());
            ip.setColor(Color.white);
            ip.fill();
            trackCount = 0;
            ListIterator iT = theTracks.listIterator();
            while (iT.hasNext()) {
                ++trackCount;
                ArrayList bTrack = (ArrayList)iT.next();
                if (bTrack.size() < minTrackLength) continue;
                ListIterator jT = bTrack.listIterator();
                particle oldParticle = (particle)jT.next();
                while (jT.hasNext()) {
                    particle newParticle = (particle)jT.next();
                    int color = Math.min(trackCount + 1, 254);
                    ip.setValue((double)color);
                    ip.moveTo((int)oldParticle.x, (int)oldParticle.y);
                    ip.lineTo((int)newParticle.x, (int)newParticle.y);
                    oldParticle = newParticle;
                }
            }
            new ImagePlus("Paths", (ImageProcessor)ip).show();
        }
    }

    double sqr(double n) {
        return n * n;
    }

    int doOffset(int center, int maxSize, int displacement) {
        if (center - displacement < 2 * displacement) {
            return center + 4 * displacement;
        }
        return center - displacement;
    }

    double s2d(String s) {
        Double d;
        try {
            d = new Double(s);
        }
        catch (NumberFormatException e) {
            d = null;
        }
        if (d != null) {
            return d;
        }
        return 0.0;
    }

    public class particle {
        float x;
        float y;
        int z;
        int trackNr;
        boolean inTrack = false;
        boolean flag = false;

        public void copy(particle source) {
            this.x = source.x;
            this.y = source.y;
            this.z = source.z;
            this.inTrack = source.inTrack;
            this.flag = source.flag;
        }

        public float distance(particle p) {
            return (float)Math.sqrt(MTrack2_.this.sqr(this.x - p.x) + MTrack2_.this.sqr(this.y - p.y));
        }
    }
}

