/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.launcher;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.scijava.launcher.Log;

final class ClassLoaders {
    private ClassLoaders() {
    }

    static Stream<ClassLoader> loaders(ClassLoader preferred) {
        return ClassLoaders.loaders(preferred, null);
    }

    static Stream<ClassLoader> loaders(Class<?> fallback) {
        return ClassLoaders.loaders(null, fallback);
    }

    static Stream<ClassLoader> loaders(ClassLoader preferred, Class<?> fallback) {
        return Stream.of(preferred, Thread.currentThread().getContextClassLoader(), ClassLoader.getSystemClassLoader(), fallback == null ? null : fallback.getClassLoader()).distinct().filter(Objects::nonNull);
    }

    static Class<?> loadClass(ClassLoader preferred, String className) throws ClassNotFoundException {
        String noSlashes = className.replace('/', '.');
        ArrayList<ClassNotFoundException> failures = new ArrayList<ClassNotFoundException>();
        List classLoaders = ClassLoaders.loaders(preferred).collect(Collectors.toList());
        for (ClassLoader classLoader : classLoaders) {
            try {
                return classLoader.loadClass(noSlashes);
            }
            catch (ClassNotFoundException exc) {
                failures.add(exc);
            }
        }
        ClassNotFoundException classNotFound = new ClassNotFoundException("Failed to load class: " + noSlashes);
        for (ClassNotFoundException failure : failures) {
            classNotFound.addSuppressed(failure);
        }
        throw classNotFound;
    }

    static URL loadResource(Class<?> fallback, String path) {
        URL url = ClassLoaders.loaders(fallback).map(classLoader -> classLoader.getResource(path)).filter(Objects::nonNull).findFirst().orElse(null);
        if (url != null) {
            return url;
        }
        try {
            File resourceFile = new File(path);
            if (resourceFile.exists()) {
                return new File(path).toURI().toURL();
            }
        }
        catch (MalformedURLException exc) {
            Log.debug(exc);
        }
        throw new IllegalArgumentException("Failed to load resource: " + path);
    }

    static String extractClassVersion(UnsupportedClassVersionError e) {
        Pattern p = Pattern.compile(".*class file version ([\\d.]*).*");
        Matcher m = p.matcher(e.getMessage());
        return m.matches() ? m.group(1) : null;
    }
}

