/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.axispos;

import net.imagej.animation.AnimationService;
import net.imagej.axis.AxisType;
import net.imagej.display.ImageDisplay;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.DynamicCommand;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Axes", mnemonic=97), @Menu(label="Set Axis Position...")}, headless=true, attrs={@Attr(name="no-legacy")})
public class SetAxisPosition
extends DynamicCommand {
    @Parameter
    private AnimationService animationService;
    @Parameter(type=ItemIO.BOTH)
    private ImageDisplay display;
    @Parameter(persist=false, initializer="initPosition")
    private long oneBasedPosition = 1L;

    protected void initPosition() {
        MutableModuleItem positionItem = this.getInfo().getMutableInput("oneBasedPosition", Long.class);
        positionItem.setLabel("Position");
        positionItem.setMinimumValue((Object)1L);
        AxisType axis = this.display.getActiveAxis();
        if (axis == null) {
            return;
        }
        int dim = this.display.dimensionIndex(axis);
        Long value = this.display.dimension(dim);
        positionItem.setMaximumValue((Object)value);
    }

    public void run() {
        this.animationService.stop(this.display);
        AxisType axis = this.display.getActiveAxis();
        if (axis == null) {
            return;
        }
        long newPosition = this.oneBasedPosition - 1L;
        this.display.setPosition(newPosition, axis);
    }
}

