/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.vector;

import ini.trakem2.vector.Editions;
import ini.trakem2.vector.Util;
import ini.trakem2.vector.VectorString2D;
import java.util.ArrayList;
import java.util.List;
import org.jogamp.vecmath.Point3f;

public class SkinMaker {
    private SkinMaker() {
    }

    public static double[][] getMorphedPerimeter(VectorString2D vs1, VectorString2D vs2, double alpha, Editions ed) {
        int n = vs1.length();
        int m = vs2.length();
        double[] v_x1 = vs1.getVectors(0);
        double[] v_y1 = vs1.getVectors(1);
        double[] v_x2 = vs2.getVectors(0);
        double[] v_y2 = vs2.getVectors(1);
        int[][] editions = ed.getEditions();
        int n_editions = ed.length();
        double[] x = new double[n_editions];
        double[] y = new double[n_editions];
        x[0] = vs1.getPoint(0, 0) * (1.0 - alpha) + vs2.getPoint(0, 0) * alpha;
        y[0] = vs1.getPoint(1, 0) * (1.0 - alpha) + vs2.getPoint(1, 0) * alpha;
        int next = 0;
        int start = 0;
        int end = n_editions;
        if (2 == editions[0][0] || 1 == editions[0][0]) {
            start = 1;
            end = n_editions;
        }
        double vs_x = 0.0;
        double vs_y = 0.0;
        for (int e = start; e < end; ++e) {
            int i = editions[e][1];
            int j = editions[e][2];
            if (i == n) {
                i = 0;
            }
            if (j == m) {
                j = 0;
            }
            switch (editions[e][0]) {
                case 2: {
                    vs_x = v_x2[j] * alpha;
                    vs_y = v_y2[j] * alpha;
                    break;
                }
                case 1: {
                    vs_x = v_x1[i] * (1.0 - alpha);
                    vs_y = v_y1[i] * (1.0 - alpha);
                    break;
                }
                case 3: {
                    vs_x = v_x1[i] * (1.0 - alpha) + v_x2[j] * alpha;
                    vs_y = v_y1[i] * (1.0 - alpha) + v_y2[j] * alpha;
                    break;
                }
                default: {
                    System.out.println("\ngetMorphedPerimeter: Nothing added!");
                }
            }
            if (next + 1 == n_editions) {
                x = Util.copy(x, x.length + 1);
                y = Util.copy(y, y.length + 1);
            }
            x[next + 1] = x[next] + vs_x;
            y[next + 1] = y[next] + vs_y;
            ++next;
        }
        double[][] d = new double[][]{x, y};
        return d;
    }

    public static double[][][] getMorphedPerimeters(VectorString2D vs1, VectorString2D vs2, int n_morphed_perimeters, Editions ed) {
        if (n_morphed_perimeters < 0) {
            n_morphed_perimeters = (int)Math.sqrt(Math.sqrt(ed.getDistance()));
        }
        double alpha = 1.0 / (double)(n_morphed_perimeters + 1);
        double[][][] p_list = new double[n_morphed_perimeters][][];
        for (int a = 0; a < n_morphed_perimeters; ++a) {
            double aa = alpha * (double)(a + 1);
            p_list[a] = SkinMaker.getMorphedPerimeter(vs1, vs2, aa, ed);
        }
        return p_list;
    }

    public static ArrayList<Match> getMorphedPerimeters(VectorString2D[] vs, int n_morphed_perimeters, double delta_, boolean closed) {
        if (n_morphed_perimeters < -1 || vs.length <= 0) {
            System.out.println("\nERROR: args are not acceptable at getAllPerimeters:\n\t n_morphed_perimeters " + n_morphed_perimeters + ", n_perimeters " + vs.length);
            return null;
        }
        ArrayList<Match> al_matches = new ArrayList<Match>();
        try {
            int i;
            double delta = 0.0;
            if (delta_ > 0.0) {
                delta = delta_;
            } else {
                for (i = 0; i < vs.length; ++i) {
                    delta += vs[i].getAverageDelta();
                }
                delta /= (double)vs.length;
            }
            System.out.println("\nUsing delta=" + delta);
            for (i = 1; i < vs.length; ++i) {
                Editions ed = new Editions(vs[i - 1], vs[i], delta, closed);
                VectorString2D rev = (VectorString2D)vs[i].clone();
                rev.reverse();
                Editions ed_rev = new Editions(vs[i - 1], rev, delta, closed);
                if (ed_rev.getDistance() < ed.getDistance()) {
                    vs[i] = rev;
                    ed = ed_rev;
                }
                double[][][] d = SkinMaker.getMorphedPerimeters(vs[i - 1], vs[i], n_morphed_perimeters, ed);
                double z_start = vs[i - 1].getPoint(2, 0);
                double z_inc = (vs[i].getPoint(2, 0) - z_start) / (double)(0 == d.length ? 1 : d.length + 1);
                VectorString2D[] p = new VectorString2D[d.length];
                for (int k = 0; k < d.length; ++k) {
                    p[k] = new VectorString2D(d[k][0], d[k][1], z_start + z_inc * (double)(k + 1), vs[0].isClosed());
                }
                al_matches.add(new Match(vs[i - 1], vs[i], ed, p));
            }
            return al_matches;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Point3f> generateTriangles(VectorString2D[] vs, int n_morphed_perimeters, double delta_, boolean closed) {
        ArrayList<Match> al_matches = SkinMaker.getMorphedPerimeters(vs, -1, -1.0, true);
        ArrayList<Point3f> triangles = new ArrayList<Point3f>();
        for (Match match : al_matches) {
            triangles.addAll(match.generateTriangles(closed));
        }
        return triangles;
    }

    public static class Match {
        private VectorString2D vs1;
        private VectorString2D vs2;
        private Editions ed;
        private VectorString2D[] p;

        public Match(VectorString2D vs1, VectorString2D vs2, Editions ed, VectorString2D[] p) {
            this.vs1 = vs1;
            this.vs2 = vs2;
            this.ed = ed;
            this.p = p;
        }

        public List<Point3f> generateTriangles(boolean closed) {
            ArrayList<Point3f> triangles = new ArrayList<Point3f>();
            if (null == this.p || 0 == this.p.length) {
                triangles.addAll(this.makeSkin(this.vs1, this.vs2, closed, true, true));
            } else {
                triangles.addAll(this.makeSkin(this.vs1, this.p[0], closed, true, false));
                for (int i = 1; i < this.p.length; ++i) {
                    triangles.addAll(this.makeSkin(this.p[i - 1], this.p[i], closed, false, false));
                }
                triangles.addAll(this.makeSkin(this.p[this.p.length - 1], this.vs2, closed, false, true));
            }
            return triangles;
        }

        private ArrayList<Point3f> makeSkin(VectorString2D a, VectorString2D b, boolean closed, boolean ao, boolean bo) {
            double[] ax = a.getPoints(0);
            double[] ay = a.getPoints(1);
            float az = (float)a.getPoint(2, 0);
            int alength = a.length();
            double[] bx = b.getPoints(0);
            double[] by = b.getPoints(1);
            float bz = (float)b.getPoint(2, 0);
            int blength = b.length();
            ArrayList<Point3f> triangles = new ArrayList<Point3f>();
            int[][] editions = this.ed.editions;
            boolean e_start = false;
            int i = 0;
            int j = 0;
            if (ao || bo) {
                int lag = 0;
                for (int e = 0; e < editions.length; ++e) {
                    int ei = editions[e][0];
                    int i1 = editions[e][1];
                    int j1 = editions[e][2];
                    switch (ei) {
                        case 2: {
                            if (ao) break;
                            ++lag;
                            break;
                        }
                        case 1: {
                            if (bo) break;
                            ++lag;
                        }
                    }
                    if (!ao) {
                        i1 += lag;
                    }
                    if (!bo) {
                        j1 += lag;
                    }
                    if (i1 >= alength) {
                        i1 = closed ? 0 : alength - 1;
                    }
                    if (j1 >= blength) {
                        j1 = closed ? 0 : blength - 1;
                    }
                    if (!(3 != ei && (ao && bo || 2 != ei && 1 != ei))) {
                        triangles.add(new Point3f((float)ax[i1], (float)ay[i1], az));
                        triangles.add(new Point3f((float)ax[i], (float)ay[i], az));
                        triangles.add(new Point3f((float)bx[j], (float)by[j], bz));
                        triangles.add(new Point3f((float)ax[i1], (float)ay[i1], az));
                        triangles.add(new Point3f((float)bx[j], (float)by[j], bz));
                        triangles.add(new Point3f((float)bx[j1], (float)by[j1], bz));
                    } else {
                        triangles.add(new Point3f((float)ax[i], (float)ay[i], az));
                        triangles.add(new Point3f((float)bx[j], (float)by[j], bz));
                        triangles.add(new Point3f((float)bx[j1], (float)by[j1], bz));
                    }
                    i = i1;
                    j = j1;
                }
            } else {
                for (int k = 0; k < alength - 1; ++k) {
                    int i1;
                    int j1 = i1 = k + 1;
                    triangles.add(new Point3f((float)ax[i1], (float)ay[i1], az));
                    triangles.add(new Point3f((float)ax[i], (float)ay[i], az));
                    triangles.add(new Point3f((float)bx[j], (float)by[j], bz));
                    triangles.add(new Point3f((float)ax[i1], (float)ay[i1], az));
                    triangles.add(new Point3f((float)bx[j], (float)by[j], bz));
                    triangles.add(new Point3f((float)bx[j1], (float)by[j1], bz));
                    i = i1;
                    j = j1;
                }
            }
            if (closed) {
                // empty if block
            }
            return triangles;
        }
    }
}

