/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.addNoise;

import java.util.Random;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.AddNoise.class)
public class AddNoiseRealType<I extends RealType<I>, O extends RealType<O>>
extends AbstractUnaryComputerOp<I, O>
implements Ops.Filter.AddNoise {
    @Parameter
    private double rangeMin;
    @Parameter
    private double rangeMax;
    @Parameter
    private double rangeStdDev;
    @Parameter(required=false)
    private long seed = -6066930261531658096L;
    private Random rng;

    @Override
    public void compute(I input, O output) {
        if (this.rng == null) {
            this.rng = new Random(this.seed);
        }
        AddNoiseRealType.addNoise(input, output, this.rangeMin, this.rangeMax, this.rangeStdDev, this.rng);
    }

    public static <I extends RealType<I>, O extends RealType<O>> void addNoise(I input, O output, double rangeMin, double rangeMax, double rangeStdDev, Random rng) {
        int i = 0;
        do {
            double newVal;
            if (!(rangeMin <= (newVal = input.getRealDouble() + rng.nextGaussian() * rangeStdDev)) || !(newVal <= rangeMax)) continue;
            output.setReal(newVal);
            return;
        } while (i++ <= 100);
        throw new IllegalArgumentException("noise function failing to terminate. probably misconfigured.");
    }
}

