/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.geom.geom2d;

import java.util.List;
import net.imagej.ops.Ops;
import net.imagej.ops.geom.GeomUtils;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.RealLocalizable;
import net.imglib2.roi.geom.real.Polygon2D;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Geometric.FeretsDiameter.class)
public class DefaultFeretsDiameterForAngle
extends AbstractUnaryHybridCF<Polygon2D, DoubleType>
implements Ops.Geometric.FeretsDiameter {
    @Parameter
    private double angle = 0.0;
    private UnaryFunctionOp<Polygon2D, Polygon2D> function;

    @Override
    public void initialize() {
        this.function = Functions.unary(this.ops(), Ops.Geometric.ConvexHull.class, Polygon2D.class, this.in(), new Object[0]);
    }

    @Override
    public void compute(Polygon2D input, DoubleType output) {
        List<RealLocalizable> points = GeomUtils.vertices(this.function.calculate(input));
        double angleRad = -this.angle * Math.PI / 180.0;
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        for (RealLocalizable p : points) {
            double tmpX = p.getDoublePosition(0) * Math.cos(angleRad) - p.getDoublePosition(1) * Math.sin(angleRad);
            minX = tmpX < minX ? tmpX : minX;
            maxX = tmpX > maxX ? tmpX : maxX;
        }
        output.set(Math.abs(maxX - minX));
    }

    @Override
    public DoubleType createOutput(Polygon2D input) {
        return new DoubleType();
    }
}

