/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.morphology.thin;

import net.imagej.ops.morphology.thin.ThinningStrategy;
import net.imagej.ops.special.hybrid.AbstractUnaryHybridCF;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.FinalDimensions;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.type.logic.BitType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;

public abstract class AbstractThin
extends AbstractUnaryHybridCF<RandomAccessibleInterval<BitType>, RandomAccessibleInterval<BitType>> {
    protected ThinningStrategy m_strategy;

    @Override
    public RandomAccessibleInterval<BitType> createOutput(RandomAccessibleInterval<BitType> input) {
        long[] dims = new long[input.numDimensions()];
        input.dimensions(dims);
        FinalDimensions dimensions = new FinalDimensions(dims);
        return this.ops().create().img((Dimensions)dimensions, new BitType());
    }

    private void copy(RandomAccessibleInterval<BitType> source, RandomAccessibleInterval<BitType> target) {
        IterableInterval targetIt = Views.iterable(target);
        IterableInterval sourceIt = Views.iterable(source);
        if (sourceIt.iterationOrder().equals(targetIt.iterationOrder())) {
            Cursor targetCursor = targetIt.cursor();
            Cursor sourceCursor = sourceIt.cursor();
            while (sourceCursor.hasNext()) {
                targetCursor.fwd();
                sourceCursor.fwd();
                ((BitType)targetCursor.get()).set(((BitType)sourceCursor.get()).get());
            }
        } else {
            RandomAccess targetRA = target.randomAccess();
            Cursor sourceCursor = sourceIt.localizingCursor();
            while (sourceCursor.hasNext()) {
                sourceCursor.fwd();
                targetRA.setPosition((Localizable)sourceCursor);
                ((BitType)targetRA.get()).set(((BitType)sourceCursor.get()).get());
            }
        }
    }

    @Override
    public void compute(RandomAccessibleInterval<BitType> input, RandomAccessibleInterval<BitType> output) {
        Cursor secondCursor;
        Img<BitType> buffer = this.ops().create().img((Dimensions)input, new BitType());
        IterableInterval it1 = Views.iterable(buffer);
        IterableInterval it2 = Views.iterable(output);
        ExtendedRandomAccessibleInterval ra1 = Views.extendBorder(buffer);
        ExtendedRandomAccessibleInterval ra2 = Views.extendBorder(output);
        ExtendedRandomAccessibleInterval currRa = Views.extendBorder(input);
        Cursor firstCursor = it1.localizingCursor();
        Cursor currentCursor = Views.iterable(input).localizingCursor();
        Cursor nextCursor = secondCursor = it2.localizingCursor();
        boolean changes = true;
        int i = 0;
        long[] coordinates = new long[currentCursor.numDimensions()];
        while (changes) {
            changes = false;
            for (int j = 0; j < this.m_strategy.getIterationsPerCycle(); ++j) {
                while (currentCursor.hasNext()) {
                    boolean flip;
                    currentCursor.fwd();
                    nextCursor.fwd();
                    currentCursor.localize(coordinates);
                    boolean curr = ((BitType)currentCursor.get()).get();
                    ((BitType)nextCursor.get()).set(curr);
                    if (!curr || !(flip = this.m_strategy.removePixel(coordinates, (RandomAccessible<BitType>)currRa, j))) continue;
                    ((BitType)nextCursor.get()).set(false);
                    changes = true;
                }
                this.m_strategy.afterCycle();
                currentCursor.reset();
                nextCursor.reset();
                if (currRa == ra2) {
                    currRa = ra1;
                    currentCursor = firstCursor;
                    nextCursor = secondCursor;
                } else {
                    currRa = ra2;
                    currentCursor = secondCursor;
                    nextCursor = firstCursor;
                }
                ++i;
            }
        }
        if (i % 2 == 0) {
            this.copy((RandomAccessibleInterval<BitType>)buffer, output);
        }
    }
}

