/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.stats;

import net.imagej.ops.Ops;
import net.imagej.ops.stats.AbstractStatsOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Stats.GeometricMean.class, label="Statistics: Geometric Mean", priority=10000.0)
public class IterableGeometricMean<I extends RealType<I>, O extends RealType<O>>
extends AbstractStatsOp<Iterable<I>, O>
implements Ops.Stats.GeometricMean {
    @Override
    public void compute(Iterable<I> input, O output) {
        double size = 0.0;
        double sumOfLogs = 0.0;
        for (RealType in : input) {
            size += 1.0;
            sumOfLogs += Math.log(in.getRealDouble());
        }
        if (size != 0.0) {
            output.setReal(Math.exp(sumOfLogs / size));
        } else {
            output.setReal(0.0f);
        }
    }
}

