/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.base;

public class Crc64 {
    private static long[] _crc64Array = new long[256];

    public static String getCrc64(String sequence) {
        long crc64Number = 0L;
        for (int i = 0; i < sequence.length(); ++i) {
            char symbol2 = sequence.charAt(i);
            long a = crc64Number >>> 8;
            long b = (crc64Number ^ (long)symbol2) & 0xFFL;
            crc64Number = a ^ _crc64Array[(int)b];
        }
        String crc64String = Long.toHexString(crc64Number).toUpperCase();
        StringBuffer crc64 = new StringBuffer("0000000000000000");
        crc64.replace(crc64.length() - crc64String.length(), crc64.length(), crc64String);
        return crc64.toString();
    }

    static {
        for (int i = 0; i <= 255; ++i) {
            long k = i;
            for (int j = 0; j < 8; ++j) {
                if ((k & 1L) != 0L) {
                    k = k >>> 1 ^ 0xD800000000000000L;
                    continue;
                }
                k >>>= 1;
            }
            Crc64._crc64Array[i] = k;
        }
    }
}

