/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRClosure;
import org.renjin.eval.Context;
import org.renjin.sexp.Closure;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;

public class IRFunction {
    private static int nextDebugId = 1;
    private final PairList formals;
    private final SEXP body;
    private final IRBody block;
    private final int debugId;

    public IRFunction(PairList formals2, SEXP body2, IRBody block) {
        this.formals = formals2;
        this.body = body2;
        this.block = block;
        this.debugId = nextDebugId++;
    }

    public int getId() {
        return this.debugId;
    }

    public IRBody getBody() {
        return this.block;
    }

    public PairList getFormals() {
        return this.formals;
    }

    public Closure newClosure(Context context) {
        return new IRClosure(context.getEnvironment(), this);
    }

    public SEXP getBodyExpression() {
        return this.body;
    }

    public String toString() {
        return "function@" + this.debugId;
    }
}

