/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac.functions;

import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.expressions.Constant;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.PrimitiveCall;
import org.renjin.compiler.ir.tac.functions.FunctionCallTranslator;
import org.renjin.compiler.ir.tac.functions.TranslationContext;
import org.renjin.compiler.ir.tac.statements.ExprStatement;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class DollarAssignTranslator
extends FunctionCallTranslator {
    @Override
    public Symbol getName() {
        return Symbol.get("$<-");
    }

    @Override
    public Expression translateToExpression(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        Expression object2 = builder.translateExpression(context, (SEXP)call2.getArgument(0));
        Symbol index = (Symbol)call2.getArgument(1);
        Expression replacement = builder.translateExpression(context, (SEXP)call2.getArgument(2));
        return new PrimitiveCall(call2, "$<-", builder.simplify(object2), new Constant(index), replacement);
    }

    @Override
    public void addStatement(IRBodyBuilder builder, TranslationContext context, FunctionCall call2) {
        builder.addStatement(new ExprStatement(builder.translateExpression(context, (SEXP)call2.getArgument(2))));
    }

    @Override
    public Expression translateToSetterExpression(IRBodyBuilder builder, TranslationContext context, FunctionCall call2, Expression rhs) {
        Expression object2 = builder.translateExpression(context, (SEXP)call2.getArgument(0));
        Symbol index = (Symbol)call2.getArgument(1);
        return new PrimitiveCall(call2, "$<-", object2, new Constant(index), builder.simplify(rhs));
    }
}

