/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.invoke.reflection;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.reflection.AbstractOverload;
import org.renjin.invoke.reflection.ConstructorFunction;
import org.renjin.invoke.reflection.ExceptionUtil;
import org.renjin.invoke.reflection.MemberBinding;
import org.renjin.sexp.SEXP;

public class ConstructorBinding
implements MemberBinding {
    private List<Overload> overloads = Lists.newArrayList();
    private int maxArgCount;

    public ConstructorBinding(Constructor[] overloads) {
        for (Constructor constructor : overloads) {
            if ((constructor.getModifiers() & 1) == 0) continue;
            Overload overload = new Overload(constructor);
            if (overload.getArgCount() > this.maxArgCount) {
                this.maxArgCount = overload.getArgCount();
            }
            this.overloads.add(overload);
        }
        AbstractOverload.sortOverloads(this.overloads);
    }

    public boolean isEmpty() {
        return this.overloads.isEmpty();
    }

    @Override
    public SEXP getValue(Object instance) {
        return new ConstructorFunction(this);
    }

    @Override
    public void setValue(Object instance, SEXP value) {
        throw new EvalException("The constructor of JVM classes cannot be changed", new Object[0]);
    }

    public Object newInstance(Context context, List<SEXP> arguments) {
        for (Overload overload : this.overloads) {
            if (!overload.accept(arguments)) continue;
            return overload.newInstance(context, arguments);
        }
        throw new EvalException("Cannot match arguments (%s) to any of the constructors:\n%s", ExceptionUtil.toString(arguments), ExceptionUtil.overloadListToString(this.overloads));
    }

    public static class Overload
    extends AbstractOverload {
        private Constructor constructor;

        public Overload(Constructor constructor) {
            super(constructor.getParameterTypes(), constructor.getParameterAnnotations(), constructor.isVarArgs());
            this.constructor = constructor;
        }

        public Object newInstance(Context context, List<SEXP> args2) {
            try {
                return this.constructor.newInstance(this.convertArguments(context, args2));
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return this.constructor.toString();
        }
    }
}

