/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text.regex;

import java.io.Serializable;

public class REProgram
implements Serializable {
    static final int OPT_HASBACKREFS = 1;
    static final int OPT_HASBOL = 2;
    char[] instruction;
    int lenInstruction;
    char[] prefix;
    int flags;
    int maxParens = -1;

    public REProgram(char[] instruction) {
        this(instruction, instruction.length);
    }

    public REProgram(int parens, char[] instruction) {
        this(instruction, instruction.length);
        this.maxParens = parens;
    }

    public REProgram(char[] instruction, int lenInstruction) {
        this.setInstructions(instruction, lenInstruction);
    }

    public char[] getInstructions() {
        if (this.lenInstruction != 0) {
            char[] ret = new char[this.lenInstruction];
            System.arraycopy(this.instruction, 0, ret, 0, this.lenInstruction);
            return ret;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setInstructions(char[] instruction, int lenInstruction) {
        this.instruction = instruction;
        this.lenInstruction = lenInstruction;
        this.flags = 0;
        this.prefix = null;
        if (instruction == null) return;
        if (lenInstruction <= 0) return;
        char firstOp = instruction[0];
        if (firstOp == 'A') {
            char lenAtom = instruction[1];
            this.prefix = new char[lenAtom];
            System.arraycopy(instruction, 3, this.prefix, 0, lenAtom);
        } else if (firstOp == '^') {
            this.flags |= 2;
        }
        int i = 0;
        while (i < lenInstruction) {
            switch (instruction[i + 0]) {
                case '[': {
                    i += instruction[i + 1] * 2;
                    break;
                }
                case 'A': {
                    i += instruction[i + 1];
                    break;
                }
                case '#': {
                    this.flags |= 1;
                    return;
                }
            }
            i += 3;
        }
    }

    public char[] getPrefix() {
        if (this.prefix != null) {
            char[] ret = new char[this.prefix.length];
            System.arraycopy(this.prefix, 0, ret, 0, this.prefix.length);
            return ret;
        }
        return null;
    }
}

