/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.scala;

import java.util.ArrayList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.fife.ui.autocomplete.Completion;
import org.fife.ui.autocomplete.CompletionProvider;
import org.fife.ui.autocomplete.DefaultCompletionProvider;
import org.scijava.log.LogService;
import org.scijava.plugins.scripteditor.scala.ScalaReplCompleter;
import org.scijava.ui.swing.script.autocompletion.ClassUtil;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public class ScalaAutocompletionProvider
extends DefaultCompletionProvider {
    private final LogService logService;
    private final ScalaReplCompleter completer;

    public ScalaAutocompletionProvider(LogService logService) {
        this.logService = logService;
        this.completer = new ScalaReplCompleter(logService);
        this.setParameterizedCompletionParams('(', ", ", ')');
        this.setAutoActivationRules(true, ".");
        new Thread(() -> ClassUtil.ensureCache()).start();
    }

    public List<Completion> getCompletionsImpl(JTextComponent comp) {
        Boolean bl;
        String prefix = "ScalaAutocompletionProvider.getCompletionsImpl - ";
        ArrayList<Completion> completions = new ArrayList<Completion>();
        String currentLine = "";
        String codeWithoutLastLine = "";
        String alreadyEnteredText = this.getAlreadyEnteredText(comp);
        try {
            codeWithoutLastLine = comp.getText(0, comp.getCaretPosition());
            int lastLineBreak = codeWithoutLastLine.lastIndexOf("\n") + 1;
            currentLine = codeWithoutLastLine.substring(lastLineBreak);
            codeWithoutLastLine = codeWithoutLastLine.substring(0, lastLineBreak);
        }
        catch (BadLocationException e1) {
            this.logService.trace((Object)new StringBuilder(20).append(prefix).append("code text extraction").toString(), (Throwable)e1);
            return completions;
        }
        try {
            Seq<Completion> cs = this.completer.completionsFor((CompletionProvider)this, codeWithoutLastLine, currentLine, alreadyEnteredText);
            bl = BoxesRunTime.boxToBoolean((boolean)completions.addAll(CollectionConverters$.MODULE$.SeqHasAsJava(cs).asJava()));
        }
        catch (Exception e) {
            this.logService.trace((Object)new StringBuilder(31).append(prefix).append("Failed to get auto-completions.").toString());
            this.logService.trace((Object)prefix, (Throwable)e);
            bl = BoxedUnit.UNIT;
        }
        return completions;
    }
}

