/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.array;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import org.ojalgo.ProgrammingError;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.AccessAnyD;
import org.ojalgo.access.FactoryAnyD;
import org.ojalgo.access.MutateAnyD;
import org.ojalgo.access.StructureAnyD;
import org.ojalgo.array.Array1D;
import org.ojalgo.array.Array2D;
import org.ojalgo.array.BasicArray;
import org.ojalgo.array.BigArray;
import org.ojalgo.array.BufferArray;
import org.ojalgo.array.ComplexArray;
import org.ojalgo.array.DenseArray;
import org.ojalgo.array.Primitive32Array;
import org.ojalgo.array.Primitive64Array;
import org.ojalgo.array.QuaternionArray;
import org.ojalgo.array.RationalArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.NullaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;

public final class ArrayAnyD<N extends Number>
implements AccessAnyD<N>,
AccessAnyD.Elements,
AccessAnyD.IndexOf,
AccessAnyD.Visitable<N>,
AccessAnyD.Aggregatable<N>,
StructureAnyD.ReducibleTo1D<Array1D<N>>,
StructureAnyD.ReducibleTo2D<Array2D<N>>,
AccessAnyD.Sliceable<N>,
MutateAnyD,
MutateAnyD.Fillable<N>,
MutateAnyD.Modifiable<N>,
MutateAnyD.BiModifiable<N>,
MutateAnyD.Mixable<N>,
Serializable {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(BigArray.FACTORY);
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(ComplexArray.FACTORY);
    public static final Factory<Double> DIRECT32 = new Factory<Double>(BufferArray.DIRECT32);
    public static final Factory<Double> DIRECT64 = new Factory<Double>(BufferArray.DIRECT64);
    public static final Factory<Double> PRIMITIVE32 = new Factory<Double>(Primitive32Array.FACTORY);
    public static final Factory<Double> PRIMITIVE64 = new Factory<Double>(Primitive64Array.FACTORY);
    public static final Factory<Quaternion> QUATERNION = new Factory<Quaternion>(QuaternionArray.FACTORY);
    public static final Factory<RationalNumber> RATIONAL = new Factory<RationalNumber>(RationalArray.FACTORY);
    private final BasicArray<N> myDelegate;
    private final long[] myStructure;

    public static <N extends Number> Factory<N> factory(DenseArray.Factory<N> denseArray) {
        return new Factory<N>(denseArray);
    }

    private ArrayAnyD() {
        this(null, new long[0]);
    }

    ArrayAnyD(BasicArray<N> delegate, long[] structure) {
        this.myDelegate = delegate;
        this.myStructure = structure;
    }

    @Override
    public void add(long index, double addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long index, Number addend) {
        this.myDelegate.add(index, addend);
    }

    @Override
    public void add(long[] reference, double addend) {
        this.myDelegate.add(StructureAnyD.index(this.myStructure, reference), addend);
    }

    @Override
    public void add(long[] reference, Number addend) {
        this.myDelegate.add(StructureAnyD.index(this.myStructure, reference), addend);
    }

    @Override
    public N aggregateRange(long first, long limit, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitRange(first, limit, visitor);
        return visitor.get();
    }

    @Override
    public Number aggregateSet(int dimension, long dimensionalIndex, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitSet(dimension, dimensionalIndex, visitor);
        return visitor.get();
    }

    @Override
    public Number aggregateSet(long[] initial, int dimension, Aggregator aggregator) {
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        this.visitSet(initial, dimension, visitor);
        return visitor.get();
    }

    @Deprecated
    public Array1D<N> asArray1D() {
        return this.myDelegate.wrapInArray1D();
    }

    public void clear() {
        this.myDelegate.reset();
    }

    @Override
    public long count() {
        return this.myDelegate.count();
    }

    @Override
    public long count(int dimension) {
        return StructureAnyD.count(this.myStructure, dimension);
    }

    @Override
    public double doubleValue(long index) {
        return this.myDelegate.doubleValue(index);
    }

    @Override
    public double doubleValue(long[] ref) {
        return this.myDelegate.doubleValue(StructureAnyD.index(this.myStructure, ref));
    }

    public boolean equals(Object obj) {
        if (obj instanceof ArrayAnyD) {
            ArrayAnyD tmpObj = (ArrayAnyD)obj;
            return Arrays.equals(this.myStructure, tmpObj.shape()) && this.myDelegate.equals(tmpObj.getDelegate());
        }
        return super.equals(obj);
    }

    @Override
    public void fillAll(N value) {
        this.myDelegate.fill(0L, this.count(), 1L, value);
    }

    @Override
    public void fillAll(NullaryFunction<N> supplier) {
        this.myDelegate.fill(0L, this.count(), 1L, supplier);
    }

    @Override
    public void fillOne(long index, Access1D<?> values, long valueIndex) {
        this.myDelegate.fillOne(index, values, valueIndex);
    }

    @Override
    public void fillOne(long index, N value) {
        this.myDelegate.fillOne(index, value);
    }

    @Override
    public void fillOne(long index, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(index, supplier);
    }

    @Override
    public void fillOne(long[] reference, N value) {
        this.myDelegate.fillOne(StructureAnyD.index(this.myStructure, reference), value);
    }

    @Override
    public void fillOne(long[] reference, NullaryFunction<N> supplier) {
        this.myDelegate.fillOne(StructureAnyD.index(this.myStructure, reference), supplier);
    }

    @Override
    public void fillRange(long first, long limit, N value) {
        this.myDelegate.fill(first, limit, 1L, value);
    }

    @Override
    public void fillRange(long first, long limit, NullaryFunction<N> supplier) {
        this.myDelegate.fill(first, limit, 1L, supplier);
    }

    @Override
    public void fillSet(int dimension, long dimensionalIndex, N value) {
        this.loop(dimension, dimensionalIndex, (long f, long l, long s) -> this.myDelegate.fill(f, l, s, (Number)value));
    }

    @Override
    public void fillSet(int dimension, long dimensionalIndex, NullaryFunction<N> supplier) {
        this.loop(dimension, dimensionalIndex, (long f, long l, long s) -> this.myDelegate.fill(f, l, s, supplier));
    }

    @Override
    public void fillSet(long[] initial, int dimension, N value) {
        this.loop(initial, dimension, (long f, long l, long s) -> this.myDelegate.fill(f, l, s, (Number)value));
    }

    @Override
    public void fillSet(long[] initial, int dimension, NullaryFunction<N> supplier) {
        this.loop(initial, dimension, (long f, long l, long s) -> this.myDelegate.fill(f, l, s, supplier));
    }

    @Override
    public N get(long index) {
        return this.myDelegate.get(index);
    }

    @Override
    public N get(long[] ref) {
        return this.myDelegate.get(StructureAnyD.index(this.myStructure, ref));
    }

    public int hashCode() {
        return this.myDelegate.hashCode();
    }

    @Override
    public long indexOfLargest() {
        return this.myDelegate.indexOfLargest();
    }

    @Override
    public long indexOfLargestInRange(long first, long limit) {
        return this.myDelegate.indexOfLargestInRange(first, limit);
    }

    @Override
    public boolean isAbsolute(long index) {
        return this.myDelegate.isAbsolute(index);
    }

    @Override
    public boolean isAbsolute(long[] reference) {
        return this.myDelegate.isAbsolute(StructureAnyD.index(this.myStructure, reference));
    }

    @Override
    public boolean isSmall(long index, double comparedTo) {
        return this.myDelegate.isSmall(index, comparedTo);
    }

    @Override
    public boolean isSmall(long[] reference, double comparedTo) {
        return this.myDelegate.isSmall(StructureAnyD.index(this.myStructure, reference), comparedTo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double mix(long[] reference, BinaryFunction<N> mixer, double addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            double oldValue = this.doubleValue(reference);
            double newValue = mixer.invoke(oldValue, addend);
            this.set(reference, newValue);
            return newValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public N mix(long[] reference, BinaryFunction<N> mixer, N addend) {
        ProgrammingError.throwIfNull(mixer);
        BasicArray<N> basicArray = this.myDelegate;
        synchronized (basicArray) {
            N oldValue = this.get(reference);
            N newValue = mixer.invoke(oldValue, addend);
            this.set(reference, (Number)newValue);
            return newValue;
        }
    }

    @Override
    public void modifyAll(UnaryFunction<N> modifier) {
        this.myDelegate.modify(0L, this.count(), 1L, modifier);
    }

    @Override
    public void modifyMatching(Access1D<N> left, BinaryFunction<N> function) {
        this.myDelegate.modify(0L, this.count(), 1L, left, function);
    }

    @Override
    public void modifyMatching(BinaryFunction<N> function, Access1D<N> right) {
        this.myDelegate.modify(0L, this.count(), 1L, function, right);
    }

    @Override
    public void modifyOne(long index, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(index, modifier);
    }

    @Override
    public void modifyOne(long[] reference, UnaryFunction<N> modifier) {
        this.myDelegate.modifyOne(StructureAnyD.index(this.myStructure, reference), modifier);
    }

    @Override
    public void modifyRange(long first, long limit, UnaryFunction<N> modifier) {
        this.myDelegate.modify(first, limit, 1L, modifier);
    }

    @Override
    public void modifySet(int dimension, long dimensionalIndex, UnaryFunction<N> modifier) {
        this.loop(dimension, dimensionalIndex, (long f, long l, long s) -> this.myDelegate.modify(f, l, s, modifier));
    }

    @Override
    public void modifySet(long[] initial, int dimension, UnaryFunction<N> modifier) {
        this.loop(initial, dimension, (long f, long l, long s) -> this.myDelegate.modify(f, l, s, modifier));
    }

    @Override
    public int rank() {
        return this.myStructure.length;
    }

    @Override
    public Array1D<N> reduce(int dimension, Aggregator aggregator) {
        long reduceToCount = StructureAnyD.count(this.myStructure, dimension);
        Array1D retVal = ((BasicArray)this.myDelegate.factory().makeZero(reduceToCount)).wrapInArray1D();
        this.reduce(dimension, aggregator, retVal);
        return retVal;
    }

    @Override
    public Array2D<N> reduce(int rowDimension, int columnDimension, Aggregator aggregator) {
        long[] structure = this.shape();
        long numberOfRows = structure[rowDimension];
        long numberOfColumns = structure[columnDimension];
        AggregatorFunction<N> visitor = aggregator.getFunction(this.myDelegate.factory().aggregator());
        boolean primitive = this.myDelegate.isPrimitive();
        Array2D retVal = ((BasicArray)this.myDelegate.factory().makeZero(numberOfRows * numberOfColumns)).wrapInArray2D(numberOfRows);
        for (long j = 0L; j < numberOfColumns; ++j) {
            long colInd = j;
            for (long i = 0L; i < numberOfRows; ++i) {
                long rowInd = i;
                visitor.reset();
                this.loop(reference -> reference[rowDimension] == rowInd && reference[columnDimension] == colInd, index -> this.visitOne(index, visitor));
                if (primitive) {
                    retVal.set(rowInd, colInd, visitor.doubleValue());
                    continue;
                }
                retVal.set(rowInd, colInd, (Number)visitor.get());
            }
        }
        return retVal;
    }

    @Override
    public void set(long index, double value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long index, Number value) {
        this.myDelegate.set(index, value);
    }

    @Override
    public void set(long[] reference, double value) {
        this.myDelegate.set(StructureAnyD.index(this.myStructure, reference), value);
    }

    @Override
    public void set(long[] reference, Number value) {
        this.myDelegate.set(StructureAnyD.index(this.myStructure, reference), value);
    }

    @Override
    public long[] shape() {
        return this.myStructure;
    }

    @Override
    public Array1D<N> sliceRange(long first, long limit) {
        return this.myDelegate.wrapInArray1D().sliceRange(first, limit);
    }

    @Override
    public Array1D<N> sliceSet(long[] initial, int dimension) {
        AtomicLong first = new AtomicLong();
        AtomicLong limit = new AtomicLong();
        AtomicLong step = new AtomicLong();
        this.loop(initial, dimension, (long f, long l, long s) -> {
            first.set(f);
            limit.set(l);
            step.set(s);
        });
        return new Array1D<N>(this.myDelegate, first.longValue(), limit.longValue(), step.longValue());
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder();
        retVal.append('<');
        retVal.append(this.myStructure[0]);
        for (int i = 1; i < this.myStructure.length; ++i) {
            retVal.append('x');
            retVal.append(this.myStructure[i]);
        }
        retVal.append('>');
        int tmpLength = (int)this.count();
        if (tmpLength >= 1 && tmpLength <= 100) {
            retVal.append(' ');
            retVal.append(this.myDelegate.toString());
        }
        return retVal.toString();
    }

    @Override
    public void visitAll(VoidFunction<N> visitor) {
        this.myDelegate.visit(0L, this.count(), 1L, visitor);
    }

    @Override
    public void visitOne(long index, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(index, visitor);
    }

    @Override
    public void visitOne(long[] reference, VoidFunction<N> visitor) {
        this.myDelegate.visitOne(StructureAnyD.index(this.myStructure, reference), visitor);
    }

    @Override
    public void visitRange(long first, long limit, VoidFunction<N> visitor) {
        this.myDelegate.visit(first, limit, 1L, visitor);
    }

    @Override
    public void visitSet(int dimension, long dimensionalIndex, VoidFunction<N> visitor) {
        this.loop(dimension, dimensionalIndex, (long f, long l, long s) -> this.myDelegate.visit(f, l, s, visitor));
    }

    @Override
    public void visitSet(long[] initial, int dimension, VoidFunction<N> visitor) {
        this.loop(initial, dimension, (long f, long l, long s) -> this.myDelegate.visit(f, l, s, visitor));
    }

    final BasicArray<N> getDelegate() {
        return this.myDelegate;
    }

    public static final class Factory<N extends Number>
    implements FactoryAnyD<ArrayAnyD<N>> {
        private final BasicArray.Factory<N> myDelegate;

        Factory(DenseArray.Factory<N> denseArray) {
            this.myDelegate = BasicArray.factory(denseArray);
        }

        @Override
        public final ArrayAnyD<N> copy(AccessAnyD<?> source) {
            return ((BasicArray)this.myDelegate.copy(source)).wrapInArrayAnyD(source.shape());
        }

        public final FunctionSet<N> function() {
            return this.myDelegate.function();
        }

        @Override
        public final ArrayAnyD<N> makeFilled(long[] structure, NullaryFunction<?> supplier) {
            return ((BasicArray)this.myDelegate.makeFilled(StructureAnyD.count(structure), (NullaryFunction)supplier)).wrapInArrayAnyD(structure);
        }

        @Override
        public final ArrayAnyD<N> makeZero(long ... structure) {
            return this.myDelegate.makeStructuredZero(structure).wrapInArrayAnyD(structure);
        }

        public final Scalar.Factory<N> scalar() {
            return this.myDelegate.scalar();
        }
    }
}

