/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.access.Access1D;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.SelectingStore;
import org.ojalgo.scalar.Scalar;

final class RowsStore<N extends Number>
extends SelectingStore<N> {
    private final int[] myRows;

    RowsStore(MatrixStore<N> base, int ... rows) {
        super(base, rows.length, (int)base.countColumns());
        this.myRows = rows;
    }

    @Override
    public double doubleValue(long row, long col) {
        return this.getBase().doubleValue(this.myRows[(int)row], col);
    }

    @Override
    public int firstInRow(int row) {
        return this.getBase().firstInRow(this.myRows[row]);
    }

    @Override
    public N get(long row, long col) {
        return this.getBase().get(this.myRows[(int)row], col);
    }

    @Override
    public int limitOfRow(int row) {
        return this.getBase().limitOfRow(this.myRows[row]);
    }

    @Override
    public void multiply(Access1D<N> right, ElementsConsumer<N> target) {
        if (this.isPrimitive()) {
            target.countRows();
            long tmpComplexity = this.countColumns();
            long tmpTargetColumns = target.countColumns();
            MatrixStore tmpBase = this.getBase();
            for (int i = 0; i < this.myRows.length; ++i) {
                int tmpRow = this.myRows[i];
                int tmpFirst = tmpBase.firstInRow(tmpRow);
                int tmpLimit = tmpBase.limitOfRow(tmpRow);
                for (long j = 0L; j < tmpTargetColumns; ++j) {
                    double tmpVal = PrimitiveMath.ZERO;
                    for (int c = tmpFirst; c < tmpLimit; ++c) {
                        tmpVal += tmpBase.doubleValue(tmpRow, c) * right.doubleValue((long)c + j * tmpComplexity);
                    }
                    target.set((long)i, j, tmpVal);
                }
            }
        } else {
            super.multiply(right, target);
        }
    }

    @Override
    public void supplyTo(ElementsConsumer<N> consumer) {
        MatrixStore tmpBase = this.getBase();
        for (int r = 0; r < this.myRows.length; ++r) {
            consumer.fillRow((long)r, 0L, tmpBase.sliceRow(this.myRows[r], 0L));
        }
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.getBase().toScalar(this.myRows[(int)row], column);
    }
}

