/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.composite;

import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.roi.BoundaryType;
import net.imglib2.roi.KnownConstant;
import net.imglib2.roi.MaskInterval;
import net.imglib2.roi.Operators;
import net.imglib2.roi.composite.BinaryCompositeMaskPredicate;
import net.imglib2.util.Intervals;

public class DefaultBinaryCompositeMaskInterval
extends AbstractWrappedInterval<Interval>
implements BinaryCompositeMaskPredicate<Localizable>,
MaskInterval {
    private final Operators.BinaryMaskOperator operator;
    private final Predicate<? super Localizable> arg0;
    private final Predicate<? super Localizable> arg1;
    private final BoundaryType boundaryType;
    private final Predicate<? super Localizable> predicate;
    private final BinaryOperator<KnownConstant> knownConstantOp;

    public DefaultBinaryCompositeMaskInterval(Operators.BinaryMaskOperator operator, Predicate<? super Localizable> arg0, Predicate<? super Localizable> arg1, Interval interval, BoundaryType boundaryType, BinaryOperator<KnownConstant> knownConstantOp) {
        super(interval);
        this.operator = operator;
        this.arg0 = arg0;
        this.arg1 = arg1;
        this.boundaryType = boundaryType;
        this.predicate = operator.predicate(arg0, arg1);
        this.knownConstantOp = knownConstantOp;
    }

    @Override
    public BoundaryType boundaryType() {
        return this.boundaryType;
    }

    @Override
    public KnownConstant knownConstant() {
        return Intervals.isEmpty((Interval)((Interval)this.sourceInterval)) ? KnownConstant.ALL_FALSE : (KnownConstant)((Object)this.knownConstantOp.apply(KnownConstant.of(this.arg0), KnownConstant.of(this.arg1)));
    }

    @Override
    public boolean test(Localizable localizable) {
        return this.predicate.test((Localizable)localizable);
    }

    @Override
    public Operators.BinaryMaskOperator operator() {
        return this.operator;
    }

    @Override
    public Predicate<? super Localizable> arg0() {
        return this.arg0;
    }

    @Override
    public Predicate<? super Localizable> arg1() {
        return this.arg1;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof BinaryCompositeMaskPredicate) || !(obj instanceof MaskInterval)) {
            return false;
        }
        BinaryCompositeMaskPredicate b = (BinaryCompositeMaskPredicate)obj;
        return b.operator() == this.operator && this.arg0.equals(b.arg0()) && this.arg1.equals(b.arg1());
    }

    public int hashCode() {
        return (this.arg0.hashCode() * this.arg0.hashCode() + this.arg1.hashCode() * this.arg1.hashCode() + this.operator.hashCode()) * 47;
    }
}

