/*
 * Decompiled with CFR 0.152.
 */
package VolumeJ;

import VolumeJ.VJMatrix;
import VolumeJ.VJRenderView;
import VolumeJ.VJRenderer;
import VolumeJ.VJViewerCanvas;
import ij.IJ;
import ij.ImagePlus;
import ij.process.ImageProcessor;

public class VJRenderViewInteractive
extends VJRenderView {
    protected ImagePlus imp;

    public VJRenderViewInteractive(ImagePlus imp, VJRenderer renderer, double scale, String message) {
        super(renderer, message);
        this.scale = (float)scale;
        this.imp = imp;
        renderer.setViewport(imp.getWidth(), imp.getHeight());
        VJViewerCanvas canvas = (VJViewerCanvas)imp.getWindow().getCanvas();
        canvas.setRenderView(this);
        this.computeTransformationMatrix();
    }

    public void rotateInPlane(float anglex, float angley) {
        VJMatrix mm = new VJMatrix();
        mm.rotatex(anglex);
        this.m.mul(mm);
        this.mLight.mul(mm);
        mm = new VJMatrix();
        mm.rotatey(angley);
        this.m.mul(mm);
        IJ.log((String)("rotated by: " + anglex + ", " + angley + " starting rendering now..."));
        this.newView();
    }

    public void newView() {
        if (!this.running) {
            IJ.log((String)"newView not initialized!");
        }
        this.renderer.setTransformation(this.m, this.mLight);
        long start = System.currentTimeMillis();
        ImageProcessor ip = this.renderToImageProcessor();
        this.imp.setProcessor(this.message, ip);
        long elapsedTime = System.currentTimeMillis() - start;
        this.report(elapsedTime);
    }

    @Override
    public synchronized void run() {
        this.running = true;
        this.setPriority(1);
        this.newView();
        while (this.running) {
        }
    }
}

