/*
 * Decompiled with CFR 0.152.
 */
package registration;

import bijfit.Maximum;
import bijnum.BIJmatrix;
import bijnum.BIJmi;
import ij.IJ;
import numericalMethods.calculus.minimizing.nmPowell;
import registration.RegisterMI;
import registration.SearchMI;
import volume.Equalize;
import volume.Hessian;

public class RegisterRetina
extends RegisterMI {
    protected float[] referenceDisk;

    public RegisterRetina(float[] reference, int width, float[] mask) {
        this.mask = mask;
        IJ.showStatus((String)"Registering...equalizing reference image");
        IJ.showStatus((String)"Registering...equalizing");
        reference = Equalize.sliding(reference, width, 0.0f, 25, true);
        IJ.showStatus((String)"Registering...finding blobs");
        float[] blobs = Hessian.det(reference, width, 10.0);
        float[] mblobs = BIJmatrix.mulElements(blobs, mask);
        IJ.showStatus((String)"Registering...estimating disk location");
        this.referenceDisk = Maximum.findSubpixel(mblobs, width);
        RegisterRetina.makeMaskedNaN(reference, this.mask);
        this.minmaxref = BIJmatrix.minmax(reference);
        this.width = width;
        this.reference = reference;
    }

    @Override
    public float[] register(float[] a) {
        IJ.showStatus((String)"Registering...equalizing");
        a = Equalize.sliding(a, this.width, 0.0f, 25, true);
        IJ.showStatus((String)"Registering...finding disk");
        float[] blobs = Hessian.det(a, this.width, 10.0);
        float[] mblobs = BIJmatrix.mulElements(blobs, this.mask);
        IJ.showStatus((String)"Registering...estimating translation");
        float[] approx = Maximum.findSubpixel(mblobs, this.width);
        approx = BIJmatrix.sub(this.referenceDisk, approx);
        IJ.showStatus((String)"Registering...masking");
        RegisterRetina.makeMaskedNaN(a, this.mask);
        float[] minmaxa = BIJmatrix.minmax(a);
        float min = Math.min(minmaxa[0], this.minmaxref[0]);
        float max = Math.max(minmaxa[1], this.minmaxref[1]);
        float scale = BIJmi.getNiceScale(min, max);
        IJ.showStatus((String)"Registering...maximizing MI");
        SearchMI function = new SearchMI(min, max, scale, this.reference, a, this.width);
        double[] p = new double[function.getDoubleArrayParameterLength()];
        p[0] = approx[0];
        p[1] = approx[1];
        p[2] = 0.0;
        function.setDoubleArrayParameter(p, 0);
        nmPowell.search(p, 0.001, function, function, 10, true);
        IJ.showStatus((String)"Registering...registering slice");
        this.estimate = new float[p.length];
        for (int i = 0; i < p.length; ++i) {
            this.estimate[i] = (float)p[i];
        }
        return this.estimate;
    }

    public static float[] featureBlobs(float[] image, int width) {
        return Hessian.det(image, width, 10.0);
    }

    public static float[] featureEdges(float[] image, int width) {
        return Hessian.largest(image, width, 1.5);
    }

    public static void makeMaskedNaN(float[] image, float[] mask) {
        for (int i = 0; i < image.length; ++i) {
            if (mask[i] != 0.0f) continue;
            image[i] = Float.NaN;
        }
    }
}

