/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.iterator;

import net.imglib2.AbstractRealInterval;
import net.imglib2.Iterator;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.util.Util;

public class LocalizingRealIntervalIterator
extends AbstractRealInterval
implements Iterator,
RealLocalizable {
    protected final double[] step;
    protected final double[] location;

    public LocalizingRealIntervalIterator(RealInterval interval, double[] step) {
        super(interval);
        this.step = step;
        this.location = new double[interval.numDimensions()];
        this.reset();
    }

    public LocalizingRealIntervalIterator(double[] min, double[] max, double[] step) {
        super(min, max);
        this.step = step;
        this.location = new double[this.numDimensions()];
        this.reset();
    }

    @Override
    public void reset() {
        this.realMin(this.location);
        this.location[0] = this.location[0] - this.step[0];
    }

    @Override
    public boolean hasNext() {
        for (int d = 0; d < this.numDimensions(); ++d) {
            if (!(this.location[d] + this.step[d] <= this.realMax(d))) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return Util.printCoordinates(this);
    }

    @Override
    public void localize(float[] position) {
        for (int d = 0; d < position.length; ++d) {
            position[d] = (float)this.location[d];
        }
    }

    @Override
    public void localize(double[] position) {
        System.arraycopy(this.location, 0, position, 0, position.length);
    }

    @Override
    public float getFloatPosition(int d) {
        return (float)this.location[d];
    }

    @Override
    public double getDoublePosition(int d) {
        return this.location[d];
    }

    @Override
    public void jumpFwd(long steps) {
        int i = 0;
        while ((long)i < steps) {
            this.fwd();
            ++i;
        }
    }

    @Override
    public void fwd() {
        for (int d = 0; d < this.numDimensions(); ++d) {
            this.fwdDim(d);
            if (this.location[d] <= this.realMax(d)) break;
            this.location[d] = this.realMin(d);
        }
    }

    private void fwdDim(int d) {
        int n = d;
        this.location[n] = this.location[n] + this.step[d];
    }
}

