/*
 * Decompiled with CFR 0.152.
 */
import ij.IJ;
import ij.ImagePlus;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.plugin.BrowserLauncher;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.MedianCut;
import ij.process.ShortProcessor;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MultipleImageProcessor
implements PlugIn {
    private JButton inputFolder;
    private JButton outputFolder;
    private JButton plain2Button;
    private JButton MacroRunner;
    private JTextField inputFolderField;
    private JTextField outputFolderField;
    private JTextField resizeBarField;
    private JTextField MacroRunnerFileField;
    private JTextField BlueSettingField;
    private JLabel inputFolderLabel;
    private JLabel outputFolderLabel;
    private JLabel resizeBarLabel;
    private JLabel MacroRunnerFileLabel;
    private JLabel BlueSettingLabel;
    private JComboBox saveChoicesBox;
    private JComboBox yesOrNoAligmentBox;
    private JComboBox yesOrNoBlueRemovalBox;
    private JComboBox origianlTypeBox;
    private JComboBox vhDataSetBox;
    private static JSlider resizeBar;
    private static String[] saveChoices;
    private static String[] vhDataSet;
    private static String[] origianlType;
    private static String[] aligmentOpts;
    private static String[] yesOrNoBlueRemoval;
    private static String dtdefault;
    private static String vhdsdefault;
    private static String aa;
    private static String br;
    private static String format;
    private static String title;
    static String DirIn;
    static String DirOut;
    static String FileMacro;
    static double[] bcf;
    boolean sameSettings = false;
    boolean openImage = false;
    static boolean runmacro;
    Hashtable maleTable;
    ImagePlus imp;
    static boolean canceled;
    int slice;

    public void run(String arg) {
        GenericDialog od = new GenericDialog("Multiple Image Processor");
        this.vhDataSetBox = new JComboBox<String>(vhDataSet);
        this.saveChoicesBox = new JComboBox<String>(saveChoices);
        this.yesOrNoAligmentBox = new JComboBox<String>(aligmentOpts);
        this.yesOrNoBlueRemovalBox = new JComboBox<String>(yesOrNoBlueRemoval);
        this.origianlTypeBox = new JComboBox<String>(origianlType);
        this.origianlTypeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MultipleImageProcessor.this.origianlTypeBox.getSelectedItem() == "CT" || MultipleImageProcessor.this.origianlTypeBox.getSelectedItem() == "MRI") {
                    MultipleImageProcessor.this.BlueSettingField.setEditable(false);
                    MultipleImageProcessor.this.yesOrNoAligmentBox.setEnabled(false);
                    MultipleImageProcessor.this.yesOrNoAligmentBox.setSelectedIndex(0);
                    MultipleImageProcessor.this.yesOrNoBlueRemovalBox.setEnabled(false);
                    MultipleImageProcessor.this.yesOrNoBlueRemovalBox.setSelectedIndex(0);
                    MultipleImageProcessor.this.BlueSettingField.repaint();
                } else if (MultipleImageProcessor.this.vhDataSetBox.getSelectedItem() == "Male") {
                    MultipleImageProcessor.this.BlueSettingField.setEditable(true);
                    MultipleImageProcessor.this.yesOrNoAligmentBox.setEnabled(true);
                    MultipleImageProcessor.this.yesOrNoBlueRemovalBox.setEnabled(true);
                    MultipleImageProcessor.this.BlueSettingField.repaint();
                } else if (MultipleImageProcessor.this.vhDataSetBox.getSelectedItem() == "Female") {
                    MultipleImageProcessor.this.BlueSettingField.setEditable(true);
                    MultipleImageProcessor.this.yesOrNoAligmentBox.setSelectedIndex(0);
                    MultipleImageProcessor.this.yesOrNoAligmentBox.setEnabled(false);
                    MultipleImageProcessor.this.yesOrNoBlueRemovalBox.setEnabled(true);
                    MultipleImageProcessor.this.BlueSettingField.repaint();
                }
            }
        });
        JLabel outputFormatedType = new JLabel("Output Image Format Type :       ");
        JLabel autoAlignLabel = new JLabel("Anatomy Images Auto Align :     ");
        JLabel blueRemovalLabel = new JLabel("Apply Blue Gel Removal Filter:   ");
        JLabel vhDataSetLabel = new JLabel("Visible Human Data Set :           ");
        JLabel dataTypeLabel = new JLabel("Data Type :                                ");
        if (IJ.isWindows()) {
            dataTypeLabel = new JLabel("Data Type :                                    ");
        }
        JLabel dataLocationLabel = new JLabel("Data Location:                                ");
        JLabel BlueSettingLabel = new JLabel("Blue Threshold:");
        Panel AboutPanel = new Panel();
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("About");
        JMenuItem ciarItem = new JMenuItem("CIAR...");
        ActionListener lst = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BrowserLauncher hb = new BrowserLauncher();
                try {
                    BrowserLauncher.openURL((String)"http://rcmi.rcm.upr.edu/research/inform.html");
                }
                catch (Exception f) {
                    JOptionPane.showMessageDialog(null, "http://rcmi.rcm.upr.edu/research/inform.html");
                }
            }
        };
        ciarItem.addActionListener(lst);
        JMenuItem vhpItem = new JMenuItem("MIP Program..");
        ActionListener snd = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String AboutMessage = new String();
                AboutMessage = "Multiple Image Processor, CIAR, Nathaniel Gonzalez 2005";
                BrowserLauncher hb = new BrowserLauncher();
                JOptionPane.showMessageDialog(null, AboutMessage, "Multiple Image Processor", 1);
            }
        };
        vhpItem.addActionListener(snd);
        menu.add(ciarItem);
        menu.add(vhpItem);
        menuBar.add(menu);
        AboutPanel.add(menuBar);
        Panel outputDataTypePanel = new Panel();
        outputDataTypePanel.setLayout(new GridLayout(1, 2, 5, 5));
        outputDataTypePanel.add(outputFormatedType);
        outputDataTypePanel.add(this.saveChoicesBox);
        this.inputFolderLabel = new JLabel("Input Folder:     ");
        this.inputFolderField = new JTextField(DirIn, 11);
        Panel inputPanel = new Panel();
        inputPanel.setLayout(new GridLayout(1, 3));
        this.inputFolder = new JButton("SELECT");
        inputPanel.add(this.inputFolderLabel);
        inputPanel.add(this.inputFolderField);
        inputPanel.add(this.inputFolder);
        this.outputFolderLabel = new JLabel("Output Folder:     ");
        this.outputFolderField = new JTextField(DirOut, 11);
        Panel outputFolderPanel = new Panel();
        outputFolderPanel.setLayout(new GridLayout(1, 3));
        this.outputFolder = new JButton("SELECT");
        outputFolderPanel.add(this.outputFolderLabel);
        outputFolderPanel.add(this.outputFolderField);
        outputFolderPanel.add(this.outputFolder);
        this.resizeBarLabel = new JLabel("Resize Percent:        ");
        this.resizeBarField = new JTextField(4);
        this.resizeBarField.setText("100");
        Panel resizeSetPanel = new Panel();
        resizeBar = new JSlider(0, 1, 100, 100);
        resizeBar.setMajorTickSpacing(10);
        resizeBar.setPaintTicks(true);
        resizeSetPanel.add(this.resizeBarLabel);
        resizeSetPanel.add(this.resizeBarField);
        resizeSetPanel.add(resizeBar);
        this.MacroRunnerFileLabel = new JLabel("Macro File:     ");
        this.MacroRunnerFileField = new JTextField(FileMacro, 11);
        Panel MacroRunnerPanel = new Panel();
        MacroRunnerPanel.setLayout(new GridLayout(1, 3));
        this.MacroRunner = new JButton("SELECT");
        MacroRunnerPanel.add(this.MacroRunnerFileLabel);
        MacroRunnerPanel.add(this.MacroRunnerFileField);
        MacroRunnerPanel.add(this.MacroRunner);
        od.addPanel(AboutPanel, 13, new Insets(5, 0, 0, 25));
        od.addPanel(inputPanel);
        od.addPanel(outputFolderPanel);
        od.addPanel(resizeSetPanel);
        od.addPanel(MacroRunnerPanel);
        od.addPanel(outputDataTypePanel);
        String ot = this.origianlTypeBox.getSelectedItem() + "";
        String ds = (String)this.vhDataSetBox.getSelectedItem();
        String br = (String)this.yesOrNoBlueRemovalBox.getSelectedItem();
        String al = (String)this.yesOrNoAligmentBox.getSelectedItem();
        String sc = (String)this.saveChoicesBox.getSelectedItem();
        ButtonHandler handler = new ButtonHandler();
        this.outputFolder.addActionListener(handler);
        this.inputFolder.addActionListener(handler);
        this.MacroRunner.addActionListener(handler);
        ciarItem.addActionListener(handler);
        resizeBar.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MultipleImageProcessor.this.resizeBarField.setText(resizeBar.getValue() + "");
                MultipleImageProcessor.this.resizeBarField.repaint();
            }
        });
        od.showDialog();
        if (od.wasCanceled()) {
            return;
        }
        if ((String)this.origianlTypeBox.getSelectedItem() == "CT" && (String)this.saveChoicesBox.getSelectedItem() == "Tiff" || (String)this.origianlTypeBox.getSelectedItem() == "MRI" && (String)this.saveChoicesBox.getSelectedItem() == "Tiff") {
            JOptionPane.showMessageDialog(null, "Image Cannot be Saved as a regular Tiff it will be instead be\nsaved as 8bit Tiff");
            this.saveChoicesBox.setSelectedItem("8-bit Tiff");
        }
        this.convert(DirIn, DirOut, (String)this.origianlTypeBox.getSelectedItem(), (String)this.saveChoicesBox.getSelectedItem(), (String)this.yesOrNoBlueRemovalBox.getSelectedItem(), (String)this.yesOrNoAligmentBox.getSelectedItem(), (String)this.vhDataSetBox.getSelectedItem());
    }

    public void convert(String dir1, String dir2, String original, String format, String blueremoval, String autoalign, String vhDataSet) {
        IJ.resetEscape();
        IJ.log((String)"");
        IJ.log((String)("Converting to " + format));
        if (!dir2.endsWith(File.separator)) {
            dir2 = dir2 + File.separator;
        }
        IJ.log((String)("dir1: " + dir1));
        IJ.log((String)("dir2: " + dir2));
        String[] list = new File(dir1).list();
        if (list == null) {
            return;
        }
        this.openImage = false;
        if (runmacro) {
            this.openImage = true;
        }
        IJ.run((String)"Colors...", (String)"foreground=white background=black selection=yellow");
        for (int i = 0; i < list.length && !IJ.escapePressed(); ++i) {
            IJ.log((String)(i + 1 + ": " + list[i]));
            IJ.showStatus((String)(i + "/" + list.length));
            File f = new File(dir1 + list[i]);
            if (f.isDirectory() || !list[i].endsWith("jpeg") && !list[i].endsWith("JPEG") && !list[i].endsWith("jpg") && !list[i].endsWith("JPG") && !list[i].endsWith("bmp") && !list[i].endsWith("BMP") && !list[i].endsWith("gif") && !list[i].endsWith("GIF") && !list[i].endsWith("tiff") && !list[i].endsWith("TIFF") && !list[i].endsWith("tif") && !list[i].endsWith("TIF") && !list[i].endsWith("pgm") && !list[i].endsWith("PGM")) continue;
            ImagePlus img = new ImagePlus(dir1 + "/" + list[i]);
            String parameter = new String();
            String parameter2 = new String();
            String parameter3 = new String();
            parameter = "name=" + list[i] + " type=RGB fill_with=black width=2148 height=1316 slices=1";
            parameter2 = "name=" + list[i] + " type=RGB fill_with=black width=2048 height=1216 slices=1";
            parameter3 = "width=2048 height=1500 position=Top-Center zero";
            if (runmacro && FileMacro != null) {
                img.show();
                IJ.run((String)"Select None");
                IJ.runMacroFile((String)FileMacro, (String)"");
                IJ.run((String)"Select None");
            }
            if (img == null || img == null) continue;
            this.save(img, dir2, format, autoalign, blueremoval);
        }
        IJ.showProgress((double)1.0);
        IJ.showStatus((String)"");
    }

    public void save(ImagePlus img, String dir, String format, String autoalign, String blueremoval) {
        String name = img.getTitle();
        int dotIndex = name.lastIndexOf(".");
        if (dotIndex >= 0) {
            name = name.substring(0, dotIndex);
        }
        String path = dir + name;
        if (resizeBar.getValue() != 100) {
            double scale = (double)resizeBar.getValue() / 100.0;
            ImageProcessor ip = img.getProcessor();
            int width = ip.getWidth();
            int height = ip.getHeight();
            ip.setInterpolate(true);
            ip = ip.resize((int)((double)width * scale), (int)((double)height * scale));
            img.setProcessor(null, ip);
        }
        if (format.equals("Tiff")) {
            new FileSaver(img).saveAsTiff(path + ".tif");
        } else if (format.equals("8-bit Tiff")) {
            this.saveAs8bitTiff(img, path + ".tif");
        } else if (format.equals("Jpeg")) {
            new FileSaver(img).saveAsJpeg(path + ".jpg");
        } else if (format.equals("Bmp")) {
            new FileSaver(img).saveAsBmp(path + ".bmp");
        } else if (format.equals("Raw")) {
            new FileSaver(img).saveAsRaw(path + ".raw");
        }
        if (runmacro) {
            IJ.run((String)"Close");
        }
    }

    public ImagePlus process(ImagePlus img) {
        return img;
    }

    public ImagePlus AlignImage(ImagePlus img, ImageProcessor ip) {
        return img;
    }

    void saveAs8bitTiff(ImagePlus img, String path) {
        ImageProcessor ip = img.getProcessor();
        if (ip instanceof ColorProcessor) {
            ip = this.reduceColors(ip);
            img.setProcessor(null, ip);
        } else if (ip instanceof ShortProcessor || ip instanceof FloatProcessor) {
            ip = ip.convertToByte(true);
            img.setProcessor(null, ip);
        }
        new FileSaver(img).saveAsTiff(path);
    }

    ImageProcessor reduceColors(ImageProcessor ip) {
        MedianCut mc = new MedianCut((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
        Image img = mc.convert(256);
        return new ByteProcessor(img);
    }

    static {
        saveChoices = new String[]{"Tiff", "8-bit Tiff", "Jpeg", "Bmp"};
        vhDataSet = new String[]{"Male", "Female"};
        origianlType = new String[]{"Anatomy", "CT", "MRI"};
        aligmentOpts = new String[]{"No", "Yes"};
        yesOrNoBlueRemoval = new String[]{"No", "Yes"};
        dtdefault = "Anatomy";
        vhdsdefault = "Male";
        aa = "No";
        br = "No";
        format = "Tiff";
        title = "Example";
        DirIn = "";
        DirOut = "";
        FileMacro = "";
        bcf = new double[1];
        MultipleImageProcessor.bcf[0] = 0.9;
        runmacro = false;
    }

    private class ButtonHandler
    implements ActionListener {
        private ButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String s = "";
            if (e.getSource() == MultipleImageProcessor.this.inputFolder) {
                JFileChooser fileChooser = new JFileChooser();
                fileChooser.setDialogTitle("Input Folder");
                fileChooser.setFileSelectionMode(1);
                int result = fileChooser.showOpenDialog(null);
                DirIn = fileChooser.getSelectedFile() + "";
                if (DirIn != null + "") {
                    MultipleImageProcessor.this.inputFolderField.setText(fileChooser.getSelectedFile() + "");
                    MultipleImageProcessor.this.inputFolderField.repaint();
                }
            } else if (e.getSource() == MultipleImageProcessor.this.outputFolder) {
                JFileChooser fileChooserOutput = new JFileChooser();
                fileChooserOutput.setDialogTitle("Output Folder");
                fileChooserOutput.setFileSelectionMode(1);
                int result = fileChooserOutput.showOpenDialog(null);
                DirOut = fileChooserOutput.getSelectedFile() + "";
                if (DirOut != null + "") {
                    MultipleImageProcessor.this.outputFolderField.setText(fileChooserOutput.getSelectedFile() + "");
                    MultipleImageProcessor.this.outputFolderField.repaint();
                }
            } else if (e.getSource() == MultipleImageProcessor.this.MacroRunner) {
                JFileChooser fileChooserOutput = new JFileChooser();
                fileChooserOutput.setDialogTitle("Macro Run File");
                fileChooserOutput.setFileSelectionMode(0);
                int result = fileChooserOutput.showOpenDialog(null);
                FileMacro = fileChooserOutput.getSelectedFile() + "";
                if (FileMacro != null + "") {
                    MultipleImageProcessor.this.MacroRunnerFileField.setText(fileChooserOutput.getSelectedFile() + "");
                    MultipleImageProcessor.this.MacroRunnerFileField.repaint();
                    runmacro = true;
                } else {
                    MultipleImageProcessor.this.MacroRunnerFileField.setText("");
                    runmacro = false;
                }
            }
        }
    }
}

