/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import ij.VirtualStack;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import loci.formats.ChannelMerger;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.Modulo;
import loci.formats.cache.Cache;
import loci.formats.cache.CacheException;
import loci.formats.cache.CrosshairStrategy;
import loci.formats.cache.ICacheSource;
import loci.formats.cache.ICacheStrategy;
import loci.plugins.util.ImageProcessorReader;
import loci.plugins.util.ImageProcessorSource;
import loci.plugins.util.RecordedImageProcessor;

public class BFVirtualStack
extends VirtualStack {
    protected ImageProcessorReader reader;
    protected String id;
    protected Cache cache;
    private List<List<RecordedImageProcessor.MethodEntry>> methodStacks;
    private int currentSlice = -1;
    private RecordedImageProcessor currentProcessor;
    private boolean colorize;
    private boolean merge;
    private boolean record;
    private int series;
    private int[] len;
    private int[] planeIndexes;
    private float[] calibrationTable;

    protected static int getWidth(IFormatReader r, String path, int series) throws FormatException, IOException {
        r.setSeries(series);
        return r.getSizeX();
    }

    protected static int getHeight(IFormatReader r, String path, int series) throws FormatException, IOException {
        r.setSeries(series);
        return r.getSizeY();
    }

    public BFVirtualStack(String path, IFormatReader r, boolean colorize, boolean merge, boolean record) throws FormatException, IOException, CacheException {
        super(BFVirtualStack.getWidth(r, path, r.getSeries()), BFVirtualStack.getHeight(r, path, r.getSeries()), null, path);
        this.reader = new ImageProcessorReader(r);
        this.id = path;
        this.colorize = colorize;
        this.merge = merge && !r.isIndexed();
        this.record = record;
        this.series = r.getSeries();
        Modulo moduloC = r.getModuloC();
        int[] subC = moduloC.length() > 1 ? new int[]{r.getSizeC() / moduloC.length(), moduloC.length()} : new int[]{r.getSizeC()};
        if (merge) {
            subC = new int[]{new ChannelMerger(r).getEffectiveSizeC()};
        }
        this.len = new int[subC.length + 2];
        System.arraycopy(subC, 0, this.len, 0, subC.length);
        this.len[this.len.length - 2] = r.getSizeZ();
        this.len[this.len.length - 1] = r.getSizeT();
        CrosshairStrategy strategy = new CrosshairStrategy(this.len);
        this.cache = new Cache((ICacheStrategy)strategy, (ICacheSource)new ImageProcessorSource(r), true);
        this.methodStacks = new ArrayList<List<RecordedImageProcessor.MethodEntry>>();
        for (int i = 0; i < r.getImageCount(); ++i) {
            this.methodStacks.add(new ArrayList());
        }
    }

    public String getPath() {
        return this.id;
    }

    public ImageProcessorReader getReader() {
        return this.reader;
    }

    public Cache getCache() {
        return this.cache;
    }

    public RecordedImageProcessor getRecordedProcessor() {
        return this.currentProcessor;
    }

    public List<RecordedImageProcessor.MethodEntry> getMethodStack() {
        if (this.currentSlice >= 0) {
            return this.methodStacks.get(this.currentSlice);
        }
        return null;
    }

    public void setPlaneIndexes(int[] planeIndexes) {
        this.planeIndexes = planeIndexes;
    }

    public synchronized ImageProcessor getProcessor(int n) {
        List<RecordedImageProcessor.MethodEntry> currentStack;
        this.reader.setSeries(this.series);
        if (this.currentSlice >= 0 && this.currentProcessor != null && (currentStack = this.currentProcessor.getMethodStack()).size() > 1) {
            this.methodStacks.get(this.currentSlice).addAll(currentStack);
        }
        int sliceIndex = this.planeIndexes == null ? n - 1 : this.planeIndexes[n - 1];
        int[] pos = this.reader.getZCTCoords(sliceIndex);
        if (this.merge) {
            pos = new ChannelMerger((IFormatReader)this.reader).getZCTCoords(sliceIndex);
        }
        int[] cachePos = FormatTools.rasterToPosition((int[])this.len, (int)sliceIndex);
        ImageProcessor ip = null;
        try {
            ip = (ImageProcessor)this.cache.getObject(cachePos);
            this.cache.setCurrentPos(cachePos);
        }
        catch (CacheException exc) {
            exc.printStackTrace();
        }
        try {
            if (ip == null) {
                ip = this.reader.openProcessors(this.reader.getIndex(pos[0], pos[1], pos[2]))[0];
            }
        }
        catch (FormatException exc) {
            exc.printStackTrace();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        if (this.colorize) {
            byte[] lut = new byte[256];
            byte[] blank = new byte[256];
            for (int i = 0; i < lut.length; ++i) {
                lut[i] = (byte)i;
                blank[i] = 0;
            }
            IndexColorModel model = null;
            model = pos[1] < 3 ? new IndexColorModel(8, 256, pos[1] == 0 ? lut : blank, pos[1] == 1 ? lut : blank, pos[1] == 2 ? lut : blank) : new IndexColorModel(8, 256, lut, lut, lut);
            if (ip != null) {
                ip.setColorModel((ColorModel)model);
            }
        } else if (this.merge) {
            this.currentSlice = n - 1;
            ImageProcessor[] otherChannels = new ImageProcessor[this.reader.getSizeC() - 1];
            for (int i = 0; i < otherChannels.length; ++i) {
                int channel = i >= pos[1] ? i + 1 : i;
                try {
                    cachePos[0] = channel;
                    otherChannels[i] = (ImageProcessor)this.cache.getObject(cachePos);
                }
                catch (CacheException exc) {
                    exc.printStackTrace();
                }
                if (otherChannels[i] != null) continue;
                try {
                    int index = this.reader.getIndex(pos[0], channel, pos[2]);
                    otherChannels[i] = this.reader.openProcessors(index)[0];
                    continue;
                }
                catch (FormatException exc) {
                    exc.printStackTrace();
                    continue;
                }
                catch (IOException exc) {
                    exc.printStackTrace();
                }
            }
            this.currentProcessor = new RecordedImageProcessor(ip, pos[1], otherChannels);
            this.currentProcessor.setDoRecording(this.record);
            if (this.calibrationTable == null) {
                this.calibrationTable = this.currentProcessor.getChild().getCalibrationTable();
            } else {
                this.currentProcessor.setCalibrationTable(this.calibrationTable);
            }
            return this.currentProcessor.getChild();
        }
        if (ip != null) {
            this.currentSlice = n - 1;
            this.currentProcessor = new RecordedImageProcessor(ip);
            this.currentProcessor.setDoRecording(this.record);
            if (this.calibrationTable == null) {
                this.calibrationTable = this.currentProcessor.getChild().getCalibrationTable();
            } else {
                this.currentProcessor.setCalibrationTable(this.calibrationTable);
            }
            return this.currentProcessor.getChild();
        }
        return null;
    }

    public int getWidth() {
        this.reader.setSeries(this.series);
        return this.reader.getSizeX();
    }

    public int getHeight() {
        this.reader.setSeries(this.series);
        return this.reader.getSizeY();
    }

    public int getSize() {
        if (this.reader.getCurrentFile() == null) {
            return 0;
        }
        this.reader.setSeries(this.series);
        if (this.merge) {
            return new ChannelMerger((IFormatReader)this.reader).getImageCount();
        }
        return this.planeIndexes == null ? this.reader.getImageCount() : this.planeIndexes.length;
    }
}

