/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.log;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.scijava.log.CallingClassUtils;
import org.scijava.log.DefaultLogger;
import org.scijava.log.IgnoreAsCallingClass;
import org.scijava.log.LogLevel;
import org.scijava.log.LogListener;
import org.scijava.log.LogMessage;
import org.scijava.log.LogService;
import org.scijava.log.LogSource;
import org.scijava.log.Logger;
import org.scijava.service.AbstractService;

@IgnoreAsCallingClass
public abstract class AbstractLogService
extends AbstractService
implements LogService {
    private int currentLevel = this.levelFromEnvironment();
    private final Map<String, Integer> classAndPackageLevels;
    private final Logger rootLogger = new RootLogger();

    public AbstractLogService() {
        this(System.getProperties());
    }

    public AbstractLogService(Properties properties) {
        int level = LogLevel.value(properties.getProperty("scijava.log.level"));
        if (level >= 0) {
            this.currentLevel = level;
        }
        this.classAndPackageLevels = this.setupMapFromProperties(properties, "scijava.log.level:");
        this.initLogSourceLevels(properties);
    }

    @Override
    public void setLevel(int level) {
        this.currentLevel = level;
    }

    @Override
    public void setLevel(String classOrPackageName, int level) {
        this.classAndPackageLevels.put(classOrPackageName, level);
    }

    @Override
    public void setLevelForLogger(String source, int level) {
        this.rootLogger.getSource().subSource(source).setLogLevel(level);
    }

    protected abstract void messageLogged(LogMessage var1);

    @Override
    public void alwaysLog(int level, Object msg, Throwable t) {
        this.rootLogger.alwaysLog(level, msg, t);
    }

    @Override
    public LogSource getSource() {
        return this.rootLogger.getSource();
    }

    @Override
    public int getLevel() {
        if (this.classAndPackageLevels.isEmpty()) {
            return this.currentLevel;
        }
        return this.getLevelForClass(CallingClassUtils.getCallingClassName(), this.currentLevel);
    }

    @Override
    public Logger subLogger(String name, int level) {
        return this.rootLogger.subLogger(name, level);
    }

    @Override
    public void addLogListener(LogListener listener) {
        this.rootLogger.addLogListener(listener);
    }

    @Override
    public void removeLogListener(LogListener listener) {
        this.rootLogger.removeLogListener(listener);
    }

    @Override
    public void notifyListeners(LogMessage event) {
        this.rootLogger.notifyListeners(event);
    }

    @Deprecated
    protected String getPrefix(int level) {
        return "[" + LogLevel.prefix(level) + "]";
    }

    private void initLogSourceLevels(Properties properties) {
        Map<String, Integer> nameLevels = this.setupMapFromProperties(properties, "scijava.log.level.source:");
        nameLevels.forEach(this::setLevelForLogger);
    }

    private int getLevelForClass(String classOrPackageName, int defaultLevel) {
        while (classOrPackageName != null) {
            Integer level = this.classAndPackageLevels.get(classOrPackageName);
            if (level != null) {
                return level;
            }
            classOrPackageName = this.parentPackage(classOrPackageName);
        }
        return defaultLevel;
    }

    private String parentPackage(String classOrPackageName) {
        int dot = classOrPackageName.lastIndexOf(".");
        if (dot < 0) {
            return null;
        }
        return classOrPackageName.substring(0, dot);
    }

    private int levelFromEnvironment() {
        return System.getenv("DEBUG") == null ? 3 : 4;
    }

    private Map<String, Integer> setupMapFromProperties(Properties properties, String prefix) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String propName : properties.stringPropertyNames()) {
            if (!propName.startsWith(prefix)) continue;
            String key = propName.substring(prefix.length());
            map.put(key, LogLevel.value(properties.getProperty(propName)));
        }
        return map;
    }

    @IgnoreAsCallingClass
    private class RootLogger
    extends DefaultLogger {
        public RootLogger() {
            super(AbstractLogService.this::messageLogged, LogSource.newRoot(), 0);
        }

        @Override
        public int getLevel() {
            return AbstractLogService.this.getLevel();
        }
    }
}

