/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ij.gui.GenericDialog;
import ij.gui.YesNoCancelDialog;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.tree.DNDTree;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.ProjectTree;
import ini.trakem2.tree.TemplateThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public final class TemplateTree
extends DNDTree
implements MouseListener,
ActionListener {
    private DefaultMutableTreeNode selected_node = null;
    private TemplateThing root;

    public TemplateTree(Project project, TemplateThing root) {
        super(project, DNDTree.makeNode(root, true), new Color(245, 255, 245));
        this.root = root;
        this.setEditable(false);
        this.addMouseListener(this);
        TemplateTree.expandAllNodes(this, (DefaultMutableTreeNode)this.getModel().getRoot());
    }

    @Override
    public void mousePressed(MouseEvent me) {
        JMenuItem item;
        int y;
        Object source = me.getSource();
        if (!source.equals(this) || !this.project.isInputEnabled()) {
            return;
        }
        if (!Utils.isPopupTrigger(me)) {
            return;
        }
        int x = me.getX();
        TreePath path = this.getPathForLocation(x, y = me.getY());
        if (null == path) {
            return;
        }
        this.setSelectionPath(path);
        this.selected_node = (DefaultMutableTreeNode)path.getLastPathComponent();
        final TemplateThing tt = (TemplateThing)this.selected_node.getUserObject();
        String type = tt.getType();
        JPopupMenu popup = new JPopupMenu();
        if (!Project.isBasicType(type) && !tt.isNested()) {
            JMenu menu = new JMenu("Add new child");
            popup.add(menu);
            item = new JMenuItem("new...");
            item.addActionListener(this);
            menu.add(item);
            if (ControlWindow.getProjects().size() > 1) {
                menu.addSeparator();
                JMenu other = new JMenu("From project...");
                menu.add(other);
                for (final Project pr : ControlWindow.getProjects()) {
                    if (this.root.getProject() == pr) continue;
                    item = new JMenuItem(pr.toString());
                    other.add(item);
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            GenericDialog gd = new GenericDialog(pr.toString());
                            gd.addMessage("Project: " + pr.toString());
                            HashMap<String, TemplateThing> hm = pr.getTemplateTree().root.getUniqueTypes(new HashMap<String, TemplateThing>());
                            String[] u_types = hm.keySet().toArray(new String[0]);
                            gd.addChoice("type:", u_types, u_types[0]);
                            gd.showDialog();
                            if (gd.wasCanceled()) {
                                return;
                            }
                            TemplateThing tt_chosen = hm.get(gd.getNextChoice());
                            ArrayList<TemplateThing> al = tt_chosen.collectAllChildren(new ArrayList<TemplateThing>());
                            for (TemplateThing child : al) {
                                if (!TemplateTree.this.root.getProject().typeExists(child.getType())) continue;
                                if (Project.isBasicType(child.getType())) continue;
                                Utils.showMessage("Type conflict: cannot add type " + tt_chosen.getType());
                                return;
                            }
                            TemplateTree.this.addCopiesRecursively(tt, tt_chosen);
                            TemplateTree.this.rebuild(TemplateTree.this.selected_node, true);
                        }
                    });
                }
            }
            menu.addSeparator();
            String[] ut = tt.getProject().getUniqueTypes();
            for (int i = 0; i < ut.length; ++i) {
                item = new JMenuItem(ut[i]);
                item.addActionListener(this);
                menu.add(item);
            }
        }
        item = new JMenuItem("Delete...");
        item.addActionListener(this);
        popup.add(item);
        if (null == this.selected_node.getParent()) {
            item.setEnabled(false);
        }
        if (!Project.isBasicType(type)) {
            item = new JMenuItem("Rename...");
            item.addActionListener(this);
            popup.add(item);
        }
        popup.addSeparator();
        item = new JMenuItem("Export XML template...");
        item.addActionListener(this);
        popup.add(item);
        popup.show(this, x, y);
    }

    private void addCopiesRecursively(TemplateThing target, TemplateThing source) {
        TemplateThing child = new TemplateThing(source.getType(), target.getProject());
        if (target.addChild(child)) {
            child.addToDatabase();
            target.getProject().addUniqueType(child);
            ArrayList<TemplateThing> children = source.getChildren();
            if (null != children) {
                Iterator<TemplateThing> it = children.iterator();
                while (it.hasNext()) {
                    this.addCopiesRecursively(child, it.next());
                }
            }
        }
    }

    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        TemplateThing tt = (TemplateThing)this.selected_node.getUserObject();
        if (command.equals("Rename...")) {
            GenericDialog gd = new GenericDialog("Rename");
            gd.addStringField("New type name: ", tt.getType(), 40);
            gd.showDialog();
            if (gd.wasCanceled()) {
                return;
            }
            String old_name = tt.getType();
            String new_name = gd.getNextString().replace(' ', '_').trim();
            if (null == new_name || 0 == new_name.length() || this.isInvalidTypeName(new_name, false)) {
                Utils.showMessage("Unacceptable new name: '" + new_name + "'");
                return;
            }
            this.renameType(old_name, new_name);
        } else if (command.equals("Delete...")) {
            HashSet<ProjectThing> hs = tt.getProject().getRootProjectThing().collectSimilarThings(tt, new HashSet<ProjectThing>());
            YesNoCancelDialog yn = ControlWindow.makeYesNoCancelDialog("Remove type?", "Really remove type '" + tt.getType() + "'" + (null != tt.getChildren() && 0 != tt.getChildren().size() ? " and its children" : "") + (0 == hs.size() ? "" : " from parent " + tt.getParent().getType() + ",\nand its " + hs.size() + " existing instance" + (1 == hs.size() ? "" : "s") + " in the project tree?"));
            if (!yn.yesPressed()) {
                return;
            }
            ProjectTree project_tree = tt.getProject().getProjectTree();
            for (ProjectThing pt : hs) {
                DefaultMutableTreeNode node;
                Utils.log("\tDeleting ProjectThing: " + pt + " " + pt.getId());
                if (!pt.remove(false)) {
                    Utils.showMessage("Can't delete ProjectThing " + pt + " " + pt.getId());
                }
                if (null != (node = DNDTree.findNode(pt, project_tree))) {
                    ((DefaultTreeModel)project_tree.getModel()).removeNodeFromParent(node);
                    continue;
                }
                Utils.log("Can't find a node for PT " + pt + " " + pt.getId());
            }
            HashSet<TemplateThing> hst = this.root.collectSimilarThings(tt, new HashSet<TemplateThing>());
            HashSet<TemplateThing> hs_same_type = this.root.collectThingsOfEqualType(tt, new HashSet<TemplateThing>());
            Utils.log2("hs_same_type.size() = " + hs_same_type.size());
            for (TemplateThing tet : hst) {
                if (1 != hs_same_type.size() && tet.equals(tet.getProject().getTemplateThing(tet.getType()))) {
                    Utils.log2("avoiding 1");
                } else {
                    Utils.log("\tDeleting TemplateThing: " + tet + " " + tet.getId());
                    if (!tet.remove(false)) {
                        Utils.showMessage("Can't delete TemplateThing" + tet + " " + tet.getId());
                    }
                }
                DefaultMutableTreeNode node = DNDTree.findNode(tet, this);
                if (null != node) {
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
                    continue;
                }
                Utils.log("Can't find a node for TT " + tet + " " + tet.getId());
            }
            if (!tt.isNested() && 1 == hs_same_type.size()) {
                tt.getProject().removeUniqueType(tt.getType());
                Utils.log2("removing unique type");
            } else {
                Utils.log2("avoiding 2");
            }
            this.updateUILater();
            project_tree.updateUILater();
        } else if (command.equals("Export XML template...")) {
            StringBuilder sb = new StringBuilder("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            HashSet<String> hs = new HashSet<String>();
            tt.exportDTD(sb, hs, "");
            Utils.saveToFile(tt.getType(), ".dtd", sb.toString());
        } else {
            TemplateThing tet = null;
            boolean is_new = false;
            String new_child_type = null;
            if (command.equals("new...")) {
                is_new = true;
                GenericDialog gd = ControlWindow.makeGenericDialog("New child");
                gd.addStringField("Type name: ", "");
                gd.showDialog();
                if (gd.wasCanceled()) {
                    return;
                }
                String new_type = gd.getNextString().toLowerCase();
                if (this.isInvalidTypeName(new_type = new_type.replace(' ', '_').trim(), true)) {
                    return;
                }
                if (tt.getProject().typeExists(new_type.toLowerCase())) {
                    Utils.showMessage("Type '" + new_type + "' exists already.\nSelect it from the contextual menu list\nor choose a different name.");
                    return;
                }
                if (Project.isBasicType(new_type.toLowerCase())) {
                    Utils.showMessage("Type '" + new_type + "' is reserved.\nPlease choose a different name.");
                    return;
                }
                new_child_type = new_type;
            } else {
                tet = tt.getProject().getTemplateThing(command);
                if (tt.canHaveAsChild(tet)) {
                    Utils.log("'" + tt.getType() + "' already contains a child of type '" + command + "'");
                    return;
                }
                if (null == tet) {
                    Utils.log("TemplateTree internal error: no type exists for '" + command + "'");
                    return;
                }
                new_child_type = command;
            }
            this.addNewChildType(tt, new_child_type);
        }
    }

    public boolean isInvalidTypeName(String type) {
        return this.isInvalidTypeName(type, false);
    }

    private boolean isInvalidTypeName(String type, boolean showmsg) {
        Pattern pat = Pattern.compile("^[a-zA-Z][a-zA-Z0-9_]*$", 2);
        if (pat.matcher(type).matches()) {
            return false;
        }
        if (showmsg) {
            Utils.showMessage("Only alphanumeric characters, underscore, hyphen and space are accepted.\nAnd the name must start with a character.");
        }
        return true;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.root = null;
        this.selected_node = null;
    }

    private void fillChildren(TemplateThing parent, DefaultMutableTreeNode parent_node) {
        TemplateThing parent_full = parent.getProject().getTemplateThing(parent.getType());
        if (parent.isNested()) {
            return;
        }
        ArrayList<TemplateThing> al_children = parent_full.getChildren();
        if (null == al_children) {
            return;
        }
        for (TemplateThing child : al_children) {
            TemplateThing copy = new TemplateThing(child.getType(), parent.getProject());
            parent.addChild(copy);
            DefaultMutableTreeNode copy_node = new DefaultMutableTreeNode(copy);
            ((DefaultTreeModel)this.getModel()).insertNodeInto(copy_node, parent_node, parent_node.getChildCount());
            this.fillChildren(copy, copy_node);
        }
    }

    public TemplateThing addNewChildType(ProjectThing pt, String new_child_type) {
        if (null == pt.getParent() || null == pt.getTemplate()) {
            return null;
        }
        TemplateThing tt_parent = pt.getTemplate().getChildTemplate(new_child_type);
        if (null != tt_parent) {
            return tt_parent;
        }
        return this.addNewChildType(pt.getTemplate(), new_child_type);
    }

    public TemplateThing addNewChildType(TemplateThing tt_parent, String new_child_type) {
        if (null == tt_parent || null == new_child_type) {
            return null;
        }
        new_child_type = new_child_type.trim().toLowerCase().replace(' ', '_').replace('-', '_').replace('\n', '_').replace('\t', '_');
        TemplateThing tet_child = tt_parent.getProject().getTemplateThing(new_child_type);
        boolean is_new = null == tet_child;
        tet_child = new TemplateThing(null == tet_child ? new_child_type : tet_child.getType(), tt_parent.getProject());
        if (is_new) {
            tt_parent.getProject().addUniqueType(tet_child);
        }
        tt_parent.addChild(tet_child);
        HashSet<TemplateThing> hs = this.root.collectThingsOfEqualType(tt_parent, new HashSet<TemplateThing>());
        for (TemplateThing tti : hs) {
            TemplateThing ttc;
            if (tti.isNested()) continue;
            if (tti.equals(tt_parent)) {
                tti = tt_parent;
                ttc = tet_child;
            } else {
                ttc = new TemplateThing(tet_child.getType(), tt_parent.getProject());
                tti.addChild(ttc);
                ttc.addToDatabase();
            }
            DefaultMutableTreeNode node_parent = DNDTree.findNode(tti, this);
            DefaultMutableTreeNode node_child = new DefaultMutableTreeNode(ttc);
            boolean add = true;
            Enumeration<TreeNode> e = node_parent.children();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode nc = (DefaultMutableTreeNode)e.nextElement();
                TemplateThing ttnc = (TemplateThing)nc.getUserObject();
                if (!ttnc.getType().equals(ttc.getType())) continue;
                add = false;
                break;
            }
            if (add) {
                ((DefaultTreeModel)this.getModel()).insertNodeInto(node_child, node_parent, node_parent.getChildCount());
            }
            Utils.log2("ttc parent: " + ttc.getParent());
            Utils.log2("tti is parent: " + (tti == ttc.getParent()));
            if (is_new) continue;
            this.fillChildren(tet_child, node_child);
            DNDTree.expandAllNodes(this, node_child);
        }
        this.updateUILater();
        return tet_child;
    }

    public boolean renameType(String old_name, String new_name) {
        new_name = new_name.toLowerCase();
        Project project = this.root.getProject();
        if (new_name.equals(old_name)) {
            return true;
        }
        if (project.typeExists(new_name)) {
            Utils.logAll("Type '" + new_name + "' exists already!");
            return false;
        }
        ArrayList<TemplateThing> al = this.root.collectAllChildren(new ArrayList<TemplateThing>());
        al.add(this.root);
        for (TemplateThing tet : al) {
            if (!tet.getType().equals(old_name)) continue;
            tet.rename(new_name);
        }
        project.getRootProjectThing().updateType(new_name, old_name);
        project.updateTypeName(old_name, new_name);
        this.updateUILater();
        project.getProjectTree().updateUILater();
        return true;
    }

    @Override
    protected Thing getRootThing() {
        return this.project.getRootTemplateThing();
    }
}

