/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ij.gui.GUI;
import ij.gui.GenericDialog;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.AreaList;
import ini.trakem2.display.AreaTree;
import ini.trakem2.display.Ball;
import ini.trakem2.display.Connector;
import ini.trakem2.display.Coordinate;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Display3D;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Dissector;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Node;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Pipe;
import ini.trakem2.display.Polyline;
import ini.trakem2.display.Profile;
import ini.trakem2.display.Tag;
import ini.trakem2.display.Tree;
import ini.trakem2.display.Treeline;
import ini.trakem2.display.ZDisplayable;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;

public class Search {
    private JFrame search_frame = null;
    private JTabbedPane search_tabs = null;
    private JTextField search_field = null;
    private JComboBox pulldown = null;
    private KeyListener kl = null;
    private JComboBox projects = null;
    private Map<Project, List<JPanel>> tabMap = Collections.synchronizedMap(new HashMap());
    private static Search instance = null;
    private Class<?>[] types = new Class[]{DBObject.class, Displayable.class, DLabel.class, Patch.class, AreaList.class, Profile.class, Pipe.class, Ball.class, Layer.class, Dissector.class, Polyline.class, Treeline.class, AreaTree.class, Connector.class};

    public static final void showWindow() {
        if (null != instance) {
            instance.makeGUI();
        } else {
            instance = new Search();
        }
    }

    private Search() {
        this.makeGUI();
    }

    private void tryCloseTab(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 87: {
                if (!ke.isControlDown()) {
                    return;
                }
                int ntabs = this.search_tabs.getTabCount();
                if (0 == ntabs) {
                    instance.destroy();
                    return;
                }
                this.search_tabs.remove(this.search_tabs.getSelectedIndex());
                return;
            }
        }
    }

    private void makeGUI() {
        if (null == this.search_frame) {
            this.search_frame = ControlWindow.createJFrame("Search Regular Expressions");
            this.search_frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    instance.destroy();
                }
            });
            this.search_tabs = new JTabbedPane(1);
            this.kl = new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent ke) {
                    Search.this.tryCloseTab(ke);
                }
            };
            this.search_tabs.addKeyListener(this.kl);
            this.search_field = new JTextField(14);
            this.search_field.addKeyListener(new VKEnterListener());
            GridBagLayout gb = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            JPanel all = new JPanel();
            all.setLayout(gb);
            all.setPreferredSize(new Dimension(600, 400));
            JButton b = new JButton("Search");
            b.addActionListener(new ButtonListener());
            this.pulldown = new JComboBox<String>(new String[]{"All", "All displayables", "Labels", "Images", "Area Lists", "Profiles", "Pipes", "Balls", "Layers", "Dissectors", "Polylines", "Treelines", "AreaTrees", "Connectors"});
            ArrayList<Project> ps = Project.getProjects();
            String[] sps = new String[ps.size()];
            int k = 0;
            for (Project p : ps) {
                sps[k++] = p.getTitle();
            }
            this.projects = new JComboBox<String>(sps);
            Display front = Display.getFront();
            if (null != front) {
                this.projects.setSelectedIndex(ps.indexOf(front.getProject()));
            }
            c.gridx = 0;
            c.gridy = 0;
            c.fill = 2;
            c.weightx = 1.0;
            c.insets = new Insets(4, 10, 5, 2);
            gb.setConstraints(this.search_field, c);
            all.add(this.search_field);
            c.gridx = 1;
            c.weightx = 0.0;
            c.insets = new Insets(4, 2, 5, 10);
            gb.setConstraints(b, c);
            all.add(b);
            c.gridx = 2;
            gb.setConstraints(this.pulldown, c);
            all.add(this.pulldown);
            c.gridx = 3;
            gb.setConstraints(this.projects, c);
            all.add(this.projects);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 4;
            c.weightx = 1.0;
            c.weighty = 1.0;
            c.fill = 1;
            c.insets = new Insets(0, 0, 0, 0);
            gb.setConstraints(this.search_tabs, c);
            all.add(this.search_tabs);
            this.search_frame.getContentPane().add(all);
            this.search_frame.pack();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    GUI.center((Window)Search.this.search_frame);
                    Search.this.search_frame.setVisible(true);
                }
            });
        } else {
            this.search_frame.toFront();
        }
    }

    private synchronized void destroy() {
        if (null != instance) {
            if (null != this.search_frame) {
                this.search_frame.dispose();
            }
            this.search_frame = null;
            this.search_tabs = null;
            this.search_field = null;
            this.pulldown = null;
            this.types = null;
            this.kl = null;
            instance = null;
            this.tabMap.clear();
        }
    }

    private void executeSearch() {
        final Project project = Project.getProjects().get(this.projects.getSelectedIndex());
        if (null == project) {
            return;
        }
        Bureaucrat.createAndStart((Worker)new Worker.Task("Searching"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void exec() {
                String path;
                String pattern = Search.this.search_field.getText();
                if (null == pattern || 0 == pattern.length()) {
                    return;
                }
                String typed_pattern = pattern;
                StringBuilder sb = new StringBuilder();
                if (!pattern.startsWith("^")) {
                    sb.append("^.*");
                }
                for (int i = 0; i < pattern.length(); ++i) {
                    sb.append(pattern.charAt(i));
                }
                if (!pattern.endsWith("$")) {
                    sb.append(".*$");
                }
                pattern = sb.toString();
                Pattern pat = Pattern.compile(pattern, 42);
                ArrayList al = new ArrayList();
                Search.this.find(project.getRootLayerSet(), al, Search.this.types[Search.this.pulldown.getSelectedIndex()]);
                if (0 == al.size()) {
                    return;
                }
                Vector<DBObject> v_obs = new Vector<DBObject>();
                Vector<String> v_txt = new Vector<String>();
                Vector v_co = new Vector();
                Object co = null;
                for (DBObject dbo : al) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    boolean matched = false;
                    Displayable d = null;
                    if (dbo instanceof Displayable) {
                        d = (Displayable)dbo;
                    }
                    String meaningful_title = null;
                    String txt = null == d || Patch.class == d.getClass() ? dbo.getTitle() : (meaningful_title = dbo.getProject().getMeaningfulTitle(d));
                    if (null == txt || 0 == txt.trim().length()) continue;
                    matched = pat.matcher(txt).matches();
                    if (!matched && null != d && null != (txt = d.getAnnotation())) {
                        matched = pat.matcher(txt).matches();
                    }
                    if (!matched) {
                        txt = dbo.toString();
                        matched = pat.matcher(txt).matches();
                    }
                    if (!matched && (matched = pat.matcher(txt = Long.toString(dbo.getId())).matches())) {
                        txt = "id: #" + txt;
                    }
                    if (!matched && null != d) {
                        Map<Displayable, Map<String, String>> linked_props;
                        Map<String, String> props = d.getProperties();
                        if (null != props) {
                            for (Map.Entry entry : props.entrySet()) {
                                if (!pat.matcher((CharSequence)entry.getKey()).matches() && !pat.matcher((CharSequence)entry.getValue()).matches()) continue;
                                matched = true;
                                txt = (String)entry.getKey() + " => " + (String)entry.getValue() + " [property]";
                                break;
                            }
                        }
                        if (!matched && null != (linked_props = ((Displayable)dbo).getLinkedProperties())) {
                            block6: for (Map.Entry<Displayable, Map<String, String>> e2 : linked_props.entrySet()) {
                                for (Map.Entry entry : e2.getValue().entrySet()) {
                                    if (!pat.matcher((CharSequence)entry.getKey()).matches() && !pat.matcher((CharSequence)entry.getValue()).matches()) continue;
                                    matched = true;
                                    txt = (String)entry.getKey() + " => " + e2.getValue() + " [linked property]";
                                    continue block6;
                                }
                            }
                        }
                    }
                    if (!matched && dbo instanceof Tree) {
                        Node root = ((Tree)dbo).getRoot();
                        if (null == root) continue;
                        for (Node node : root.getSubtreeNodes()) {
                            Set<Tag> tags = node.getTags();
                            if (null == tags) continue;
                            for (Tag tag : tags) {
                                if (!pat.matcher(tag.toString()).matches()) continue;
                                v_obs.add(dbo);
                                v_txt.add(tag.toString() + " (" + (null == meaningful_title ? dbo.toString() : meaningful_title) + ')');
                                v_co.add(Search.this.createCoordinate((Tree)dbo, node));
                            }
                        }
                        continue;
                    }
                    if (!matched) continue;
                    v_obs.add(dbo);
                    v_txt.add(txt);
                    v_co.add((Coordinate<?>)co);
                }
                if (0 == v_obs.size()) {
                    Utils.showMessage("Nothing found.");
                    return;
                }
                JPanel result = new JPanel();
                GridBagLayout gb = new GridBagLayout();
                result.setLayout(gb);
                GridBagConstraints c = new GridBagConstraints();
                c.anchor = 18;
                c.fill = 2;
                c.insets = new Insets(5, 10, 5, 10);
                String xml = "";
                if (project.getLoader() instanceof FSLoader && null != (path = ((FSLoader)project.getLoader()).getProjectXMLPath())) {
                    xml = " [" + new File(path).getName() + "]";
                }
                JLabel projectTitle = new JLabel(project.getTitle() + xml);
                gb.setConstraints(projectTitle, c);
                result.add(projectTitle);
                c.insets = new Insets(0, 0, 0, 0);
                JPanel padding = new JPanel();
                c.weightx = 1.0;
                gb.setConstraints(padding, c);
                result.add(padding);
                c.gridy = 1;
                c.gridwidth = 2;
                c.fill = 1;
                c.weighty = 1.0;
                JScrollPane jsp = Search.this.makeTable(new DisplayableTableModel(v_obs, v_txt, v_co), project);
                gb.setConstraints(jsp, c);
                result.add(jsp);
                Search.this.search_tabs.addTab(typed_pattern, result);
                Search.this.search_tabs.setSelectedComponent(result);
                Map map = Search.this.tabMap;
                synchronized (map) {
                    void var18_26;
                    List list = (List)Search.this.tabMap.get(project);
                    if (null == list) {
                        ArrayList arrayList = new ArrayList();
                        Search.this.tabMap.put(project, arrayList);
                    }
                    var18_26.add(result);
                }
            }
        }, project);
    }

    private Coordinate<Node<?>> createCoordinate(Tree<?> tree, Node<?> nd) {
        double x = nd.getX();
        double y = nd.getY();
        if (!tree.getAffineTransform().isIdentity()) {
            double[] dp = new double[]{x, y};
            tree.getAffineTransform().transform(dp, 0, dp, 0, 1);
            x = dp[0];
            y = dp[1];
        }
        return new Coordinate(x, y, nd.getLayer(), nd);
    }

    private Coordinate<Displayable> createCoordinate(Displayable d) {
        Layer la;
        Rectangle r = d.getBoundingBox();
        Layer layer = la = d instanceof ZDisplayable ? ((ZDisplayable)d).getFirstLayer() : d.getLayer();
        if (null == la) {
            Display display = Display.getFront(d.getProject());
            la = null == display ? d.getProject().getRootLayerSet().getLayer(0) : display.getLayer();
        }
        return new Coordinate<Displayable>(r.x + r.width / 2, r.y + r.height / 2, la, d);
    }

    private JScrollPane makeTable(TableModel model, Project project) {
        Results table = new Results(model, project);
        table.addMouseListener(new DisplayableListListener());
        table.addKeyListener(this.kl);
        JScrollPane jsp = new JScrollPane(table);
        jsp.setPreferredSize(new Dimension(500, 500));
        return jsp;
    }

    private void find(LayerSet set, ArrayList<DBObject> al, Class<?> type) {
        if (type == DBObject.class) {
            al.add(set);
        }
        for (ZDisplayable zd : set.getZDisplayables()) {
            if (DBObject.class == type || Displayable.class == type) {
                al.add(zd);
                continue;
            }
            if (zd.getClass() != type) continue;
            al.add(zd);
        }
        for (Layer layer : set.getLayers()) {
            if (DBObject.class == type || Layer.class == type) {
                al.add(layer);
            }
            for (Displayable ob : layer.getDisplayables()) {
                if (DBObject.class == type || Displayable.class == type) {
                    if (ob instanceof LayerSet) {
                        this.find((LayerSet)ob, al, type);
                        continue;
                    }
                    al.add(ob);
                    continue;
                }
                if (ob.getClass() != type) continue;
                al.add(ob);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeTabs(Project p) {
        final Search search = instance;
        if (null == search) {
            return;
        }
        Map<Project, List<JPanel>> map = search.tabMap;
        synchronized (map) {
            List<JPanel> cs = search.tabMap.get(p);
            if (null == cs) {
                return;
            }
            for (final JPanel c : cs) {
                Utils.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        search.search_tabs.remove(c);
                    }
                });
            }
            search.tabMap.remove(p);
        }
        if (0 == search.search_tabs.getTabCount()) {
            search.destroy();
        }
    }

    public static void remove(Displayable displ) {
        Search se = instance;
        try {
            if (null == se || null == displ) {
                return;
            }
            List<JPanel> panels = se.tabMap.get(displ.getProject());
            if (null == panels) {
                return;
            }
            for (JPanel p : panels) {
                Results table = (Results)((JScrollPane)p.getComponent(2)).getViewport().getComponent(0);
                DisplayableTableModel data = (DisplayableTableModel)table.getModel();
                if (!data.remove(displ)) continue;
                Utils.updateComponent(p);
            }
        }
        catch (Exception e) {
            IJError.print(e);
            se.destroy();
        }
    }

    public static void repaint(final Object ob) {
        if (null == instance) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int selected = instance.search_tabs.getSelectedIndex();
                if (-1 == selected) {
                    return;
                }
                Component c = instance.search_tabs.getComponentAt(selected);
                JTable table = (JTable)((JScrollPane)c).getViewport().getComponent(0);
                DisplayableTableModel data = (DisplayableTableModel)table.getModel();
                if (data.contains(ob)) {
                    Utils.updateComponent(instance.search_frame);
                }
            }
        });
    }

    private class DisplayableListListener
    extends MouseAdapter {
        private DisplayableListListener() {
        }

        @Override
        public void mousePressed(MouseEvent me) {
            final Results table = (Results)me.getSource();
            int row = table.rowAtPoint(me.getPoint());
            final DBObject ob = ((DisplayableTableModel)table.getModel()).getDBObjectAt(row);
            Coordinate<?> co = ((DisplayableTableModel)table.getModel()).getCoordinateAt(row);
            if (2 == me.getClickCount()) {
                if (null != co) {
                    Display.centerAt(co);
                } else if (ob instanceof Displayable) {
                    Display.centerAt(Search.this.createCoordinate((Displayable)ob), true, me.isShiftDown());
                } else if (ob instanceof Layer) {
                    Display.showFront((Layer)ob);
                } else {
                    Utils.log2("Search: Unhandable table selection: " + ob);
                }
            } else if (Utils.isPopupTrigger(me)) {
                final int numRowsSelected = table.getSelectedRowCount();
                if (0 == numRowsSelected) {
                    return;
                }
                JPopupMenu popup = new JPopupMenu();
                String show2D = "Show";
                String select = "Select in display";
                String show3D = "Show in 3D";
                String openNodeTable = "Show tabular view";
                ActionListener listener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent ae) {
                        String command = ae.getActionCommand();
                        if (command.equals("Show")) {
                            if (ob instanceof Displayable) {
                                Display.centerAt(Search.this.createCoordinate((Displayable)ob), true, 0 != (ae.getModifiers() & 1));
                            } else if (ob instanceof Layer) {
                                Display.showFront((Layer)ob);
                            }
                        } else if (command.equals("Select in display")) {
                            if (ob instanceof Layer) {
                                Display.showFront((Layer)ob);
                            } else if (ob instanceof Displayable) {
                                if (0 == numRowsSelected) {
                                    return;
                                }
                                if (1 == numRowsSelected) {
                                    Display display;
                                    Displayable displ = (Displayable)ob;
                                    if (!displ.isVisible()) {
                                        displ.setVisible(true);
                                    }
                                    if (null == (display = Display.getFront(displ.getProject()))) {
                                        return;
                                    }
                                    boolean shift_down = 0 != (ae.getModifiers() & 1);
                                    display.select(displ, shift_down);
                                } else {
                                    ArrayList<Displayable> ds = new ArrayList<Displayable>();
                                    Display display = null;
                                    HashSet<Layer> layers = new HashSet<Layer>();
                                    for (int row : table.getSelectedRows()) {
                                        DBObject dob = ((DisplayableTableModel)table.getModel()).getDBObjectAt(row);
                                        if (null == dob || !(dob instanceof Displayable)) {
                                            Utils.log("Not selecting row " + row);
                                            continue;
                                        }
                                        Displayable d = (Displayable)dob;
                                        ds.add(d);
                                        if (!(d instanceof ZDisplayable)) {
                                            layers.add(d.getLayer());
                                        }
                                        if (null != display) continue;
                                        display = Display.getFront(dob.getProject());
                                    }
                                    if (layers.size() > 0) {
                                        GenericDialog gd = new GenericDialog("All layers?");
                                        String[] s = new String[]{"Only from current layer", "From " + layers.size() + " layers"};
                                        gd.addChoice("Select objects from:", s, s[0]);
                                        gd.showDialog();
                                        if (gd.wasCanceled()) {
                                            return;
                                        }
                                        if (0 == gd.getNextChoiceIndex()) {
                                            Layer la = display.getLayer();
                                            Iterator it = ds.iterator();
                                            while (it.hasNext()) {
                                                if (((Displayable)it.next()).getLayer() == la) continue;
                                                it.remove();
                                            }
                                        }
                                    }
                                    display.getSelection().selectAll(ds);
                                }
                            }
                        } else if (command.equals("Show in 3D")) {
                            ProjectThing pt;
                            if (ob instanceof Displayable && null != (pt = ob.getProject().findProjectThing(ob))) {
                                Display3D.show(pt);
                            }
                        } else if (command.equals("Show tabular view") && ob instanceof Tree) {
                            ((Tree)ob).createMultiTableView();
                        }
                    }
                };
                JMenuItem item = new JMenuItem("Show");
                popup.add(item);
                item.addActionListener(listener);
                item = new JMenuItem("Select in display");
                popup.add(item);
                item.addActionListener(listener);
                popup.addSeparator();
                item = new JMenuItem("Show in 3D");
                popup.add(item);
                item.addActionListener(listener);
                if (ob instanceof Tree) {
                    item = new JMenuItem("Show tabular view");
                    item.addActionListener(listener);
                    popup.add(item);
                }
                popup.show(table, me.getX(), me.getY());
            }
        }
    }

    private class VKEnterListener
    extends KeyAdapter {
        private VKEnterListener() {
        }

        @Override
        public void keyPressed(KeyEvent ke) {
            if (ke.getKeyCode() == 10) {
                Search.this.executeSearch();
                return;
            }
            Search.this.tryCloseTab(ke);
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            Search.this.executeSearch();
        }
    }

    private class Results
    extends JTable {
        private final Project project;

        private Results(TableModel model, Project project) {
            super(model);
            this.project = project;
        }
    }

    private class DisplayableTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private Vector<DBObject> v_obs;
        private Vector<String> v_txt;
        private Vector<Coordinate<?>> v_co;

        DisplayableTableModel(Vector<DBObject> v_obs, Vector<String> v_txt, Vector<Coordinate<?>> v_co) {
            this.v_obs = v_obs;
            this.v_txt = v_txt;
            this.v_co = v_co;
        }

        @Override
        public String getColumnName(int col) {
            if (0 == col) {
                return "Type";
            }
            if (1 == col) {
                return "Info";
            }
            if (2 == col) {
                return "Matched";
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return this.v_obs.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (0 == col) {
                return Project.getName(this.v_obs.get(row).getClass());
            }
            if (1 == col) {
                return this.v_obs.get(row).getShortTitle();
            }
            if (2 == col) {
                return this.v_txt.get(row);
            }
            return "";
        }

        public DBObject getDBObjectAt(int row) {
            return this.v_obs.get(row);
        }

        public Coordinate<?> getCoordinateAt(int row) {
            return this.v_co.get(row);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
        }

        public boolean remove(Displayable displ) {
            int i = this.v_obs.indexOf(displ);
            if (-1 != i) {
                this.v_obs.remove(i);
                this.v_txt.remove(i);
                this.v_co.remove(i);
                return true;
            }
            return false;
        }

        public boolean contains(Object ob) {
            return this.v_obs.contains(ob);
        }
    }
}

