/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.models;

import java.util.Arrays;
import java.util.function.Consumer;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.DiskCachedCellImgFactory;
import net.imglib2.cache.img.DiskCachedCellImgOptions;
import net.imglib2.img.Img;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import sc.fiji.labkit.ui.models.CachedImageFactory;
import sc.fiji.labkit.ui.segmentation.Segmenter;

public class DefaultCachedImageFactory
implements CachedImageFactory {
    public static CachedImageFactory getInstance() {
        return new DefaultCachedImageFactory();
    }

    private DefaultCachedImageFactory() {
    }

    @Override
    public <T extends NativeType<T>> Img<T> setupCachedImage(Segmenter segmenter, Consumer<RandomAccessibleInterval<T>> loader, CellGrid grid, T type) {
        int[] cellDimensions = DefaultCachedImageFactory.getCellDimensions(grid);
        long[] imgDimensions = grid.getImgDimensions();
        Arrays.setAll(cellDimensions, i -> (int)Math.min((long)cellDimensions[i], imgDimensions[i]));
        DiskCachedCellImgOptions optional = (DiskCachedCellImgOptions)((DiskCachedCellImgOptions)DiskCachedCellImgOptions.options().cellDimensions(cellDimensions)).initializeCellsAsDirty(true);
        DiskCachedCellImgFactory factory = new DiskCachedCellImgFactory(type, optional);
        return factory.create(imgDimensions, loader::accept, (DiskCachedCellImgOptions)DiskCachedCellImgOptions.options().initializeCellsAsDirty(true));
    }

    private static int[] getCellDimensions(CellGrid grid) {
        int[] cellDimensions = new int[grid.numDimensions()];
        grid.cellDimensions(cellDimensions);
        return cellDimensions;
    }
}

