/*
 * Decompiled with CFR 0.152.
 */
package bdv.ui;

import bdv.ui.CardPanel;
import bdv.ui.MouseWheelScrollListener;
import bdv.ui.convertersetupeditor.ConverterSetupEditPanel;
import bdv.ui.sourcegrouptree.SourceGroupTree;
import bdv.ui.sourcetable.SourceTable;
import bdv.ui.viewermodepanel.DisplaySettingsPanel;
import bdv.viewer.AbstractViewerPanel;
import bdv.viewer.ConverterSetups;
import bdv.viewer.ViewerState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;

public class BdvDefaultCards {
    public static final String DEFAULT_SOURCES_CARD = "default bdv sources card";
    public static final String DEFAULT_SOURCEGROUPS_CARD = "default bdv groups card";
    public static final String DEFAULT_VIEWERMODES_CARD = "default bdv viewer modes card";

    public static void setup(CardPanel cards, AbstractViewerPanel viewer, ConverterSetups converterSetups) {
        ViewerState state = viewer.state();
        SourceTable table = new SourceTable(state, converterSetups, viewer.getInputTriggerConfig());
        table.setPreferredScrollableViewportSize(new Dimension(300, 200));
        table.setFillsViewportHeight(true);
        table.setDragEnabled(true);
        ConverterSetupEditPanel editPanelTable = new ConverterSetupEditPanel(table, converterSetups);
        JPanel tablePanel = new JPanel(new BorderLayout());
        MyScrollPane scrollPaneTable = new MyScrollPane(table, "Table.background");
        scrollPaneTable.addMouseWheelListener(new MouseWheelScrollListener(scrollPaneTable));
        tablePanel.add((Component)scrollPaneTable, "Center");
        tablePanel.add((Component)editPanelTable, "South");
        tablePanel.setPreferredSize(new Dimension(300, 245));
        SourceGroupTree tree = new SourceGroupTree(state, viewer.getInputTriggerConfig());
        tree.setVisibleRowCount(10);
        tree.setEditable(true);
        tree.setSelectionRow(0);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setExpandsSelectedPaths(true);
        tree.getSelectionModel().setSelectionMode(4);
        ConverterSetupEditPanel editPanelTree = new ConverterSetupEditPanel(tree, converterSetups);
        JPanel treePanel = new JPanel(new BorderLayout());
        MyScrollPane scrollPaneTree = new MyScrollPane(tree, "Tree.background");
        scrollPaneTree.addMouseWheelListener(new MouseWheelScrollListener(scrollPaneTree));
        treePanel.add((Component)scrollPaneTree, "Center");
        treePanel.add((Component)editPanelTree, "South");
        treePanel.setPreferredSize(new Dimension(300, 225));
        cards.addCard(DEFAULT_VIEWERMODES_CARD, "Display Modes", new DisplaySettingsPanel(viewer.state()), true, new Insets(0, 4, 4, 0));
        cards.addCard(DEFAULT_SOURCES_CARD, "Sources", tablePanel, true, new Insets(0, 0, 0, 0));
        cards.addCard(DEFAULT_SOURCEGROUPS_CARD, "Groups", treePanel, true, new Insets(0, 0, 0, 0));
    }

    static class MyScrollPane
    extends JScrollPane {
        private final String bgColorName;

        public MyScrollPane(Component view, String bgColorName) {
            super(view);
            this.bgColorName = bgColorName;
            this.updateBorder();
        }

        @Override
        public void updateUI() {
            super.updateUI();
            if (this.bgColorName != null) {
                this.updateBorder();
            }
        }

        private void updateBorder() {
            this.setBorder(new MatteBorder(0, 4, 0, 0, UIManager.getColor(this.bgColorName)));
        }
    }
}

