/*
 * Decompiled with CFR 0.152.
 */
package bdv.util;

import bdv.util.Bounds;

public final class BoundedRange {
    private final double minBound;
    private final double maxBound;
    private final double min;
    private final double max;

    public BoundedRange(double minBound, double maxBound, double min, double max) {
        if (minBound > min || maxBound < max || min > max) {
            throw new IllegalArgumentException();
        }
        this.minBound = minBound;
        this.maxBound = maxBound;
        this.min = min;
        this.max = max;
    }

    public double getMinBound() {
        return this.minBound;
    }

    public double getMaxBound() {
        return this.maxBound;
    }

    public Bounds getBounds() {
        return new Bounds(this.minBound, this.maxBound);
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public BoundedRange withMax(double newMax) {
        double newMin = Math.min(this.min, newMax);
        double newMinBound = Math.min(this.minBound, newMin);
        double newMaxBound = Math.max(this.maxBound, newMax);
        return new BoundedRange(newMinBound, newMaxBound, newMin, newMax);
    }

    public BoundedRange withMin(double newMin) {
        double newMax = Math.max(this.max, newMin);
        double newMinBound = Math.min(this.minBound, newMin);
        double newMaxBound = Math.max(this.maxBound, newMax);
        return new BoundedRange(newMinBound, newMaxBound, newMin, newMax);
    }

    public BoundedRange withMaxBound(double newMaxBound) {
        double newMinBound = Math.min(this.minBound, newMaxBound);
        double newMin = Math.min(Math.max(this.min, newMinBound), newMaxBound);
        double newMax = Math.min(Math.max(this.max, newMinBound), newMaxBound);
        return new BoundedRange(newMinBound, newMaxBound, newMin, newMax);
    }

    public BoundedRange withMinBound(double newMinBound) {
        double newMaxBound = Math.max(this.maxBound, newMinBound);
        double newMin = Math.min(Math.max(this.min, newMinBound), newMaxBound);
        double newMax = Math.min(Math.max(this.max, newMinBound), newMaxBound);
        return new BoundedRange(newMinBound, newMaxBound, newMin, newMax);
    }

    public BoundedRange join(BoundedRange other) {
        double newMinBound = Math.min(this.minBound, other.minBound);
        double newMaxBound = Math.max(this.maxBound, other.maxBound);
        double newMin = Math.min(this.min, other.min);
        double newMax = Math.max(this.max, other.max);
        return new BoundedRange(newMinBound, newMaxBound, newMin, newMax);
    }

    public String toString() {
        return "BoundedRange[ (" + this.minBound + ") " + this.min + ", " + this.max + " (" + this.maxBound + ") ]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundedRange that = (BoundedRange)o;
        if (Double.compare(that.minBound, this.minBound) != 0) {
            return false;
        }
        if (Double.compare(that.maxBound, this.maxBound) != 0) {
            return false;
        }
        if (Double.compare(that.min, this.min) != 0) {
            return false;
        }
        return Double.compare(that.max, this.max) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.minBound);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxBound);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

